/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.mixin;

import github.jorgaomc.blocks.SanctuaryBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Explosion.class})
public class ExplosionMixin {
    @Shadow
    @Final
    private Level level;
    @Shadow
    @Final
    private double x;
    @Shadow
    @Final
    private double y;
    @Shadow
    @Final
    private double z;

    @Inject(method={"getAffectedBlocks"}, at={@At(value="RETURN")}, cancellable=true)
    private void onGetAffectedBlocks(CallbackInfoReturnable<List<BlockPos>> cir) {
        List affectedBlocks = (List)cir.getReturnValue();
        affectedBlocks.removeIf(pos -> SanctuaryBlock.isExplosionBlocked(this.level, pos));
        cir.setReturnValue((Object)affectedBlocks);
    }

    @Inject(method={"collectBlocksAndDamageEntities"}, at={@At(value="HEAD")}, cancellable=true)
    private void onCollectBlocksAndDamageEntities(CallbackInfo ci) {
        BlockPos explosionCenter = new BlockPos((int)this.x, (int)this.y, (int)this.z);
        if (SanctuaryBlock.isExplosionBlocked(this.level, explosionCenter)) {
            ci.cancel();
        }
    }
}

