/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.mixin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public class HoopaPyramidMixin {
    private static final Map<UUID, Integer> playerCooldowns = new HashMap<UUID, Integer>();
    private static final Map<UUID, Long> lastExecutionTimes = new HashMap<UUID, Long>();
    private static final int FUNCTION_COOLDOWN = 40;
    private static final String TEMPLELOCK1_MARKER_NAME = "templelock1";
    private static final String TEMPLELOCK2_MARKER_NAME = "templelock2";
    private static final String TEMPLELOCK3_MARKER_NAME = "templelock3";
    private static final String UNBREAKABLE_TEMPLE_MARKER_NAME = "unbreakabletemple";
    private static final String HOOPA_BOSS_MARKER_NAME = "hoopaboss";
    private static final String HOOPA_QUESTIONS_MARKER_NAME = "question1";

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void onPlayerTick(CallbackInfo info) {
        ServerPlayer player = (ServerPlayer)this;
        UUID playerId = player.getUUID();
        ServerLevel world = player.serverLevel();
        if (playerCooldowns.containsKey(playerId)) {
            int cooldown = playerCooldowns.get(playerId);
            if (cooldown > 0) {
                playerCooldowns.put(playerId, cooldown - 1);
            } else {
                playerCooldowns.remove(playerId);
            }
        }
        if (!this.isOnCooldown(playerId)) {
            boolean functionExecuted = false;
            if (this.hasNamedArmorStandWithinDistance(world, player, TEMPLELOCK1_MARKER_NAME, 8.0)) {
                this.executeFunction(player, "legendarymonuments:templelock1");
                functionExecuted = true;
            } else if (this.hasNamedArmorStandWithinDistance(world, player, TEMPLELOCK2_MARKER_NAME, 8.0)) {
                this.executeFunction(player, "legendarymonuments:templelock2");
                functionExecuted = true;
            } else if (this.hasNamedArmorStandWithinDistance(world, player, TEMPLELOCK3_MARKER_NAME, 20.0)) {
                this.executeFunction(player, "legendarymonuments:templelock3");
                functionExecuted = true;
            } else if (this.hasNamedArmorStandWithinDistance(world, player, HOOPA_QUESTIONS_MARKER_NAME, 15.0)) {
                this.executeFunction(player, "legendarymonuments:hoopaquestions");
                functionExecuted = true;
            } else if (this.hasNamedArmorStandWithinDistance(world, player, HOOPA_BOSS_MARKER_NAME, 15.0)) {
                this.executeHoopaBossCommands(player);
                functionExecuted = true;
            }
            if (this.hasNamedArmorStandWithinDistance(world, player, UNBREAKABLE_TEMPLE_MARKER_NAME, 50.0)) {
                this.executeFunction(player, "legendarymonuments:unbreakabletemple");
            }
            if (functionExecuted) {
                playerCooldowns.put(playerId, 40);
            }
        }
    }

    private boolean isOnCooldown(UUID playerId) {
        return playerCooldowns.containsKey(playerId) && playerCooldowns.get(playerId) > 0;
    }

    private boolean hasNamedArmorStandWithinDistance(ServerLevel world, ServerPlayer player, String name, double distance) {
        try {
            BlockPos playerPos = player.blockPosition();
            AABB searchBox = new AABB((double)playerPos.getX() - distance, (double)playerPos.getY() - distance, (double)playerPos.getZ() - distance, (double)playerPos.getX() + distance, (double)playerPos.getY() + distance, (double)playerPos.getZ() + distance);
            List armorStands = world.getEntities((EntityTypeTest)EntityType.ARMOR_STAND, searchBox, entity -> entity.hasCustomName() && entity.getCustomName() != null && entity.getCustomName().getString().equals(name));
            return !armorStands.isEmpty();
        }
        catch (Exception e) {
            return false;
        }
    }

    private void executeHoopaBossCommands(ServerPlayer player) {
        MinecraftServer server = player.getServer();
        if (server == null) {
            return;
        }
        CommandSourceStack source = new CommandSourceStack((CommandSource)server, player.position(), player.getRotationVector(), player.serverLevel(), 4, "Server", player.getDisplayName(), server, (Entity)player).withSuppressedOutput();
        try {
            String[] commands = new String[]{"execute at @e[name=hoopaboss,type=armor_stand] run pokespawn hoopa djinn_state=unbound shiny lvl=70 uncatchable held_item=legendarymonuments:temple_key no_ai", "execute at @e[name=hoopaboss,type=armor_stand] run attribute @e[type=cobblemon:pokemon,distance=..5,limit=1,nbt={Pokemon:{Species:\"cobblemon:hoopa\"}}] minecraft:generic.scale base set 0.64", "execute at @e[name=hoopaboss,type=armor_stand] run effect give @e[type=cobblemon:pokemon,sort=nearest,limit=1] minecraft:resistance infinite 99 true", "execute at @e[name=hoopaboss,type=armor_stand] run data modify entity @e[type=cobblemon:pokemon,limit=1,sort=nearest] PersistenceRequired set value 1b", "execute at @e[name=hoopaboss,type=armor_stand] run tp @e[type=cobblemon:pokemon,distance=..20,nbt={Pokemon:{Species:\"cobblemon:hoopa\"}}] @e[type=armor_stand,name=\"hoopaboss\",limit=1]", "execute at @e[name=hoopaboss,type=armor_stand] if entity @e[type=cobblemon:pokemon,distance=..3,nbt={Pokemon:{Species:\"cobblemon:hoopa\"}}] run kill @e[type=armor_stand,name=hoopaboss,distance=..10]"};
            this.scheduleCommandSequence(server, source, commands, 0);
        }
        catch (Exception e) {
            System.err.println("Failed to execute Hoopa boss commands: " + e.getMessage());
        }
    }

    private void scheduleCommandSequence(MinecraftServer server, CommandSourceStack source, String[] commands, int index) {
        if (index >= commands.length) {
            return;
        }
        try {
            server.getCommands().performPrefixedCommand(source, commands[index]);
            if (index + 1 < commands.length) {
                server.execute(() -> {
                    try {
                        Thread.sleep(500L);
                        this.scheduleCommandSequence(server, source, commands, index + 1);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                });
            }
        }
        catch (Exception e) {
            System.err.println("Failed to execute Hoopa boss command " + index + ": " + e.getMessage());
        }
    }

    private void executeFunction(ServerPlayer player, String functionId) {
        MinecraftServer server = player.getServer();
        if (server == null) {
            return;
        }
        CommandSourceStack source = new CommandSourceStack((CommandSource)server, player.position(), player.getRotationVector(), player.serverLevel(), 4, "Server", player.getDisplayName(), server, (Entity)player).withSuppressedOutput();
        try {
            server.getCommands().performPrefixedCommand(source, "function " + functionId);
        }
        catch (Exception e) {
            System.err.println("Failed to execute function " + functionId + ": " + e.getMessage());
        }
    }
}

