/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.mixin;

import github.jorgaomc.blocks.SanctuaryBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockItem.class})
public class ItemUseMixin {
    @Inject(method={"place(Lnet/minecraft/item/ItemPlacementContext;)Lnet/minecraft/util/ActionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onPlace(BlockPlaceContext context, CallbackInfoReturnable<InteractionResult> cir) {
        Level world = context.getLevel();
        Player player = context.getPlayer();
        if (player != null && !player.isCreative() && SanctuaryBlock.isBlockPlacementBlocked(world, context.getClickedPos())) {
            if (world.isClientSide) {
                player.displayClientMessage((Component)Component.literal((String)"This area is protected by a Sanctuary Block. You cannot place blocks here.").withStyle(ChatFormatting.RED), true);
            }
            cir.setReturnValue((Object)InteractionResult.FAIL);
        }
    }
}

