/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.mixin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public class LugiaTempleMixin {
    @Shadow
    @Final
    public MinecraftServer server;
    private static final Map<UUID, Integer> playerCooldowns = new HashMap<UUID, Integer>();
    private static final String LUGIA_TREASURE_LOCK_MARKER_NAME = "lugiatreasurelock";
    private static final String LUGIA_LOCK_MARKER_NAME = "lugialock";
    private static final String LUGIA_LOCK_2_MARKER_NAME = "lugialock2";
    private static final String LUGIA_ENTRANCE_MARKER_NAME = "lugiaentrance";
    private static final String LUGIA_ELEVATOR_MARKER_NAME = "lugiaelevator";
    private static final String LUGIA_DOOR_MARKER_NAME = "lugiadoor";

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void onPlayerTick(CallbackInfo info) {
        ServerPlayer player = (ServerPlayer)this;
        UUID playerId = player.getUUID();
        ServerLevel world = player.serverLevel();
        if (this.hasNamedArmorStandWithinDistance(world, player, LUGIA_TREASURE_LOCK_MARKER_NAME, 10.0)) {
            this.executeFunction(player, "legendarymonuments:lugiatreasurelock");
        }
        if (this.hasNamedArmorStandWithinDistance(world, player, LUGIA_LOCK_MARKER_NAME, 10.0)) {
            this.executeFunction(player, "legendarymonuments:lugialock");
        }
        if (this.hasNamedArmorStandWithinDistance(world, player, LUGIA_LOCK_2_MARKER_NAME, 10.0)) {
            this.executeFunction(player, "legendarymonuments:lugialock2");
        }
        if (this.hasNamedArmorStandWithinDistance(world, player, LUGIA_ENTRANCE_MARKER_NAME, 4.0)) {
            this.executeFunction(player, "legendarymonuments:lugiaentrance");
        }
        if (this.hasNamedArmorStandWithinDistance(world, player, LUGIA_ELEVATOR_MARKER_NAME, 6.0)) {
            this.executeFunction(player, "legendarymonuments:lugiaelevator");
        }
        if (this.hasNamedArmorStandWithinDistance(world, player, LUGIA_DOOR_MARKER_NAME, 8.0)) {
            this.executeFunction(player, "legendarymonuments:lugiadoor");
        }
    }

    private boolean hasNamedArmorStandWithinDistance(ServerLevel world, ServerPlayer player, String name, double distance) {
        try {
            BlockPos playerPos = player.blockPosition();
            AABB searchBox = new AABB((double)playerPos.getX() - distance, (double)playerPos.getY() - distance, (double)playerPos.getZ() - distance, (double)playerPos.getX() + distance, (double)playerPos.getY() + distance, (double)playerPos.getZ() + distance);
            List armorStands = world.getEntities((EntityTypeTest)EntityType.ARMOR_STAND, searchBox, entity -> entity.hasCustomName() && entity.getCustomName() != null && entity.getCustomName().getString().equals(name));
            return !armorStands.isEmpty();
        }
        catch (Exception e) {
            return false;
        }
    }

    private void executeFunction(ServerPlayer player, String functionId) {
        MinecraftServer server = player.getServer();
        if (server == null) {
            return;
        }
        CommandSourceStack source = player.createCommandSourceStack().withSuppressedOutput();
        server.getCommands().performPrefixedCommand(source, "function " + functionId);
    }
}

