/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.mixin;

import github.jorgaomc.blocks.SanctuaryBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerLevel.class})
public class MobSpawnMixin {
    @Inject(method={"spawnEntity"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSpawnEntity(Entity entity, CallbackInfoReturnable<Boolean> cir) {
        if (entity instanceof Mob) {
            String entityId;
            Mob mobEntity = (Mob)entity;
            ServerLevel world = (ServerLevel)this;
            BlockPos pos = entity.blockPosition();
            if (SanctuaryBlock.isMobSpawningBlocked((Level)world, pos) && (entityId = EntityType.getKey((EntityType)entity.getType()).toString()).startsWith("minecraft:")) {
                if (mobEntity.isPersistenceRequired()) {
                    return;
                }
                if (mobEntity.hasCustomName()) {
                    return;
                }
                if (mobEntity.tickCount == 0) {
                    boolean playerNearby;
                    boolean bl = playerNearby = !world.getPlayers(player -> player.distanceToSqr(entity) <= 100.0).isEmpty();
                    if (playerNearby) {
                        return;
                    }
                }
                cir.setReturnValue((Object)false);
            }
        }
    }
}

