/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.mixin;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.GeodeFeature;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={GeodeFeature.class})
public class NoGeodesInStructuresMixin {
    @Inject(method={"generate"}, at={@At(value="HEAD")}, cancellable=true)
    private void legendarymonuments$noGeodesInStructures(FeaturePlaceContext<?> context, CallbackInfoReturnable<Boolean> cir) {
        WorldGenLevel worldGenLevel = context.level();
        if (!(worldGenLevel instanceof WorldGenLevel)) {
            return;
        }
        WorldGenLevel world = worldGenLevel;
        BlockPos origin = context.origin();
        Object accessor = null;
        try {
            Method getAccessor = world.getClass().getMethod("getStructureAccessor", new Class[0]);
            accessor = getAccessor.invoke((Object)world, new Object[0]);
        }
        catch (Throwable getAccessor) {
            // empty catch block
        }
        if (accessor != null) {
            try {
                Collection col;
                Optional opt;
                Method method = accessor.getClass().getMethod("getStructureAt", BlockPos.class);
                Object result = method.invoke(accessor, origin);
                if (result instanceof Optional && (opt = (Optional)result).isPresent()) {
                    cir.setReturnValue((Object)false);
                    return;
                }
                if (result instanceof Collection && !(col = (Collection)result).isEmpty()) {
                    cir.setReturnValue((Object)false);
                    return;
                }
            }
            catch (Throwable method) {
                // empty catch block
            }
            try {
                Collection col;
                Class<?> chunkSectionPosClass = Class.forName("net.minecraft.util.math.ChunkSectionPos");
                Method fromBlockPos = chunkSectionPosClass.getMethod("from", BlockPos.class);
                Object sectionPos = fromBlockPos.invoke(null, origin);
                Method getStructureStarts = accessor.getClass().getMethod("getStructureStarts", chunkSectionPosClass);
                Object starts = getStructureStarts.invoke(accessor, sectionPos);
                if (starts instanceof Collection && !(col = (Collection)starts).isEmpty()) {
                    cir.setReturnValue((Object)false);
                    return;
                }
            }
            catch (Throwable chunkSectionPosClass) {
                // empty catch block
            }
        }
        try {
            Boolean b;
            Method anyMethod = world.getClass().getMethod("isNearStructure", BlockPos.class);
            Object res = anyMethod.invoke((Object)world, origin);
            if (res instanceof Boolean && (b = (Boolean)res).booleanValue()) {
                cir.setReturnValue((Object)false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

