/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.mixin;

import github.jorgaomc.world.dimension.DistortionTeleporter;
import github.jorgaomc.world.dimension.DistortionWorld;
import github.jorgaomc.world.dimension.HallOfOriginTeleporter;
import github.jorgaomc.world.dimension.HallOfOriginWorld;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin {
    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void onTick(CallbackInfo ci) {
        PlayerEntityMixin playerEntityMixin = this;
        if (playerEntityMixin instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerEntityMixin;
            if (serverPlayer.getY() < -20.0 && serverPlayer.level().dimension() == DistortionWorld.DISTORTION_WORLD_KEY) {
                DistortionTeleporter.handleVoidFall(serverPlayer);
            }
            if (serverPlayer.getY() < 0.0 && serverPlayer.level().dimension() == HallOfOriginWorld.HALL_OF_ORIGIN_WORLD_KEY) {
                HallOfOriginTeleporter.handleVoidFall(serverPlayer);
            }
        }
    }
}

