/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.mixin;

import github.jorgaomc.ModItems;
import github.jorgaomc.effect.ModEffects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerSleepMixin {
    @Inject(method={"wakeUp(ZZ)V"}, at={@At(value="TAIL")})
    private void onWakeUp(boolean skipSleepTimer, boolean updateSleepingPlayers, CallbackInfo ci) {
        boolean isDay;
        Player player = (Player)this;
        if (player.level().isClientSide()) {
            return;
        }
        long timeOfDay = player.level().getDayTime() % 24000L;
        boolean bl = isDay = timeOfDay < 12300L;
        if (!isDay) {
            return;
        }
        if (player.getActiveEffectsMap().keySet().stream().anyMatch(statusEffectReference -> BuiltInRegistries.MOB_EFFECT.getKey((Object)((MobEffect)statusEffectReference.value())) != null && BuiltInRegistries.MOB_EFFECT.getKey((Object)((MobEffect)statusEffectReference.value())).equals((Object)ModEffects.LUCID_DREAMING_ID))) {
            player.level().getServer().execute(() -> {
                if (player == null || player.isRemoved()) {
                    return;
                }
                RandomSource random = player.getRandom();
                float chance = random.nextFloat();
                if (chance < 0.1f) {
                    this.giveItemSafely(player, new ItemStack((ItemLike)ModItems.LUNAR_FEATHER, 1), "You had a very pleasant dream and found a Lunar Feather!");
                } else if (chance < 0.2f) {
                    player.removeEffect(MobEffects.HUNGER);
                    player.removeEffect(MobEffects.WITHER);
                    player.addEffect(new MobEffectInstance(MobEffects.HUNGER, 600, 1, false, true, true));
                    player.addEffect(new MobEffectInstance(MobEffects.WITHER, 200, 0, false, true, true));
                    this.giveItemSafely(player, new ItemStack((ItemLike)ModItems.NIGHTMARE_ESSENCE, 1), "You had a terrible nightmare and found a Nightmare Essence!");
                }
            });
        }
    }

    private void giveItemSafely(Player player, ItemStack itemStack, String message) {
        if (!player.getInventory().add(itemStack)) {
            player.drop(itemStack, false);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.getInventory().setChanged();
            serverPlayer.containerMenu.broadcastChanges();
        }
        player.displayClientMessage((Component)Component.literal((String)message), true);
    }
}

