/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import github.jorgaomc.world.dimension.DistortionWorld;
import github.jorgaomc.world.dimension.DistortionWorldSkyRenderer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={LevelRenderer.class})
public class WorldRendererMixin {
    @Inject(method={"renderSky"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderCustomSky(Matrix4f viewMatrix, Matrix4f projectionMatrix, float tickDelta, Camera camera, boolean bl, Runnable runnable, CallbackInfo ci) {
        Minecraft client = Minecraft.getInstance();
        if (client.level != null && client.level.dimension() == DistortionWorld.DISTORTION_WORLD_KEY) {
            PoseStack matrices = new PoseStack();
            matrices.last().pose().set((Matrix4fc)viewMatrix);
            DistortionWorldSkyRenderer.renderSky(matrices, tickDelta, camera);
            ci.cancel();
        }
    }
}

