/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.network;

import github.jorgaomc.LegendaryMonuments;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ChestMenu;

public record EnderChestOpenPacket() implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<EnderChestOpenPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"ender_chest_open"));
    public static final StreamCodec<RegistryFriendlyByteBuf, EnderChestOpenPacket> CODEC = StreamCodec.unit((Object)new EnderChestOpenPacket());

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static void sendToServer() {
        ClientPlayNetworking.send((CustomPacketPayload)new EnderChestOpenPacket());
    }

    public static void registerPayload() {
        PayloadTypeRegistry.playC2S().register(ID, CODEC);
    }

    public static void registerServerReceiver() {
        ServerPlayNetworking.registerGlobalReceiver(ID, (payload, context) -> {
            ServerPlayer player = context.player();
            MinecraftServer server = player.getServer();
            server.execute(() -> {
                try {
                    LegendaryMonuments.LOGGER.info("Opening Ender Chest for player {} via Arc Phone", (Object)player.getName().getString());
                    player.openMenu((MenuProvider)new SimpleMenuProvider((syncId, playerInventory, playerEntity) -> ChestMenu.threeRows((int)syncId, (Inventory)playerInventory, (Container)playerEntity.getEnderChestInventory()), (Component)Component.translatable((String)"container.enderchest")));
                }
                catch (Exception e) {
                    LegendaryMonuments.LOGGER.error("Failed to open Ender Chest for player " + player.getName().getString(), (Throwable)e);
                }
            });
        });
    }
}

