/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.network;

import github.jorgaomc.LegendaryMonuments;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public record HealPacket() implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<HealPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"heal"));
    public static final StreamCodec<RegistryFriendlyByteBuf, HealPacket> CODEC = StreamCodec.unit((Object)new HealPacket());

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static void sendToServer() {
        ClientPlayNetworking.send((CustomPacketPayload)new HealPacket());
    }

    public static void registerPayload() {
        PayloadTypeRegistry.playC2S().register(ID, CODEC);
    }

    public static void registerServerReceiver() {
        ServerPlayNetworking.registerGlobalReceiver(ID, (payload, context) -> {
            ServerPlayer player = context.player();
            MinecraftServer server = player.getServer();
            server.execute(() -> {
                try {
                    LegendaryMonuments.LOGGER.info("Healing Pokemon for player {} via Arc Phone", (Object)player.getName().getString());
                    server.getCommands().performPrefixedCommand(player.createCommandSourceStack().withPermission(2), "pokeheal");
                }
                catch (Exception e) {
                    LegendaryMonuments.LOGGER.error("Failed to heal Pokemon for player " + player.getName().getString(), (Throwable)e);
                }
            });
        });
    }
}

