/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.network;

import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.client.screen.KeyItemsScreenHandler;
import github.jorgaomc.data.KeyItemsDataManager;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;

public record KeyItemsOpenPacket() implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<KeyItemsOpenPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"key_items_open"));
    public static final StreamCodec<RegistryFriendlyByteBuf, KeyItemsOpenPacket> CODEC = StreamCodec.unit((Object)new KeyItemsOpenPacket());

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static void registerPayload() {
        PayloadTypeRegistry.playC2S().register(ID, CODEC);
    }

    public static void sendToServer() {
        ClientPlayNetworking.send((CustomPacketPayload)new KeyItemsOpenPacket());
    }

    public static void registerClient() {
    }

    public static void registerServer() {
        ServerPlayNetworking.registerGlobalReceiver(ID, (payload, context) -> context.server().execute(() -> {
            ServerPlayer player = context.player();
            ServerLevel world = (ServerLevel)player.level();
            try {
                KeyItemsDataManager dataManager = KeyItemsDataManager.getOrCreate(world);
                if (dataManager == null) {
                    LegendaryMonuments.LOGGER.error("KeyItemsDataManager is null for player: " + player.getName().getString());
                    return;
                }
                dataManager.getKeyItemsInventory((Player)player);
                SimpleMenuProvider factory = new SimpleMenuProvider((syncId, inventory, playerEntity) -> new KeyItemsScreenHandler(syncId, inventory), Component.nullToEmpty((String)"Key Items"));
                player.openMenu((MenuProvider)factory);
                LegendaryMonuments.LOGGER.info("Opened Key Items screen for player: " + player.getName().getString());
            }
            catch (Exception e) {
                LegendaryMonuments.LOGGER.error("Error opening Key Items screen for player: " + player.getName().getString(), (Throwable)e);
            }
        }));
    }
}

