/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.network;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public final class LegendaryTrackingPayloads {
    public static final ResourceLocation LOCATE_REQUEST_ID = ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"locate_request");
    public static final ResourceLocation LOCATE_RESPONSE_ID = ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"locate_response");
    public static final ResourceLocation KEYITEM_REQUEST_ID = ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"keyitem_check_request");
    public static final ResourceLocation KEYITEM_RESPONSE_ID = ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"keyitem_check_response");

    private LegendaryTrackingPayloads() {
    }

    public record KeyItemCheckResponsePayload(String itemId, boolean has) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<KeyItemCheckResponsePayload> ID = new CustomPacketPayload.Type(KEYITEM_RESPONSE_ID);
        public static final StreamCodec<FriendlyByteBuf, KeyItemCheckResponsePayload> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, KeyItemCheckResponsePayload::itemId, (StreamCodec)ByteBufCodecs.BOOL, KeyItemCheckResponsePayload::has, KeyItemCheckResponsePayload::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }
    }

    public record KeyItemCheckRequestPayload(String itemId) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<KeyItemCheckRequestPayload> ID = new CustomPacketPayload.Type(KEYITEM_REQUEST_ID);
        public static final StreamCodec<FriendlyByteBuf, KeyItemCheckRequestPayload> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, KeyItemCheckRequestPayload::itemId, KeyItemCheckRequestPayload::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }
    }

    public record LocateResponsePayload(String structureId, boolean found, BlockPos pos) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<LocateResponsePayload> ID = new CustomPacketPayload.Type(LOCATE_RESPONSE_ID);
        public static final StreamCodec<FriendlyByteBuf, LocateResponsePayload> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, LocateResponsePayload::structureId, (StreamCodec)ByteBufCodecs.BOOL, LocateResponsePayload::found, (StreamCodec)BlockPos.STREAM_CODEC, LocateResponsePayload::pos, LocateResponsePayload::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }
    }

    public record LocateRequestPayload(String structureId, BlockPos playerPos, boolean isCompleted) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<LocateRequestPayload> ID = new CustomPacketPayload.Type(LOCATE_REQUEST_ID);
        public static final StreamCodec<FriendlyByteBuf, LocateRequestPayload> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, LocateRequestPayload::structureId, (StreamCodec)BlockPos.STREAM_CODEC, LocateRequestPayload::playerPos, (StreamCodec)ByteBufCodecs.BOOL, LocateRequestPayload::isCompleted, LocateRequestPayload::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }
    }
}

