/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.network;

import github.jorgaomc.blocks.RegiStatueBlock;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;

public final class RegiStatueUpdatePacket
extends Record
implements CustomPacketPayload {
    private final BlockPos pos;
    private final RegiStatueBlock.RegiType type;
    public static final CustomPacketPayload.Type<RegiStatueUpdatePacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"regi_statue_update"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RegiStatueUpdatePacket> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, RegiStatueUpdatePacket::pos, (StreamCodec)ByteBufCodecs.STRING_UTF8.map(s -> {
        System.out.println("Decoding string: " + s);
        for (RegiStatueBlock.RegiType type : RegiStatueBlock.RegiType.values()) {
            if (!type.getSerializedName().equals(s)) continue;
            System.out.println("Found matching type: " + String.valueOf((Object)type));
            return type;
        }
        System.out.println("No matching type found, defaulting to REGIROCK");
        return RegiStatueBlock.RegiType.REGIROCK;
    }, type -> {
        String result = type.getSerializedName();
        System.out.println("Encoding type " + String.valueOf(type) + " as string: " + result);
        return result;
    }), RegiStatueUpdatePacket::type, RegiStatueUpdatePacket::new);

    public RegiStatueUpdatePacket(BlockPos pos, RegiStatueBlock.RegiType type) {
        this.pos = pos;
        this.type = type;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static void send(BlockPos pos, RegiStatueBlock.RegiType type) {
        System.out.println("CLIENT: Sending packet for type: " + String.valueOf((Object)type) + " at pos: " + String.valueOf(pos));
        ClientPlayNetworking.send((CustomPacketPayload)new RegiStatueUpdatePacket(pos, type));
    }

    public static void registerServerReceiver() {
        ServerPlayNetworking.registerGlobalReceiver(ID, (payload, context) -> {
            System.out.println("SERVER: Received packet for type: " + String.valueOf((Object)payload.type) + " at pos: " + String.valueOf(payload.pos));
            context.server().execute(() -> {
                System.out.println("SERVER: Executing packet handler");
                if (!context.player().isCreative()) {
                    System.out.println("SERVER: Player is not in creative mode, ignoring");
                    return;
                }
                BlockState currentState = context.player().serverLevel().getBlockState(payload.pos);
                System.out.println("SERVER: Current block state: " + String.valueOf(currentState));
                if (!(currentState.getBlock() instanceof RegiStatueBlock)) {
                    System.out.println("SERVER: Block is not a RegiStatueBlock, ignoring");
                    return;
                }
                BlockState newState = (BlockState)currentState.setValue(RegiStatueBlock.REGI_TYPE, (Comparable)((Object)payload.type));
                System.out.println("SERVER: Setting new state: " + String.valueOf(newState));
                context.player().serverLevel().setBlockAndUpdate(payload.pos, newState);
                BlockState verifyState = context.player().serverLevel().getBlockState(payload.pos);
                System.out.println("SERVER: Verified state after setting: " + String.valueOf(verifyState));
            });
        });
    }

    public static void registerPayloadType() {
        PayloadTypeRegistry.playC2S().register(ID, CODEC);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{RegiStatueUpdatePacket.class, "pos;type", "pos", "type"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RegiStatueUpdatePacket.class, "pos;type", "pos", "type"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RegiStatueUpdatePacket.class, "pos;type", "pos", "type"}, this, o);
    }

    public BlockPos pos() {
        return this.pos;
    }

    public RegiStatueBlock.RegiType type() {
        return this.type;
    }
}

