/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.network;

import github.jorgaomc.blocks.SanctuaryBlock;
import github.jorgaomc.blocks.entity.SanctuaryBlockEntity;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public record SanctuaryUpdateC2SPacket(BlockPos pos, boolean active, boolean explosionProtection, boolean blockPlacement, boolean blockBreaking, boolean mobSpawning, int horizontalRadius, int verticalRadius) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SanctuaryUpdateC2SPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"jorgaomc", (String)"sanctuary_update"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SanctuaryUpdateC2SPacket> CODEC = new StreamCodec<RegistryFriendlyByteBuf, SanctuaryUpdateC2SPacket>(){

        public SanctuaryUpdateC2SPacket decode(RegistryFriendlyByteBuf buf) {
            BlockPos pos = (BlockPos)BlockPos.STREAM_CODEC.decode((Object)buf);
            boolean active = (Boolean)ByteBufCodecs.BOOL.decode((Object)buf);
            boolean explosionProtection = (Boolean)ByteBufCodecs.BOOL.decode((Object)buf);
            boolean blockPlacement = (Boolean)ByteBufCodecs.BOOL.decode((Object)buf);
            boolean blockBreaking = (Boolean)ByteBufCodecs.BOOL.decode((Object)buf);
            boolean mobSpawning = (Boolean)ByteBufCodecs.BOOL.decode((Object)buf);
            int horizontalRadius = (Integer)ByteBufCodecs.VAR_INT.decode((Object)buf);
            int verticalRadius = (Integer)ByteBufCodecs.VAR_INT.decode((Object)buf);
            return new SanctuaryUpdateC2SPacket(pos, active, explosionProtection, blockPlacement, blockBreaking, mobSpawning, horizontalRadius, verticalRadius);
        }

        public void encode(RegistryFriendlyByteBuf buf, SanctuaryUpdateC2SPacket packet) {
            BlockPos.STREAM_CODEC.encode((Object)buf, (Object)packet.pos());
            ByteBufCodecs.BOOL.encode((Object)buf, (Object)packet.active());
            ByteBufCodecs.BOOL.encode((Object)buf, (Object)packet.explosionProtection());
            ByteBufCodecs.BOOL.encode((Object)buf, (Object)packet.blockPlacement());
            ByteBufCodecs.BOOL.encode((Object)buf, (Object)packet.blockBreaking());
            ByteBufCodecs.BOOL.encode((Object)buf, (Object)packet.mobSpawning());
            ByteBufCodecs.VAR_INT.encode((Object)buf, (Object)packet.horizontalRadius());
            ByteBufCodecs.VAR_INT.encode((Object)buf, (Object)packet.verticalRadius());
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static void register() {
        PayloadTypeRegistry.playC2S().register(ID, CODEC);
        ServerPlayNetworking.registerGlobalReceiver(ID, (payload, context) -> context.server().execute(() -> {
            if (context.player().isCreative()) {
                Level world = context.player().level();
                BlockEntity be = world.getBlockEntity(payload.pos());
                if (be instanceof SanctuaryBlockEntity) {
                    SanctuaryBlockEntity sbe = (SanctuaryBlockEntity)be;
                    SanctuaryBlock.SanctuaryData data = new SanctuaryBlock.SanctuaryData(payload.active(), payload.explosionProtection(), payload.blockPlacement(), payload.blockBreaking(), payload.mobSpawning(), Math.max(1, Math.min(100, payload.horizontalRadius())), Math.max(1, Math.min(100, payload.verticalRadius())));
                    sbe.fromData(data);
                    sbe.setChanged();
                }
                SanctuaryBlock.updateSanctuaryDataWithWorld(world, payload.pos(), payload.active(), payload.explosionProtection(), payload.blockPlacement(), payload.blockBreaking(), payload.mobSpawning(), payload.horizontalRadius(), payload.verticalRadius());
            }
        }));
    }

    public static void registerClient() {
    }

    public static void send(BlockPos pos, boolean active, boolean explosionProtection, boolean blockPlacement, boolean blockBreaking, boolean mobSpawning, int horizontalRadius, int verticalRadius) {
        ClientPlayNetworking.send((CustomPacketPayload)new SanctuaryUpdateC2SPacket(pos, active, explosionProtection, blockPlacement, blockBreaking, mobSpawning, horizontalRadius, verticalRadius));
    }
}

