/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.particles;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;

@Environment(value=EnvType.CLIENT)
public class GalarianFlameParticle
extends TextureSheetParticle {
    private final SpriteSet spriteProvider;
    private final float initialScale;

    protected GalarianFlameParticle(ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, SpriteSet spriteProvider) {
        super(world, x, y, z, velocityX, velocityY, velocityZ);
        float brightness;
        this.spriteProvider = spriteProvider;
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.rCol = brightness = (float)(0.9 + Math.random() * 0.1);
        this.gCol = brightness * 0.3f;
        this.bCol = brightness * 0.8f;
        this.quadSize = this.initialScale = 0.1f + (float)(Math.random() * 0.05);
        this.lifetime = (int)(6.0 / (Math.random() * 0.8 + 0.2)) + 2;
        this.setSpriteFromAge(spriteProvider);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.setSpriteFromAge(this.spriteProvider);
            float ageRatio = (float)this.age / (float)this.lifetime;
            this.quadSize = this.initialScale * (1.0f - ageRatio * 0.5f);
            this.alpha = 1.0f - ageRatio;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public Factory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType particleType, ClientLevel clientWorld, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new GalarianFlameParticle(clientWorld, x, y, z, velocityX, velocityY, velocityZ, this.spriteProvider);
        }
    }
}

