/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.screen;

import github.jorgaomc.blocks.RegiStatueBlock;
import github.jorgaomc.network.RegiStatueUpdatePacket;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;

public class RegiStatueScreen
extends Screen {
    private final BlockPos pos;
    private final RegiStatueBlock.RegiType currentType;

    public RegiStatueScreen(BlockPos pos, RegiStatueBlock.RegiType currentType) {
        super((Component)Component.literal((String)"Regi Statue"));
        this.pos = pos;
        this.currentType = currentType;
        System.out.println("CLIENT: Creating screen for type: " + String.valueOf((Object)currentType) + " at pos: " + String.valueOf(pos));
    }

    protected void init() {
        super.init();
        int buttonWidth = 120;
        int buttonHeight = 20;
        int startX = this.width / 2 - buttonWidth / 2;
        int startY = this.height / 2 - buttonHeight * 3;
        RegiStatueBlock.RegiType[] types = RegiStatueBlock.RegiType.values();
        for (int i = 0; i < types.length; ++i) {
            RegiStatueBlock.RegiType type = types[i];
            int x = startX;
            int y = startY + i * (buttonHeight + 5);
            Button button = Button.builder((Component)Component.literal((String)type.getDisplayName()), btn -> {
                System.out.println("CLIENT: Button clicked for type: " + String.valueOf((Object)type));
                System.out.println("CLIENT: Current type is: " + String.valueOf((Object)this.currentType));
                RegiStatueUpdatePacket.send(this.pos, type);
                this.onClose();
            }).bounds(x, y, buttonWidth, buttonHeight).build();
            if (type == this.currentType) {
                button.active = false;
                System.out.println("CLIENT: Disabling button for current type: " + String.valueOf((Object)type));
            }
            this.addRenderableWidget((GuiEventListener)button);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }
}

