/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.screen;

import github.jorgaomc.blocks.SanctuaryBlock;
import github.jorgaomc.network.SanctuaryUpdateC2SPacket;
import github.jorgaomc.screen.SanctuaryScreenHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class SanctuaryScreen
extends AbstractContainerScreen<SanctuaryScreenHandler> {
    private final BlockPos sanctuaryPos;
    private boolean active;
    private boolean explosionProtection;
    private boolean blockPlacement;
    private boolean blockBreaking;
    private boolean mobSpawning;
    private int horizontalRadius;
    private int verticalRadius;
    private Button activeButton;
    private Button explosionButton;
    private Button placementButton;
    private Button breakingButton;
    private Button spawningButton;
    private AbstractSliderButton horizontalSlider;
    private AbstractSliderButton verticalSlider;

    public SanctuaryScreen(SanctuaryScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.sanctuaryPos = handler.getSanctuaryPos();
        this.imageWidth = 256;
        this.imageHeight = 220;
        System.out.println("Opening sanctuary UI for pos: " + String.valueOf(this.sanctuaryPos));
        SanctuaryBlock.SanctuaryData data = SanctuaryBlock.getSanctuaryData(this.sanctuaryPos);
        if (data != null) {
            this.active = data.active;
            this.explosionProtection = data.explosionProtection;
            this.blockPlacement = data.blockPlacement;
            this.blockBreaking = data.blockBreaking;
            this.mobSpawning = data.mobSpawning;
            this.horizontalRadius = data.horizontalRadius;
            this.verticalRadius = data.verticalRadius;
            System.out.println("Loaded data - Active: " + this.active + " - Explosion: " + this.explosionProtection);
        } else {
            this.active = true;
            this.explosionProtection = true;
            this.blockPlacement = true;
            this.blockBreaking = true;
            this.mobSpawning = true;
            this.horizontalRadius = 50;
            this.verticalRadius = 50;
            System.out.println("Using default data");
        }
    }

    protected void init() {
        super.init();
        int centerX = this.leftPos + this.imageWidth / 2;
        int startY = this.topPos + 30;
        this.activeButton = Button.builder((Component)Component.literal((String)(this.active ? "Active" : "Inactive")).withStyle(this.active ? ChatFormatting.GREEN : ChatFormatting.RED), button -> {
            this.active = !this.active;
            this.updateActiveButton();
            this.sendUpdate();
        }).bounds(centerX - 50, startY, 100, 20).build();
        this.addRenderableWidget((GuiEventListener)this.activeButton);
        this.explosionButton = Button.builder((Component)Component.literal((String)("Explosions: " + (this.explosionProtection ? "Blocked" : "Allowed"))).withStyle(this.explosionProtection ? ChatFormatting.RED : ChatFormatting.GREEN), button -> {
            this.explosionProtection = !this.explosionProtection;
            this.updateExplosionButton();
            this.sendUpdate();
        }).bounds(centerX - 60, startY + 25, 120, 20).build();
        this.addRenderableWidget((GuiEventListener)this.explosionButton);
        this.placementButton = Button.builder((Component)Component.literal((String)("Placement: " + (this.blockPlacement ? "Blocked" : "Allowed"))).withStyle(this.blockPlacement ? ChatFormatting.RED : ChatFormatting.GREEN), button -> {
            this.blockPlacement = !this.blockPlacement;
            this.updatePlacementButton();
            this.sendUpdate();
        }).bounds(centerX - 60, startY + 50, 120, 20).build();
        this.addRenderableWidget((GuiEventListener)this.placementButton);
        this.breakingButton = Button.builder((Component)Component.literal((String)("Breaking: " + (this.blockBreaking ? "Blocked" : "Allowed"))).withStyle(this.blockBreaking ? ChatFormatting.RED : ChatFormatting.GREEN), button -> {
            this.blockBreaking = !this.blockBreaking;
            this.updateBreakingButton();
            this.sendUpdate();
        }).bounds(centerX - 60, startY + 75, 120, 20).build();
        this.addRenderableWidget((GuiEventListener)this.breakingButton);
        this.spawningButton = Button.builder((Component)Component.literal((String)("Mob Spawning: " + (this.mobSpawning ? "Blocked" : "Allowed"))).withStyle(this.mobSpawning ? ChatFormatting.RED : ChatFormatting.GREEN), button -> {
            this.mobSpawning = !this.mobSpawning;
            this.updateSpawningButton();
            this.sendUpdate();
        }).bounds(centerX - 65, startY + 100, 130, 20).build();
        this.addRenderableWidget((GuiEventListener)this.spawningButton);
        this.horizontalSlider = new AbstractSliderButton(centerX - 60, startY + 125, 120, 20, (Component)Component.literal((String)("H-Radius: " + this.horizontalRadius)), (double)this.horizontalRadius / 100.0){

            protected void updateMessage() {
                SanctuaryScreen.this.horizontalRadius = (int)(this.value * 100.0) + 1;
                this.setMessage((Component)Component.literal((String)("H-Radius: " + SanctuaryScreen.this.horizontalRadius)));
            }

            protected void applyValue() {
                SanctuaryScreen.this.sendUpdate();
            }
        };
        this.addRenderableWidget((GuiEventListener)this.horizontalSlider);
        this.verticalSlider = new AbstractSliderButton(centerX - 60, startY + 150, 120, 20, (Component)Component.literal((String)("V-Radius: " + this.verticalRadius)), (double)this.verticalRadius / 100.0){

            protected void updateMessage() {
                SanctuaryScreen.this.verticalRadius = (int)(this.value * 100.0) + 1;
                this.setMessage((Component)Component.literal((String)("V-Radius: " + SanctuaryScreen.this.verticalRadius)));
            }

            protected void applyValue() {
                SanctuaryScreen.this.sendUpdate();
            }
        };
        this.addRenderableWidget((GuiEventListener)this.verticalSlider);
    }

    private void updateActiveButton() {
        this.activeButton.setMessage((Component)Component.literal((String)(this.active ? "Active" : "Inactive")).withStyle(this.active ? ChatFormatting.GREEN : ChatFormatting.RED));
    }

    private void updateExplosionButton() {
        this.explosionButton.setMessage((Component)Component.literal((String)("Explosions: " + (this.explosionProtection ? "Blocked" : "Allowed"))).withStyle(this.explosionProtection ? ChatFormatting.RED : ChatFormatting.GREEN));
    }

    private void updatePlacementButton() {
        this.placementButton.setMessage((Component)Component.literal((String)("Placement: " + (this.blockPlacement ? "Blocked" : "Allowed"))).withStyle(this.blockPlacement ? ChatFormatting.RED : ChatFormatting.GREEN));
    }

    private void updateBreakingButton() {
        this.breakingButton.setMessage((Component)Component.literal((String)("Breaking: " + (this.blockBreaking ? "Blocked" : "Allowed"))).withStyle(this.blockBreaking ? ChatFormatting.RED : ChatFormatting.GREEN));
    }

    private void updateSpawningButton() {
        this.spawningButton.setMessage((Component)Component.literal((String)("Mob Spawning: " + (this.mobSpawning ? "Blocked" : "Allowed"))).withStyle(this.mobSpawning ? ChatFormatting.RED : ChatFormatting.GREEN));
    }

    private void sendUpdate() {
        System.out.println("Sending update - Active: " + this.active + " - Explosion: " + this.explosionProtection);
        SanctuaryUpdateC2SPacket.send(this.sanctuaryPos, this.active, this.explosionProtection, this.blockPlacement, this.blockBreaking, this.mobSpawning, this.horizontalRadius, this.verticalRadius);
        SanctuaryBlock.SanctuaryData data = SanctuaryBlock.getSanctuaryData(this.sanctuaryPos);
        if (data != null) {
            data.active = this.active;
            data.explosionProtection = this.explosionProtection;
            data.blockPlacement = this.blockPlacement;
            data.blockBreaking = this.blockBreaking;
            data.mobSpawning = this.mobSpawning;
            data.horizontalRadius = this.horizontalRadius;
            data.verticalRadius = this.verticalRadius;
            System.out.println("Updated local data - Active: " + data.active + " - Explosion: " + data.explosionProtection);
        }
    }

    protected void renderBg(GuiGraphics context, float delta, int mouseX, int mouseY) {
        context.fill(this.leftPos, this.topPos, this.leftPos + this.imageWidth, this.topPos + this.imageHeight, -2013265920);
        context.renderOutline(this.leftPos, this.topPos, this.imageWidth, this.imageHeight, -1);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        MutableComponent title = Component.literal((String)"Sanctuary Configuration").withStyle(ChatFormatting.BOLD);
        int titleWidth = this.font.width((FormattedText)title);
        context.drawString(this.font, (Component)title, this.leftPos + (this.imageWidth - titleWidth) / 2, this.topPos + 10, 0xFFFFFF, false);
    }

    protected void renderLabels(GuiGraphics context, int mouseX, int mouseY) {
    }
}

