/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import github.jorgaomc.LMStructures;
import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.ModItems;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;

public class SouthernIslandStructure
extends Structure {
    public static final ResourceLocation STRUCTURE_ID = ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"southern_island");
    public static final MapCodec<SouthernIslandStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SouthernIslandStructure.settingsCodec((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.CODEC.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.CODEC.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.CODEC.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)256).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)DimensionPadding.CODEC.optionalFieldOf("dimension_padding", (Object)JigsawStructure.DEFAULT_DIMENSION_PADDING).forGetter(structure -> structure.dimensionPadding), (App)LiquidSettings.CODEC.optionalFieldOf("liquid_settings", (Object)JigsawStructure.DEFAULT_LIQUID_SETTINGS).forGetter(structure -> structure.liquidSettings)).apply((Applicative)instance, SouthernIslandStructure::new));
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int size;
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;
    private final DimensionPadding dimensionPadding;
    private final LiquidSettings liquidSettings;

    public SouthernIslandStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, DimensionPadding dimensionPadding, LiquidSettings liquidSettings) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.dimensionPadding = dimensionPadding;
        this.liquidSettings = liquidSettings;
        LegendaryMonuments.LOGGER.info("Created Southern Island structure with maxDistanceFromCenter: {}", (Object)maxDistanceFromCenter);
    }

    private static boolean extraSpawningChecks(Structure.GenerationContext context) {
        boolean validHeight;
        ChunkPos chunkpos = context.chunkPos();
        int height = context.chunkGenerator().getFirstOccupiedHeight(chunkpos.getMinBlockX(), chunkpos.getMinBlockZ(), Heightmap.Types.OCEAN_FLOOR_WG, context.heightAccessor(), context.randomState());
        boolean bl = validHeight = height > 40 && height < 70;
        if (!validHeight) {
            LegendaryMonuments.LOGGER.debug("Southern Island rejected at ({}, {}) - height: {}", new Object[]{chunkpos.getMinBlockX(), chunkpos.getMinBlockZ(), height});
        }
        return validHeight;
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        if (!SouthernIslandStructure.extraSpawningChecks(context)) {
            return Optional.empty();
        }
        int startY = this.startHeight.sample((RandomSource)context.random(), new WorldGenerationContext(context.chunkGenerator(), context.heightAccessor()));
        ChunkPos chunkPos = context.chunkPos();
        BlockPos blockPos = new BlockPos(chunkPos.getMinBlockX(), startY, chunkPos.getMinBlockZ());
        LegendaryMonuments.LOGGER.info("Attempting to generate Southern Island at ({}, {}, {})", new Object[]{blockPos.getX(), blockPos.getY(), blockPos.getZ()});
        Optional<Structure.GenerationStub> structurePiecesGenerator = this.generateEnhanced(context, this.startPool, this.startJigsawName, this.size, blockPos, false, this.projectStartToHeightmap, this.maxDistanceFromCenter, PoolAliasLookup.EMPTY, this.dimensionPadding, this.liquidSettings);
        if (structurePiecesGenerator.isPresent()) {
            LegendaryMonuments.LOGGER.info("Successfully generated Southern Island at ({}, {}, {})", new Object[]{blockPos.getX(), blockPos.getY(), blockPos.getZ()});
        } else {
            LegendaryMonuments.LOGGER.warn("Failed to generate Southern Island at ({}, {}, {})", new Object[]{blockPos.getX(), blockPos.getY(), blockPos.getZ()});
        }
        return structurePiecesGenerator;
    }

    private Optional<Structure.GenerationStub> generateEnhanced(Structure.GenerationContext context, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, BlockPos pos, boolean useExpansionHack, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, PoolAliasLookup structurePoolAliasLookup, DimensionPadding dimensionPadding, LiquidSettings liquidSettings) {
        LegendaryMonuments.LOGGER.info("Enhanced Southern Island generation with size: {}, maxDistance: {}", (Object)size, (Object)maxDistanceFromCenter);
        try {
            Optional result = JigsawPlacement.addPieces((Structure.GenerationContext)context, startPool, startJigsawName, (int)size, (BlockPos)pos, (boolean)useExpansionHack, projectStartToHeightmap, (int)maxDistanceFromCenter, (PoolAliasLookup)structurePoolAliasLookup, (DimensionPadding)dimensionPadding, (LiquidSettings)liquidSettings);
            if (result.isEmpty()) {
                LegendaryMonuments.LOGGER.warn("StructurePoolBasedGenerator returned empty result");
            }
            return result;
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Error during Southern Island generation: {}", (Object)e.getMessage());
            e.printStackTrace();
            return Optional.empty();
        }
    }

    public StructureType<?> type() {
        return LMStructures.SOUTHERN_ISLAND;
    }

    public static void registerForMaps() {
        LegendaryMonuments.LOGGER.info("Registering Southern Island structure for map discovery");
        try {
            TagKey structureTag = TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ModItems.SOUTHERN_ISLAND_STRUCTURE_SET.location());
            LegendaryMonuments.LOGGER.info("Created structure tag: {}", (Object)structureTag);
            LegendaryMonuments.LOGGER.info("Southern Island structure ID: {}", (Object)STRUCTURE_ID);
            ResourceKey structureKey = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)STRUCTURE_ID);
            LegendaryMonuments.LOGGER.info("Structure registry key: {}", (Object)structureKey);
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Error registering Southern Island for maps: {}", (Object)e.getMessage());
            e.printStackTrace();
        }
    }
}

