/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.util;

import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class LegendaryEffects {
    public static void spawnLugiaEffect(ServerLevel world, BlockPos pos) {
        RandomSource random = world.getRandom();
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.DOLPHIN_AMBIENT_WATER, SoundSource.AMBIENT, 1.0f, 0.5f);
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.PHANTOM_FLAP, SoundSource.AMBIENT, 1.0f, 0.8f);
        CommandSourceStack source = world.getServer().createCommandSourceStack().withPosition(pos.getCenter()).withLevel(world).withSuppressedOutput();
        for (int i = 0; i < 2; ++i) {
            double offsetX = (random.nextDouble() - 0.5) * 5.0;
            double offsetZ = (random.nextDouble() - 0.5) * 5.0;
            LightningBolt lightning = new LightningBolt(EntityType.LIGHTNING_BOLT, (Level)world);
            lightning.moveTo((double)pos.getX() + offsetX, (double)pos.getY(), (double)pos.getZ() + offsetZ);
            lightning.setVisualOnly(true);
            world.addFreshEntity((Entity)lightning);
        }
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:bubble_column_up ~ ~1 ~ 3 3 3 0.1 200 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:splash ~ ~1 ~ 3 3 3 0.5 200 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:cloud ~ ~1 ~ 3 3 3 0.2 100 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:end_rod ~ ~1 ~ 2 2 2 0.1 80 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:flash ~ ~1 ~ 1 1 1 0.1 5 force");
        world.getServer().execute(() -> {
            try {
                Thread.sleep(400L);
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dolphin ~ ~1 ~ 3 3 3 0.5 150 force");
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:cloud ~ ~1 ~ 4 3 4 0.1 100 force");
                world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.PHANTOM_AMBIENT, SoundSource.AMBIENT, 0.8f, 0.6f);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }

    public static void spawnLegendaryEffect(ServerLevel world, BlockPos pos) {
        RandomSource random = world.getRandom();
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.LIGHTNING_BOLT_THUNDER, SoundSource.AMBIENT, 1.0f, 0.8f);
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (Holder)SoundEvents.GENERIC_EXPLODE, SoundSource.AMBIENT, 0.7f, 1.2f);
        CommandSourceStack source = world.getServer().createCommandSourceStack().withPosition(pos.getCenter()).withLevel(world).withSuppressedOutput();
        for (int i = 0; i < 5; ++i) {
            double offsetX = (random.nextDouble() - 0.5) * 5.0;
            double offsetZ = (random.nextDouble() - 0.5) * 5.0;
            LightningBolt lightning = new LightningBolt(EntityType.LIGHTNING_BOLT, (Level)world);
            lightning.moveTo((double)pos.getX() + offsetX, (double)pos.getY(), (double)pos.getZ() + offsetZ);
            lightning.setVisualOnly(true);
            world.addFreshEntity((Entity)lightning);
        }
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:firework ~ ~1 ~ 3 3 3 0.1 100 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:end_rod ~ ~1 ~ 2 2 2 0.1 50 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:explosion ~ ~1 ~ 2 2 2 0.1 10 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:large_smoke ~ ~1 ~ 2 2 2 0.05 50 force");
        world.getServer().execute(() -> {
            try {
                Thread.sleep(500L);
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:soul_fire_flame ~ ~1 ~ 2 2 2 0.05 100 force");
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:flash ~ ~1 ~ 1 1 1 0.1 5 force");
                world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.FIREWORK_ROCKET_LARGE_BLAST, SoundSource.AMBIENT, 1.0f, 0.7f);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }

    public static void spawnElekiEffect(ServerLevel world, BlockPos pos) {
        RandomSource random = world.getRandom();
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.LIGHTNING_BOLT_THUNDER, SoundSource.AMBIENT, 1.0f, 1.2f);
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.LIGHTNING_BOLT_IMPACT, SoundSource.AMBIENT, 0.8f, 1.3f);
        CommandSourceStack source = world.getServer().createCommandSourceStack().withPosition(pos.getCenter()).withLevel(world).withSuppressedOutput();
        for (int i = 0; i < 8; ++i) {
            double offsetX = (random.nextDouble() - 0.5) * 5.0;
            double offsetZ = (random.nextDouble() - 0.5) * 5.0;
            LightningBolt lightning = new LightningBolt(EntityType.LIGHTNING_BOLT, (Level)world);
            lightning.moveTo((double)pos.getX() + offsetX, (double)pos.getY(), (double)pos.getZ() + offsetZ);
            lightning.setVisualOnly(true);
            world.addFreshEntity((Entity)lightning);
        }
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:electric_spark ~ ~1 ~ 3 3 3 1.0 200 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:end_rod ~ ~1 ~ 2 2 2 0.2 100 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:flash ~ ~1 ~ 2 2 2 0.1 15 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:explosion ~ ~1 ~ 2 2 2 0.1 10 force");
        world.getServer().execute(() -> {
            try {
                Thread.sleep(300L);
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:electric_spark ~ ~1 ~ 3 3 3 0.5 150 force");
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:flash ~ ~1 ~ 1 1 1 0.1 5 force");
                world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.LIGHTNING_BOLT_THUNDER, SoundSource.AMBIENT, 0.7f, 1.5f);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }

    public static void spawnRegiceEffect(ServerLevel world, BlockPos pos) {
        RandomSource random = world.getRandom();
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.GLASS_BREAK, SoundSource.AMBIENT, 1.0f, 0.6f);
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.AMBIENT, 1.0f, 0.5f);
        CommandSourceStack source = world.getServer().createCommandSourceStack().withPosition(pos.getCenter()).withLevel(world).withSuppressedOutput();
        for (int i = 0; i < 2; ++i) {
            double offsetX = (random.nextDouble() - 0.5) * 5.0;
            double offsetZ = (random.nextDouble() - 0.5) * 5.0;
            LightningBolt lightning = new LightningBolt(EntityType.LIGHTNING_BOLT, (Level)world);
            lightning.moveTo((double)pos.getX() + offsetX, (double)pos.getY(), (double)pos.getZ() + offsetZ);
            lightning.setVisualOnly(true);
            world.addFreshEntity((Entity)lightning);
        }
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:snowflake ~ ~1 ~ 3 3 3 0.02 250 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:falling_dust minecraft:blue_ice ~ ~3 ~ 3 1 3 0.05 150 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:sculk_soul ~ ~1 ~ 3 2 3 0.05 100 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:soul_fire_flame ~ ~1 ~ 2 2 2 0.05 50 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:flash ~ ~1 ~ 1 1 1 0.1 3 force");
        world.getServer().execute(() -> {
            try {
                Thread.sleep(400L);
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:item_snowball ~ ~1 ~ 2 2 2 0.1 100 force");
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dolphin ~ ~1 ~ 3 1 3 0.0 100 force");
                world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.GLASS_BREAK, SoundSource.AMBIENT, 0.8f, 0.4f);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }

    public static void spawnRegirockEffect(ServerLevel world, BlockPos pos) {
        RandomSource random = world.getRandom();
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.STONE_BREAK, SoundSource.AMBIENT, 1.0f, 0.5f);
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (Holder)SoundEvents.GENERIC_EXPLODE, SoundSource.AMBIENT, 0.7f, 0.6f);
        CommandSourceStack source = world.getServer().createCommandSourceStack().withPosition(pos.getCenter()).withLevel(world).withSuppressedOutput();
        for (int i = 0; i < 3; ++i) {
            double offsetX = (random.nextDouble() - 0.5) * 5.0;
            double offsetZ = (random.nextDouble() - 0.5) * 5.0;
            LightningBolt lightning = new LightningBolt(EntityType.LIGHTNING_BOLT, (Level)world);
            lightning.moveTo((double)pos.getX() + offsetX, (double)pos.getY(), (double)pos.getZ() + offsetZ);
            lightning.setVisualOnly(true);
            world.addFreshEntity((Entity)lightning);
        }
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:falling_dust minecraft:terracotta ~ ~3 ~ 3 1 3 0.05 150 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:block minecraft:brown_terracotta ~ ~1 ~ 3 1 3 0.2 150 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 0.6 0.4 0.2 2.0 ~ ~1 ~ 3 2 3 0.05 200 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:explosion ~ ~1 ~ 2 0.5 2 0.1 5 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:large_smoke ~ ~1 ~ 2 1 2 0.05 70 force");
        world.getServer().execute(() -> {
            try {
                Thread.sleep(400L);
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:block minecraft:cracked_stone_bricks ~ ~0.1 ~ 2 0.1 2 0.1 50 force");
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 0.8 0.6 0.3 1.5 ~ ~1 ~ 3 2 3 0.02 100 force");
                world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.STONE_BREAK, SoundSource.AMBIENT, 0.8f, 0.5f);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }

    public static void spawnRegisteelEffect(ServerLevel world, BlockPos pos) {
        RandomSource random = world.getRandom();
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.ANVIL_LAND, SoundSource.AMBIENT, 1.0f, 0.7f);
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.IRON_GOLEM_HURT, SoundSource.AMBIENT, 0.8f, 0.6f);
        CommandSourceStack source = world.getServer().createCommandSourceStack().withPosition(pos.getCenter()).withLevel(world).withSuppressedOutput();
        for (int i = 0; i < 4; ++i) {
            double offsetX = (random.nextDouble() - 0.5) * 5.0;
            double offsetZ = (random.nextDouble() - 0.5) * 5.0;
            LightningBolt lightning = new LightningBolt(EntityType.LIGHTNING_BOLT, (Level)world);
            lightning.moveTo((double)pos.getX() + offsetX, (double)pos.getY(), (double)pos.getZ() + offsetZ);
            lightning.setVisualOnly(true);
            world.addFreshEntity((Entity)lightning);
        }
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:block minecraft:iron_block ~ ~1 ~ 3 2 3 0.1 150 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 0.7 0.7 0.75 2.0 ~ ~1 ~ 3 2 3 0.05 200 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:enchant ~ ~1 ~ 3 2 3 0.5 100 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:crit ~ ~1 ~ 3 2 3 0.5 100 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:flash ~ ~1 ~ 1 1 1 0.1 3 force");
        world.getServer().execute(() -> {
            try {
                Thread.sleep(400L);
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:block minecraft:iron_block ~ ~1 ~ 2 2 2 0.1 50 force");
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:electric_spark ~ ~1 ~ 2 2 2 0.1 50 force");
                world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.ANVIL_USE, SoundSource.AMBIENT, 0.7f, 0.6f);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }

    public static void spawnRegigigasEffect(ServerLevel world, BlockPos pos) {
        RandomSource random = world.getRandom();
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.ANVIL_LAND, SoundSource.AMBIENT, 1.5f, 0.4f);
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (Holder)SoundEvents.GENERIC_EXPLODE, SoundSource.AMBIENT, 1.0f, 0.5f);
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.IRON_GOLEM_STEP, SoundSource.AMBIENT, 1.2f, 0.4f);
        CommandSourceStack source = world.getServer().createCommandSourceStack().withPosition(pos.getCenter()).withLevel(world).withSuppressedOutput();
        for (int i = 0; i < 8; ++i) {
            double offsetX = (random.nextDouble() - 0.5) * 8.0;
            double offsetZ = (random.nextDouble() - 0.5) * 8.0;
            LightningBolt lightning = new LightningBolt(EntityType.LIGHTNING_BOLT, (Level)world);
            lightning.moveTo((double)pos.getX() + offsetX, (double)pos.getY(), (double)pos.getZ() + offsetZ);
            lightning.setVisualOnly(true);
            world.addFreshEntity((Entity)lightning);
        }
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:block minecraft:stone ~ ~0.1 ~ 4 0.1 4 0.1 100 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 1.0 0.9 0.4 2.0 ~ ~1 ~ 4 3 4 0.05 150 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 0.9 0.9 0.9 2.0 ~ ~1 ~ 4 3 4 0.05 150 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 0.6 0.6 0.7 2.0 ~ ~1 ~ 4 3 4 0.05 150 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:explosion_emitter ~ ~1 ~ 3 1 3 0.1 10 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:soul_fire_flame ~ ~1 ~ 3 3 3 0.1 100 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:snowflake ~ ~1 ~ 3 3 3 0.01 100 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:flash ~ ~1 ~ 2 2 2 0.1 8 force");
        world.getServer().execute(() -> {
            try {
                Thread.sleep(400L);
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:block minecraft:cracked_stone_bricks ~ ~0.1 ~ 3 0.1 3 0.1 80 force");
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:cloud ~ ~0.5 ~ 3 0.5 3 0.02 50 force");
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:explosion ~ ~1 ~ 3 2 3 0.1 15 force");
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:large_smoke ~ ~1 ~ 3 2 3 0.05 80 force");
                world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.WITHER_AMBIENT, SoundSource.AMBIENT, 0.8f, 0.4f);
                world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.IRON_GOLEM_HURT, SoundSource.AMBIENT, 1.0f, 0.5f);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }

    public static void spawnHoOhEffect(ServerLevel world, BlockPos pos) {
        RandomSource random = world.getRandom();
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.BLAZE_AMBIENT, SoundSource.AMBIENT, 1.0f, 0.5f);
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.PHANTOM_FLAP, SoundSource.AMBIENT, 0.8f, 0.6f);
        CommandSourceStack source = world.getServer().createCommandSourceStack().withPosition(pos.getCenter()).withLevel(world).withSuppressedOutput();
        for (int i = 0; i < 3; ++i) {
            double offsetX = (random.nextDouble() - 0.5) * 5.0;
            double offsetZ = (random.nextDouble() - 0.5) * 5.0;
            LightningBolt lightning = new LightningBolt(EntityType.LIGHTNING_BOLT, (Level)world);
            lightning.moveTo((double)pos.getX() + offsetX, (double)pos.getY(), (double)pos.getZ() + offsetZ);
            lightning.setVisualOnly(true);
            world.addFreshEntity((Entity)lightning);
        }
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 1.0 0.2 0.2 1.5 ~ ~1 ~ 3 3 3 0.05 50 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 1.0 0.6 0.2 1.5 ~ ~1 ~ 3 3 3 0.05 50 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 1.0 1.0 0.2 1.5 ~ ~1 ~ 3 3 3 0.05 50 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 0.2 1.0 0.2 1.5 ~ ~1 ~ 3 3 3 0.05 50 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 0.2 0.2 1.0 1.5 ~ ~1 ~ 3 3 3 0.05 50 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 0.6 0.2 1.0 1.5 ~ ~1 ~ 3 3 3 0.05 50 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:flame ~ ~1 ~ 3 3 3 0.1 150 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:firework ~ ~3 ~ 4 1 4 0.05 100 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:flash ~ ~1 ~ 1 1 1 0.1 5 force");
        world.getServer().execute(() -> {
            try {
                Thread.sleep(400L);
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust_color_transition 1.0 0.0 0.0 1.5 0.0 1.0 1.0 ~ ~2 ~ 4 2 4 0.1 100 force");
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:lava ~ ~1 ~ 2 1 2 0.1 30 force");
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:end_rod ~ ~1 ~ 3 3 3 0.05 100 force");
                world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.FIRE_AMBIENT, SoundSource.AMBIENT, 1.0f, 1.0f);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }

    public static void spawnDragoEffect(ServerLevel world, BlockPos pos) {
        RandomSource random = world.getRandom();
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.ENDER_DRAGON_GROWL, SoundSource.AMBIENT, 1.0f, 0.6f);
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (Holder)SoundEvents.GENERIC_EXPLODE, SoundSource.AMBIENT, 0.7f, 0.8f);
        CommandSourceStack source = world.getServer().createCommandSourceStack().withPosition(pos.getCenter()).withLevel(world).withSuppressedOutput();
        for (int i = 0; i < 3; ++i) {
            double offsetX = (random.nextDouble() - 0.5) * 5.0;
            double offsetZ = (random.nextDouble() - 0.5) * 5.0;
            LightningBolt lightning = new LightningBolt(EntityType.LIGHTNING_BOLT, (Level)world);
            lightning.moveTo((double)pos.getX() + offsetX, (double)pos.getY(), (double)pos.getZ() + offsetZ);
            lightning.setVisualOnly(true);
            world.addFreshEntity((Entity)lightning);
        }
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dragon_breath ~ ~1 ~ 3 3 3 0.1 200 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:soul_fire_flame ~ ~1 ~ 3 3 3 0.1 100 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:explosion ~ ~1 ~ 2 2 2 0.1 10 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:large_smoke ~ ~1 ~ 2 2 2 0.05 50 force");
        world.getServer().execute(() -> {
            try {
                Thread.sleep(400L);
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dragon_breath ~ ~1 ~ 3 3 3 0.1 150 force");
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:enchanted_hit ~ ~1 ~ 2 2 2 0.5 100 force");
                world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.ENDER_DRAGON_GROWL, SoundSource.AMBIENT, 0.5f, 0.7f);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }

    public static void spawnRaikouEffect(ServerLevel world, BlockPos pos) {
        int i;
        RandomSource random = world.getRandom();
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.LIGHTNING_BOLT_THUNDER, SoundSource.AMBIENT, 1.0f, 0.8f);
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.LIGHTNING_BOLT_IMPACT, SoundSource.AMBIENT, 0.9f, 1.2f);
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.RAVAGER_ROAR, SoundSource.HOSTILE, 0.8f, 1.0f);
        CommandSourceStack source = world.getServer().createCommandSourceStack().withPosition(pos.getCenter()).withLevel(world).withSuppressedOutput();
        for (i = 0; i < 8; ++i) {
            double offsetX = (random.nextDouble() - 0.5) * 6.0;
            double offsetZ = (random.nextDouble() - 0.5) * 6.0;
            LightningBolt lightning = new LightningBolt(EntityType.LIGHTNING_BOLT, (Level)world);
            lightning.moveTo((double)pos.getX() + offsetX, (double)pos.getY(), (double)pos.getZ() + offsetZ);
            lightning.setVisualOnly(true);
            world.addFreshEntity((Entity)lightning);
            try {
                Thread.sleep(150L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 1.0 1.0 0.1 1.8 ~ ~1 ~ 3 2 3 0.1 200 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:electric_spark ~ ~1 ~ 4 3 4 0.5 300 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:flash ~ ~1 ~ 2 2 2 0.1 10 force");
        for (i = 0; i < 30; ++i) {
            float offsetX = (random.nextFloat() - 0.5f) * 8.0f;
            float offsetZ = (random.nextFloat() - 0.5f) * 8.0f;
            world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:crit " + ((float)pos.getX() + offsetX) + " " + ((double)pos.getY() + 0.1) + " " + ((float)pos.getZ() + offsetZ) + " 0.1 0.1 0.1 0.5 3 force");
        }
        world.getServer().execute(() -> {
            try {
                Thread.sleep(400L);
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 1.0 0.9 0.0 1.5 ~ ~1 ~ 4 2 4 0.2 150 force");
                for (int radius = 1; radius < 6; ++radius) {
                    int r = radius;
                    world.getServer().execute(() -> world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:electric_spark ~ ~0.2 ~ " + r + " 0.1 " + r + " 0.05 80 force"));
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                LightningBolt lightning = new LightningBolt(EntityType.LIGHTNING_BOLT, (Level)world);
                lightning.moveTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                lightning.setVisualOnly(true);
                world.addFreshEntity((Entity)lightning);
                world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.LIGHTNING_BOLT_THUNDER, SoundSource.AMBIENT, 1.0f, 0.9f);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }

    public static void spawnEnteiEffect(ServerLevel world, BlockPos pos) {
        int i;
        RandomSource random = world.getRandom();
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.LAVA_AMBIENT, SoundSource.AMBIENT, 1.2f, 0.6f);
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.BLAZE_SHOOT, SoundSource.HOSTILE, 1.0f, 0.7f);
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.RAVAGER_ROAR, SoundSource.HOSTILE, 1.0f, 0.6f);
        CommandSourceStack source = world.getServer().createCommandSourceStack().withPosition(pos.getCenter()).withLevel(world).withSuppressedOutput();
        for (i = 0; i < 3; ++i) {
            double offsetX = (random.nextDouble() - 0.5) * 5.0;
            double offsetZ = (random.nextDouble() - 0.5) * 5.0;
            LightningBolt lightning = new LightningBolt(EntityType.LIGHTNING_BOLT, (Level)world);
            lightning.moveTo((double)pos.getX() + offsetX, (double)pos.getY(), (double)pos.getZ() + offsetZ);
            lightning.setVisualOnly(true);
            world.addFreshEntity((Entity)lightning);
        }
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:lava ~ ~1 ~ 2 2 2 0.2 100 force");
        for (int radius = 1; radius < 8; ++radius) {
            int r = radius;
            world.getServer().execute(() -> world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:flame ~ ~0.2 ~ " + r + " 0.1 " + r + " 0.05 80 force"));
            try {
                Thread.sleep(150L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:large_smoke ~ ~1 ~ 3 3 3 0.05 150 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 1.0 0.3 0.0 2.0 ~ ~1 ~ 3 2 3 0.1 150 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:explosion ~ ~1 ~ 2 1 2 0.1 8 force");
        for (i = 0; i < 30; ++i) {
            float offsetX = (random.nextFloat() - 0.5f) * 10.0f;
            float offsetZ = (random.nextFloat() - 0.5f) * 10.0f;
            world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:flame " + ((float)pos.getX() + offsetX) + " " + ((double)pos.getY() + 0.1) + " " + ((float)pos.getZ() + offsetZ) + " 0.1 0.1 0.1 0.01 3 force");
        }
        world.getServer().execute(() -> {
            try {
                Thread.sleep(400L);
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:flame ~ ~1 ~ 2 2 2 0.2 100 force");
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:lava ~ ~1 ~ 1 1 1 0.1 30 force");
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 1.0 0.5 0.0 1.0 ~ ~2 ~ 3 3 3 0.05 100 force");
                world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.FIRE_AMBIENT, SoundSource.AMBIENT, 1.0f, 0.8f);
                world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.RAVAGER_ROAR, SoundSource.HOSTILE, 1.0f, 0.5f);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }

    public static void spawnSuicuneEffect(ServerLevel world, BlockPos pos) {
        RandomSource random = world.getRandom();
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.AMBIENT_UNDERWATER_ENTER, SoundSource.AMBIENT, 1.0f, 0.8f);
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.DOLPHIN_SPLASH, SoundSource.NEUTRAL, 1.0f, 0.9f);
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.WOLF_HOWL, SoundSource.NEUTRAL, 0.8f, 0.7f);
        CommandSourceStack source = world.getServer().createCommandSourceStack().withPosition(pos.getCenter()).withLevel(world).withSuppressedOutput();
        for (int i = 0; i < 2; ++i) {
            double offsetX = (random.nextDouble() - 0.5) * 5.0;
            double offsetZ = (random.nextDouble() - 0.5) * 5.0;
            LightningBolt lightning = new LightningBolt(EntityType.LIGHTNING_BOLT, (Level)world);
            lightning.moveTo((double)pos.getX() + offsetX, (double)pos.getY(), (double)pos.getZ() + offsetZ);
            lightning.setVisualOnly(true);
            world.addFreshEntity((Entity)lightning);
        }
        for (int height = 0; height < 10; ++height) {
            int h = height;
            world.getServer().execute(() -> world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:falling_water ~ " + (pos.getY() + h) + " ~ 1.5 0.1 1.5 0.1 20 force"));
            try {
                Thread.sleep(80L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 0.0 0.5 1.0 1.5 ~ ~1 ~ 3 2 3 0.05 150 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:splash ~ ~1 ~ 3 2 3 0.4 200 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:bubble_column_up ~ ~1 ~ 3 3 3 0.2 150 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:cloud ~ ~0.5 ~ 4 0.5 4 0.01 80 force");
        for (int radius = 1; radius < 8; radius += 2) {
            int r = radius;
            world.getServer().execute(() -> world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dolphin ~ ~0.5 ~ " + r + " 0.1 " + r + " 0.01 40 force"));
            try {
                Thread.sleep(150L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        world.getServer().execute(() -> {
            try {
                Thread.sleep(400L);
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:splash ~ ~1 ~ 2 2 2 0.2 100 force");
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 0.0 0.8 0.8 1.0 ~ ~3 ~ 5 2 5 0.05 100 force");
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 0.2 0.4 0.8 1.0 ~ ~4 ~ 5 2 5 0.05 100 force");
                world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.AMBIENT_UNDERWATER_LOOP, SoundSource.AMBIENT, 0.8f, 1.0f);
                world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.WOLF_HOWL, SoundSource.NEUTRAL, 1.0f, 0.7f);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }

    public static void spawnVirizionEffect(ServerLevel world, BlockPos pos) {
        RandomSource random = world.getRandom();
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.GRASS_BREAK, SoundSource.BLOCKS, 1.2f, 0.6f);
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.HORSE_GALLOP, SoundSource.NEUTRAL, 1.0f, 0.8f);
        CommandSourceStack source = world.getServer().createCommandSourceStack().withPosition(pos.getCenter()).withLevel(world).withSuppressedOutput();
        for (int i = 0; i < 2; ++i) {
            double offsetX = (random.nextDouble() - 0.5) * 5.0;
            double offsetZ = (random.nextDouble() - 0.5) * 5.0;
            LightningBolt lightning = new LightningBolt(EntityType.LIGHTNING_BOLT, (Level)world);
            lightning.moveTo((double)pos.getX() + offsetX, (double)pos.getY(), (double)pos.getZ() + offsetZ);
            lightning.setVisualOnly(true);
            world.addFreshEntity((Entity)lightning);
        }
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 0.2 0.8 0.2 1.5 ~ ~1 ~ 4 3 4 0.05 250 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:block minecraft:oak_leaves ~ ~2 ~ 4 2 4 0.1 150 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:block minecraft:grass ~ ~0.5 ~ 4 0.5 4 0.1 100 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 0.9 0.9 0.2 1.0 ~ ~1 ~ 4 3 4 0.01 150 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 0.4 1.0 0.4 1.0 ~ ~1 ~ 5 2 5 0.02 150 force");
        for (int radius = 1; radius < 8; radius += 2) {
            int r = radius;
            world.getServer().execute(() -> world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 0.0 0.8 0.0 1.0 ~ ~0.2 ~ " + r + " 0.1 " + r + " 0.01 80 force"));
            try {
                Thread.sleep(150L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        world.getServer().execute(() -> {
            try {
                Thread.sleep(400L);
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:block minecraft:azure_bluet ~ ~0.2 ~ 3 0.1 3 0.05 30 force");
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:block minecraft:poppy ~ ~0.2 ~ 3 0.1 3 0.05 30 force");
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:block minecraft:dandelion ~ ~0.2 ~ 3 0.1 3 0.05 30 force");
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:block minecraft:oak_leaves ~ ~3 ~ 5 2 5 0.02 100 force");
                world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.AZALEA_LEAVES_BREAK, SoundSource.BLOCKS, 0.8f, 0.9f);
                world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.HORSE_AMBIENT, SoundSource.NEUTRAL, 1.2f, 0.8f);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }

    public static void spawnTerrakionEffect(ServerLevel world, BlockPos pos) {
        RandomSource random = world.getRandom();
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.STONE_BREAK, SoundSource.BLOCKS, 1.3f, 0.5f);
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (Holder)SoundEvents.GENERIC_EXPLODE, SoundSource.BLOCKS, 0.8f, 0.6f);
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.HORSE_GALLOP, SoundSource.NEUTRAL, 1.0f, 0.5f);
        CommandSourceStack source = world.getServer().createCommandSourceStack().withPosition(pos.getCenter()).withLevel(world).withSuppressedOutput();
        for (int i = 0; i < 3; ++i) {
            double offsetX = (random.nextDouble() - 0.5) * 5.0;
            double offsetZ = (random.nextDouble() - 0.5) * 5.0;
            LightningBolt lightning = new LightningBolt(EntityType.LIGHTNING_BOLT, (Level)world);
            lightning.moveTo((double)pos.getX() + offsetX, (double)pos.getY(), (double)pos.getZ() + offsetZ);
            lightning.setVisualOnly(true);
            world.addFreshEntity((Entity)lightning);
        }
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:block minecraft:stone ~ ~1 ~ 3 2 3 0.2 150 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:block minecraft:cobblestone ~ ~1 ~ 3 2 3 0.2 100 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 0.6 0.5 0.3 2.0 ~ ~1 ~ 4 2 4 0.05 200 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:explosion ~ ~0.5 ~ 3 0.5 3 0.1 10 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:large_smoke ~ ~1 ~ 3 2 3 0.05 80 force");
        for (int height = 0; height < 5; ++height) {
            int h = height;
            world.getServer().execute(() -> world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:block minecraft:stone ~ " + (pos.getY() + h) + " ~ 1.5 0.1 1.5 0.3 20 force"));
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        world.getServer().execute(() -> {
            try {
                Thread.sleep(400L);
                for (int radius = 1; radius < 6; ++radius) {
                    int r = radius;
                    world.getServer().execute(() -> world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:block minecraft:cobblestone ~ ~0.2 ~ " + r + " 0.1 " + r + " 0.1 40 force"));
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 0.5 0.4 0.3 1.5 ~ ~1 ~ 3 2 3 0.05 100 force");
                world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.STONE_BREAK, SoundSource.BLOCKS, 1.0f, 0.6f);
                world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.HORSE_AMBIENT, SoundSource.NEUTRAL, 1.2f, 0.5f);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }

    public static void spawnCobalionEffect(ServerLevel world, BlockPos pos) {
        RandomSource random = world.getRandom();
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.ANVIL_LAND, SoundSource.BLOCKS, 1.0f, 0.8f);
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.CHAIN_BREAK, SoundSource.BLOCKS, 0.9f, 0.8f);
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.HORSE_GALLOP, SoundSource.NEUTRAL, 1.0f, 0.7f);
        CommandSourceStack source = world.getServer().createCommandSourceStack().withPosition(pos.getCenter()).withLevel(world).withSuppressedOutput();
        for (int i = 0; i < 3; ++i) {
            double offsetX = (random.nextDouble() - 0.5) * 5.0;
            double offsetZ = (random.nextDouble() - 0.5) * 5.0;
            LightningBolt lightning = new LightningBolt(EntityType.LIGHTNING_BOLT, (Level)world);
            lightning.moveTo((double)pos.getX() + offsetX, (double)pos.getY(), (double)pos.getZ() + offsetZ);
            lightning.setVisualOnly(true);
            world.addFreshEntity((Entity)lightning);
        }
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 0.4 0.5 0.8 1.8 ~ ~1 ~ 3 2 3 0.05 200 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:block minecraft:iron_block ~ ~1 ~ 3 2 3 0.1 100 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:crit ~ ~1 ~ 3 2 3 0.5 150 force");
        for (int radius = 1; radius < 7; ++radius) {
            int r = radius;
            world.getServer().execute(() -> world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 0.3 0.3 0.9 1.2 ~ ~0.3 ~ " + r + " 0.2 " + r + " 0.05 80 force"));
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:enchant ~ ~1 ~ 3 2 3 0.5 80 force");
        world.getServer().execute(() -> {
            try {
                Thread.sleep(400L);
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:block minecraft:iron_block ~ ~1 ~ 2 2 2 0.1 50 force");
                for (int i = 0; i < 5; ++i) {
                    double angle = (double)i * Math.PI / 5.0;
                    double x1 = (double)pos.getX() + Math.cos(angle) * 3.0;
                    double z1 = (double)pos.getZ() + Math.sin(angle) * 3.0;
                    double x2 = (double)pos.getX() + Math.cos(angle + 0.39269908169872414) * 3.0;
                    double z2 = (double)pos.getZ() + Math.sin(angle + 0.39269908169872414) * 3.0;
                    world.getServer().getCommands().performPrefixedCommand(source, String.format("particle minecraft:dust 0.2 0.2 0.8 1.0 %s %s %s %s %s %s 0.05 20 force", x1, (double)pos.getY() + 1.5, z1, x2 - x1, 0.0, z2 - z1));
                }
                world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.ANVIL_USE, SoundSource.BLOCKS, 0.7f, 0.9f);
                world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.HORSE_AMBIENT, SoundSource.NEUTRAL, 1.2f, 0.7f);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }

    public static void spawnCosmogEffect(ServerLevel world, BlockPos pos) {
        RandomSource random = world.getRandom();
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.BEACON_AMBIENT, SoundSource.BLOCKS, 1.0f, 0.6f);
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.BLOCKS, 1.0f, 1.2f);
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.ILLUSIONER_PREPARE_MIRROR, SoundSource.NEUTRAL, 0.8f, 1.5f);
        CommandSourceStack source = world.getServer().createCommandSourceStack().withPosition(pos.getCenter()).withLevel(world).withSuppressedOutput();
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 0.5 0.0 1.0 1.5 ~ ~1 ~ 3 3 3 0.03 150 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 0.0 0.3 1.0 1.5 ~ ~1 ~ 3 3 3 0.03 150 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:end_rod ~ ~1 ~ 3 3 3 0.02 100 force");
        for (int i = 0; i < 360; i += 10) {
            int angle = i;
            world.getServer().execute(() -> {
                double radius = 2.5;
                double x = (double)pos.getX() + Math.cos(Math.toRadians(angle)) * radius;
                double z = (double)pos.getZ() + Math.sin(Math.toRadians(angle)) * radius;
                world.getServer().getCommands().performPrefixedCommand(source, String.format("particle minecraft:dust 0.7 0.0 1.0 1.0 %s %s %s 0.1 0.1 0.1 0.02 5 force", x, (double)pos.getY() + 1.5, z));
            });
            try {
                Thread.sleep(20L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:flash ~ ~1 ~ 0.5 0.5 0.5 0.1 5 force");
        world.getServer().execute(() -> {
            try {
                Thread.sleep(400L);
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dragon_breath ~ ~1 ~ 2 2 2 0.02 80 force");
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:firework ~ ~1 ~ 2 2 2 0.05 100 force");
                for (int i = 0; i < 360; i += 15) {
                    int angle = i;
                    world.getServer().execute(() -> {
                        for (double radius = 0.5; radius < 3.0; radius += 0.5) {
                            double x = (double)pos.getX() + Math.cos(Math.toRadians(angle)) * radius;
                            double z = (double)pos.getZ() + Math.sin(Math.toRadians(angle)) * radius;
                            world.getServer().getCommands().performPrefixedCommand(source, String.format("particle minecraft:dust 0.0 0.7 1.0 1.0 %s %s %s 0.1 0.1 0.1 0.02 3 force", x, (double)pos.getY() + 1.0, z));
                        }
                    });
                }
                world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.BEACON_POWER_SELECT, SoundSource.BLOCKS, 0.7f, 1.5f);
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:flash ~ ~1 ~ 1 1 1 0.1 3 force");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }

    public static void spawnLatiasEffect(ServerLevel world, BlockPos pos) {
        double z;
        double x;
        double angle;
        int i;
        RandomSource random = world.getRandom();
        world.playSound(null, pos, SoundEvents.ENDER_DRAGON_GROWL, SoundSource.BLOCKS, 1.0f, 1.5f);
        world.playSound(null, pos, SoundEvents.BEACON_ACTIVATE, SoundSource.BLOCKS, 1.0f, 1.2f);
        Vec3 center = new Vec3((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
        for (i = 0; i < 200; ++i) {
            angle = (double)i * Math.PI / 25.0;
            double radius = Math.min(5.0, (double)i / 15.0);
            x = center.x + Math.cos(angle) * radius;
            z = center.z + Math.sin(angle) * radius;
            double y = center.y + (double)i / 40.0;
            world.sendParticles((ParticleOptions)new DustParticleOptions(new Vector3f(0.9f, 0.2f, 0.2f), 1.0f), x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            if (i % 5 != 0) continue;
            world.sendParticles((ParticleOptions)ParticleTypes.ENCHANT, x, y, z, 1, 0.0, 0.0, 0.0, 0.1);
        }
        for (i = 0; i < 50; ++i) {
            angle = random.nextDouble() * Math.PI * 2.0;
            double distance = random.nextDouble() * 2.5;
            x = center.x + Math.cos(angle) * distance;
            z = center.z + Math.sin(angle) * distance;
            world.sendParticles((ParticleOptions)ParticleTypes.END_ROD, x, center.y, z, 1, 0.0, 0.6, 0.0, 0.2);
        }
    }

    public static void spawnLatiosEffect(ServerLevel world, BlockPos pos) {
        double z;
        double x;
        double angle;
        int i;
        RandomSource random = world.getRandom();
        world.playSound(null, pos, SoundEvents.ENDER_DRAGON_GROWL, SoundSource.BLOCKS, 1.0f, 1.7f);
        world.playSound(null, pos, SoundEvents.BEACON_ACTIVATE, SoundSource.BLOCKS, 1.0f, 1.4f);
        Vec3 center = new Vec3((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
        for (i = 0; i < 200; ++i) {
            angle = (double)i * Math.PI / 25.0;
            double radius = Math.min(5.0, (double)i / 15.0);
            x = center.x + Math.cos(angle) * radius;
            z = center.z + Math.sin(angle) * radius;
            double y = center.y + (double)i / 40.0;
            world.sendParticles((ParticleOptions)new DustParticleOptions(new Vector3f(0.2f, 0.4f, 0.9f), 1.0f), x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            if (i % 5 != 0) continue;
            world.sendParticles((ParticleOptions)ParticleTypes.ENCHANT, x, y, z, 1, 0.0, 0.0, 0.0, 0.1);
        }
        for (i = 0; i < 50; ++i) {
            angle = random.nextDouble() * Math.PI * 2.0;
            double distance = random.nextDouble() * 2.5;
            x = center.x + Math.cos(angle) * distance;
            z = center.z + Math.sin(angle) * distance;
            world.sendParticles((ParticleOptions)ParticleTypes.END_ROD, x, center.y, z, 1, 0.0, 0.6, 0.0, 0.2);
        }
    }

    public static void spawnMeltanEffect(ServerLevel world, BlockPos pos) {
        RandomSource random = world.getRandom();
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.ANVIL_LAND, SoundSource.BLOCKS, 1.0f, 0.9f);
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.CHAIN_BREAK, SoundSource.BLOCKS, 0.8f, 1.2f);
        CommandSourceStack source = world.getServer().createCommandSourceStack().withPosition(pos.getCenter()).withLevel(world).withSuppressedOutput();
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 0.8 0.8 0.85 1.5 ~ ~0.5 ~ 1.5 0.5 1.5 0.05 150 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:crit ~ ~1 ~ 2 1.5 2 0.5 100 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:electric_spark ~ ~1 ~ 1.5 1.5 1.5 0.1 50 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:block minecraft:iron_block ~ ~0.7 ~ 1.5 0.5 1.5 0.1 50 force");
        Vec3 center = new Vec3((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
        for (int i = 0; i < 100; ++i) {
            double angle = random.nextDouble() * Math.PI * 2.0;
            double distance = random.nextDouble() * 1.5;
            double x = center.x + Math.cos(angle) * distance;
            double z = center.z + Math.sin(angle) * distance;
            double y = center.y + 0.1 + random.nextDouble() * 0.3;
            world.sendParticles((ParticleOptions)new DustParticleOptions(new Vector3f(0.75f, 0.75f, 0.78f), 1.2f), x, y, z, 1, 0.0, 0.08, 0.0, 0.0);
            if (i % 5 != 0) continue;
            world.sendParticles((ParticleOptions)new DustParticleOptions(new Vector3f(0.85f, 0.55f, 0.35f), 1.0f), x, y, z, 1, 0.0, 0.05, 0.0, 0.0);
        }
        world.getServer().execute(() -> {
            try {
                Thread.sleep(300L);
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:flash ~ ~1 ~ 0.5 0.5 0.5 0.1 2 force");
                for (int i = 0; i < 60; ++i) {
                    double angle = random.nextDouble() * Math.PI * 2.0;
                    double distance = 1.0 + random.nextDouble() * 1.0;
                    double x = center.x + Math.cos(angle) * distance;
                    double z = center.z + Math.sin(angle) * distance;
                    double y = center.y + 0.8 + random.nextDouble() * 0.5;
                    double dirX = (center.x - x) * 0.1;
                    double dirZ = (center.z - z) * 0.1;
                    world.sendParticles((ParticleOptions)ParticleTypes.CRIT, x, y, z, 1, dirX, 0.0, dirZ, 0.05);
                }
                world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.ANVIL_USE, SoundSource.BLOCKS, 0.8f, 1.1f);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }

    public static void spawnPalkiaEffect(ServerLevel world, BlockPos pos) {
        RandomSource random = world.getRandom();
        CommandSourceStack source = world.getServer().createCommandSourceStack().withPosition(pos.getCenter()).withLevel(world).withSuppressedOutput();
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.AMBIENT, 1.0f, 0.8f);
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.AMBIENT, 0.8f, 1.4f);
        for (int i = 0; i < 2; ++i) {
            double ox = (random.nextDouble() - 0.5) * 4.0;
            double oz = (random.nextDouble() - 0.5) * 4.0;
            LightningBolt bolt = new LightningBolt(EntityType.LIGHTNING_BOLT, (Level)world);
            bolt.moveTo((double)pos.getX() + ox, (double)pos.getY(), (double)pos.getZ() + oz);
            bolt.setVisualOnly(true);
            world.addFreshEntity((Entity)bolt);
        }
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:end_rod ~ ~1 ~ 2 2 2 0.05 120 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:portal ~ ~1 ~ 2 2 2 0.2 120 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dragon_breath ~ ~1 ~ 2 2 2 0.05 80 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:flash ~ ~1 ~ 1 1 1 0.01 3 force");
    }

    public static void spawnDialgaEffect(ServerLevel world, BlockPos pos) {
        RandomSource random = world.getRandom();
        CommandSourceStack source = world.getServer().createCommandSourceStack().withPosition(pos.getCenter()).withLevel(world).withSuppressedOutput();
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.AMETHYST_BLOCK_RESONATE, SoundSource.AMBIENT, 1.0f, 1.0f);
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (SoundEvent)SoundEvents.NOTE_BLOCK_HAT.value(), SoundSource.AMBIENT, 0.6f, 1.6f);
        for (int i = 0; i < 2; ++i) {
            double ox = (random.nextDouble() - 0.5) * 3.5;
            double oz = (random.nextDouble() - 0.5) * 3.5;
            LightningBolt bolt = new LightningBolt(EntityType.LIGHTNING_BOLT, (Level)world);
            bolt.moveTo((double)pos.getX() + ox, (double)pos.getY(), (double)pos.getZ() + oz);
            bolt.setVisualOnly(true);
            world.addFreshEntity((Entity)bolt);
        }
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:enchant ~ ~1 ~ 2 2 2 0.1 150 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:end_rod ~ ~1 ~ 2 2 2 0.05 100 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:flash ~ ~1 ~ 1 1 1 0.01 3 force");
    }

    public static void spawnGiratinaEffect(ServerLevel world, BlockPos pos) {
        RandomSource random = world.getRandom();
        CommandSourceStack source = world.getServer().createCommandSourceStack().withPosition(pos.getCenter()).withLevel(world).withSuppressedOutput();
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.WITHER_SPAWN, SoundSource.AMBIENT, 0.9f, 0.8f);
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (Holder)SoundEvents.AMBIENT_BASALT_DELTAS_MOOD, SoundSource.AMBIENT, 0.6f, 1.0f);
        for (int i = 0; i < 3; ++i) {
            double ox = (random.nextDouble() - 0.5) * 5.0;
            double oz = (random.nextDouble() - 0.5) * 5.0;
            LightningBolt bolt = new LightningBolt(EntityType.LIGHTNING_BOLT, (Level)world);
            bolt.moveTo((double)pos.getX() + ox, (double)pos.getY(), (double)pos.getZ() + oz);
            bolt.setVisualOnly(true);
            world.addFreshEntity((Entity)bolt);
        }
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:soul ~ ~1 ~ 2 2 2 0.05 120 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:soul_fire_flame ~ ~1 ~ 2 2 2 0.05 150 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:ash ~ ~1 ~ 2 2 2 0.1 120 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:portal ~ ~1 ~ 2 2 2 0.2 100 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:flash ~ ~1 ~ 1 1 1 0.01 3 force");
    }

    public static void spawnMewEffect(ServerLevel world, BlockPos pos) {
        RandomSource random = world.getRandom();
        CommandSourceStack source = world.getServer().createCommandSourceStack().withPosition(pos.getCenter()).withLevel(world).withSuppressedOutput();
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.AMBIENT, 0.8f, 1.6f);
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.ALLAY_AMBIENT_WITH_ITEM, SoundSource.AMBIENT, 0.6f, 1.4f);
        if (random.nextFloat() < 0.3f) {
            LightningBolt bolt = new LightningBolt(EntityType.LIGHTNING_BOLT, (Level)world);
            bolt.moveTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
            bolt.setVisualOnly(true);
            world.addFreshEntity((Entity)bolt);
        }
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:end_rod ~ ~1 ~ 1.5 1.5 1.5 0.02 60 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:heart ~ ~1 ~ 0.8 0.8 0.8 0.0 10 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:enchant ~ ~1 ~ 1.2 1.2 1.2 0.05 80 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 1.0 0.5 0.9 1.2 ~ ~0.8 ~ 1.2 0.6 1.2 0.02 120 force");
        world.getServer().execute(() -> {
            try {
                Thread.sleep(300L);
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:flash ~ ~1 ~ 0.2 0.2 0.2 0.01 1 force");
                world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.AMETHYST_BLOCK_RESONATE, SoundSource.AMBIENT, 0.7f, 1.8f);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        Vec3 center = new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
        for (int i = 0; i < 80; ++i) {
            double angle = random.nextDouble() * Math.PI * 2.0;
            double radius = 0.4 + random.nextDouble() * 1.4;
            double x = center.x + Math.cos(angle) * radius;
            double z = center.z + Math.sin(angle) * radius;
            double y = center.y + random.nextDouble() * 1.2;
            world.sendParticles((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.6f, 0.95f), 1.0f), x, y, z, 1, 0.0, 0.03, 0.0, 0.0);
            if (i % 6 != 0) continue;
            world.sendParticles((ParticleOptions)ParticleTypes.GLOW, x, y + 0.2, z, 1, 0.0, 0.0, 0.0, 0.02);
        }
    }
}

