/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.villager;

import com.cobblemon.mod.common.CobblemonItems;
import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.ModBlocks;
import github.jorgaomc.ModItems;
import java.util.Optional;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.fabricmc.fabric.api.object.builder.v1.villager.VillagerProfessionBuilder;
import net.fabricmc.fabric.api.object.builder.v1.world.poi.PointOfInterestHelper;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class ModVillagers {
    public static final PoiType ENTREPRENEUR_POI = ModVillagers.registerPOI("entrepreneur_poi", ModBlocks.SUITCASE_BLOCK);
    public static final VillagerProfession ENTREPRENEUR = ModVillagers.registerProfession("entrepreneur", (ResourceKey<PoiType>)ResourceKey.create((ResourceKey)BuiltInRegistries.POINT_OF_INTEREST_TYPE.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"entrepreneur_poi")));

    public static void registerVillagers() {
        LegendaryMonuments.LOGGER.info("Registering Villagers for legendarymonuments");
    }

    public static void registerTrades() {
        TradeOfferHelper.registerVillagerOffers((VillagerProfession)ENTREPRENEUR, (int)1, factories -> {
            factories.add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)CobblemonItems.RELIC_COIN, 2), 30, 2, 0.2f));
            factories.add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.GALAR_PARTICLE, 6), new ItemStack((ItemLike)Items.EMERALD, 1), 30, 2, 0.2f));
        });
        TradeOfferHelper.registerVillagerOffers((VillagerProfession)ENTREPRENEUR, (int)2, factories -> {
            factories.add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 32), Optional.of(new ItemCost((ItemLike)CobblemonItems.RELIC_COIN, 32)), new ItemStack((ItemLike)ModItems.POKETREAT_BOX, 1), 5, 15, 0.2f));
            factories.add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 45), Optional.of(new ItemCost((ItemLike)CobblemonItems.RELIC_COIN, 50)), new ItemStack((ItemLike)ModBlocks.DREAM_CATCHER.asItem(), 1), 2, 20, 0.2f));
        });
        TradeOfferHelper.registerVillagerOffers((VillagerProfession)ENTREPRENEUR, (int)3, factories -> {
            factories.add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 40), Optional.of(new ItemCost((ItemLike)CobblemonItems.RELIC_COIN, 48)), new ItemStack((ItemLike)ModItems.FIRESCOURGE_SEAL, 1), 1, 25, 0.2f));
            factories.add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 40), Optional.of(new ItemCost((ItemLike)CobblemonItems.RELIC_COIN, 48)), new ItemStack((ItemLike)ModItems.ICEREND_SEAL, 1), 1, 25, 0.2f));
            factories.add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 40), Optional.of(new ItemCost((ItemLike)CobblemonItems.RELIC_COIN, 48)), new ItemStack((ItemLike)ModItems.GRASSWITHER_SEAL, 1), 1, 25, 0.2f));
            factories.add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 40), Optional.of(new ItemCost((ItemLike)CobblemonItems.RELIC_COIN, 48)), new ItemStack((ItemLike)ModItems.GROUNDBLIGHT_SEAL, 1), 1, 25, 0.2f));
        });
        TradeOfferHelper.registerVillagerOffers((VillagerProfession)ENTREPRENEUR, (int)4, factories -> {
            factories.add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 48), Optional.of(new ItemCost((ItemLike)CobblemonItems.RELIC_COIN_POUCH, 16)), new ItemStack((ItemLike)ModItems.NIGHTMARE_ESSENCE, 1), 1, 25, 0.2f));
            factories.add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 48), Optional.of(new ItemCost((ItemLike)CobblemonItems.RELIC_COIN_POUCH, 16)), new ItemStack((ItemLike)ModItems.LUNAR_FEATHER, 1), 1, 25, 0.2f));
        });
        TradeOfferHelper.registerVillagerOffers((VillagerProfession)ENTREPRENEUR, (int)5, factories -> {
            factories.add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 64), Optional.of(new ItemCost((ItemLike)CobblemonItems.RELIC_COIN, 64)), new ItemStack((ItemLike)ModItems.CELESTICA_FLUTE, 1), 1, 30, 0.2f));
            factories.add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 60), Optional.of(new ItemCost((ItemLike)CobblemonItems.RELIC_COIN, 64)), new ItemStack((ItemLike)ModItems.SILVER_WING, 1), 1, 30, 0.2f));
        });
    }

    private static PoiType registerPOI(String name, Block block) {
        return PointOfInterestHelper.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)name), (int)1, (int)1, (Block[])new Block[]{block});
    }

    private static VillagerProfession registerProfession(String name, ResourceKey<PoiType> poiKey) {
        if (poiKey == null) {
            LegendaryMonuments.LOGGER.error("POI key is null for profession: " + name);
            return null;
        }
        return (VillagerProfession)Registry.register((Registry)BuiltInRegistries.VILLAGER_PROFESSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)name), (Object)VillagerProfessionBuilder.create().id(ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)name)).workstation(poiKey).workSound(SoundEvents.VILLAGER_WORK_MASON).build());
    }
}

