/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.world;

import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class CosmicDustFeature
extends Feature<NoneFeatureConfiguration> {
    public static final Feature<NoneFeatureConfiguration> INSTANCE = new CosmicDustFeature();

    private CosmicDustFeature() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public static void register() {
        Registry.register((Registry)BuiltInRegistries.FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"cosmic_dust_feature"), INSTANCE);
        LegendaryMonuments.LOGGER.info("Registered cosmic dust feature");
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        BlockPos placePos = null;
        for (int tries = 0; tries < 10 && placePos == null; ++tries) {
            BlockPos tryPos = pos.offset(random.nextIntBetweenInclusive(-3, 3), random.nextIntBetweenInclusive(-2, 2), random.nextIntBetweenInclusive(-3, 3));
            if (!this.isValidCosmicDustPosition(world, tryPos)) continue;
            placePos = tryPos;
        }
        if (placePos == null) {
            return false;
        }
        this.placeCosmicDust(world, placePos);
        return true;
    }

    private boolean isValidCosmicDustPosition(WorldGenLevel world, BlockPos pos) {
        if (!world.getBlockState(pos).isAir()) {
            return false;
        }
        BlockState below = world.getBlockState(pos.below());
        String blockName = BuiltInRegistries.BLOCK.getKey((Object)below.getBlock()).toString();
        return blockName.equals("minecraft:end_stone") || blockName.equals("minecraft:obsidian") || blockName.equals("minecraft:purpur_block");
    }

    private void placeCosmicDust(WorldGenLevel world, BlockPos pos) {
        LegendaryMonuments.LOGGER.debug("Spawning cosmic dust block at {}", (Object)pos);
        world.setBlock(pos, ModBlocks.COSMIC_DUST_BLOCK.defaultBlockState(), 3);
    }
}

