/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.world;

import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class FootprintFeature
extends Feature<NoneFeatureConfiguration> {
    public static final Feature<NoneFeatureConfiguration> INSTANCE = new FootprintFeature();

    private FootprintFeature() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public static void register() {
        Registry.register((Registry)BuiltInRegistries.FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"footprint_feature"), INSTANCE);
        LegendaryMonuments.LOGGER.info("Registered footprint feature");
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        BlockPos placePos = null;
        for (int tries = 0; tries < 5 && placePos == null; ++tries) {
            BlockPos tryPos = pos.offset(random.nextIntBetweenInclusive(-1, 1), 0, random.nextIntBetweenInclusive(-1, 1));
            if (!this.isValidFootprintPosition(world, tryPos = this.getTopSolidBlock(world, tryPos))) continue;
            placePos = tryPos;
        }
        if (placePos == null) {
            return false;
        }
        this.placeRandomFootprint(world, placePos, random);
        return true;
    }

    private BlockPos getTopSolidBlock(WorldGenLevel world, BlockPos pos) {
        BlockState state;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(pos.getX(), world.getMaxBuildHeight() - 1, pos.getZ());
        while (mutable.getY() > world.getMinBuildHeight() && ((state = world.getBlockState((BlockPos)mutable)).isAir() || !state.isCollisionShapeFullBlock((BlockGetter)world, (BlockPos)mutable))) {
            mutable.move(0, -1, 0);
        }
        return mutable.above();
    }

    private boolean isValidFootprintPosition(WorldGenLevel world, BlockPos pos) {
        if (!world.getBlockState(pos).isAir()) {
            return false;
        }
        BlockState below = world.getBlockState(pos.below());
        return below.isSolid() && below.isCollisionShapeFullBlock((BlockGetter)world, pos.below());
    }

    private void placeRandomFootprint(WorldGenLevel world, BlockPos pos, RandomSource random) {
        Block footprintBlock;
        int type = random.nextInt(3);
        switch (type) {
            case 0: {
                footprintBlock = ModBlocks.TERRAKION_FOOTPRINTS;
                LegendaryMonuments.LOGGER.debug("Spawning Terrakion footprint at {}", (Object)pos);
                break;
            }
            case 1: {
                footprintBlock = ModBlocks.COBALION_FOOTPRINTS;
                LegendaryMonuments.LOGGER.debug("Spawning Cobalion footprint at {}", (Object)pos);
                break;
            }
            default: {
                footprintBlock = ModBlocks.VIRIZION_FOOTPRINTS;
                LegendaryMonuments.LOGGER.debug("Spawning Virizion footprint at {}", (Object)pos);
            }
        }
        world.setBlock(pos, footprintBlock.defaultBlockState(), 3);
    }
}

