/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.world;

import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class IlexShrineFeature
extends Feature<NoneFeatureConfiguration> {
    public static final Feature<NoneFeatureConfiguration> INSTANCE = new IlexShrineFeature();

    private IlexShrineFeature() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public static void register() {
        Registry.register((Registry)BuiltInRegistries.FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"ilex_shrine_feature"), INSTANCE);
        LegendaryMonuments.LOGGER.info("Registered Ilex Shrine feature");
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        if (random.nextFloat() > 0.2f) {
            return false;
        }
        BlockPos placePos = null;
        for (int tries = 0; tries < 8 && placePos == null; ++tries) {
            BlockPos tryPos = pos.offset(random.nextIntBetweenInclusive(-6, 6), 0, random.nextIntBetweenInclusive(-6, 6));
            if (!this.isValidShrinePosition(world, tryPos = this.getTopSolidBlock(world, tryPos))) continue;
            placePos = tryPos;
        }
        if (placePos == null) {
            return false;
        }
        BlockState shrineState = ModBlocks.ILEX_SHRINE.defaultBlockState();
        world.setBlock(placePos, shrineState, 3);
        LegendaryMonuments.LOGGER.debug("Spawned Ilex Shrine at {}", placePos);
        return true;
    }

    private BlockPos getTopSolidBlock(WorldGenLevel world, BlockPos pos) {
        BlockState state;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(pos.getX(), world.getMaxBuildHeight() - 1, pos.getZ());
        while (mutable.getY() > world.getMinBuildHeight() && ((state = world.getBlockState((BlockPos)mutable)).isAir() || !state.isCollisionShapeFullBlock((BlockGetter)world, (BlockPos)mutable) || this.isLeavesBlock(state))) {
            mutable.move(0, -1, 0);
        }
        return mutable.above();
    }

    private boolean isValidShrinePosition(WorldGenLevel world, BlockPos pos) {
        if (!world.getBlockState(pos).isAir() || !world.getBlockState(pos.above()).isAir()) {
            return false;
        }
        BlockState below = world.getBlockState(pos.below());
        if (!below.isSolid() || !below.isCollisionShapeFullBlock((BlockGetter)world, pos.below()) || this.isLeavesBlock(below)) {
            return false;
        }
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos checkPos = pos.below().offset(x, 0, z);
                BlockState checkState = world.getBlockState(checkPos);
                if (!this.isLeavesBlock(checkState)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isLeavesBlock(BlockState state) {
        if (state.is(BlockTags.LEAVES)) {
            return true;
        }
        if (state.is(Blocks.OAK_LEAVES) || state.is(Blocks.BIRCH_LEAVES) || state.is(Blocks.SPRUCE_LEAVES) || state.is(Blocks.JUNGLE_LEAVES) || state.is(Blocks.ACACIA_LEAVES) || state.is(Blocks.DARK_OAK_LEAVES) || state.is(Blocks.MANGROVE_LEAVES) || state.is(Blocks.CHERRY_LEAVES) || state.is(Blocks.AZALEA_LEAVES) || state.is(Blocks.FLOWERING_AZALEA_LEAVES)) {
            return true;
        }
        String blockName = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).getPath().toLowerCase();
        return blockName.contains("leaves");
    }
}

