/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.world;

import github.jorgaomc.ModBlocks;
import github.jorgaomc.world.feature.DistortionTreeFeature;
import github.jorgaomc.world.feature.MiniMountainFeature;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class ModConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> ANCIENT_RUBBLE_ORE_KEY = ModConfiguredFeatures.registerKey("ancient_rubble_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GALAR_PARTICLE_ORE_KEY = ModConfiguredFeatures.registerKey("galar_particle_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DEEPSLATE_GALAR_PARTICLE_ORE_KEY = ModConfiguredFeatures.registerKey("deepslate_galar_particle_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DISTORTION_TREE_KEY = ModConfiguredFeatures.registerKey("distortion_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MINI_MOUNTAIN_KEY = ModConfiguredFeatures.registerKey("mini_mountain");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        TagMatchTest stoneReplaceables = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        TagMatchTest deepslateReplaceables = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
        List<OreConfiguration.TargetBlockState> ancientRubbleOres = List.of(OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)ModBlocks.ANCIENT_RUBBLE_ORE.defaultBlockState()));
        List<OreConfiguration.TargetBlockState> deepslateancientRubbleOres = List.of(OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)ModBlocks.ANCIENT_RUBBLE_ORE.defaultBlockState()));
        List<OreConfiguration.TargetBlockState> galarParticleOres = List.of(OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)ModBlocks.GALAR_PARTICLE_ORE.defaultBlockState()));
        List<OreConfiguration.TargetBlockState> deepslateGalarParticleOres = List.of(OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)ModBlocks.DEEPSLATE_GALAR_PARTICLE_ORE.defaultBlockState()));
        ModConfiguredFeatures.register(context, ANCIENT_RUBBLE_ORE_KEY, Feature.ORE, new OreConfiguration(ancientRubbleOres, 5));
        ModConfiguredFeatures.register(context, GALAR_PARTICLE_ORE_KEY, Feature.ORE, new OreConfiguration(galarParticleOres, 9));
        ModConfiguredFeatures.register(context, DEEPSLATE_GALAR_PARTICLE_ORE_KEY, Feature.ORE, new OreConfiguration(deepslateGalarParticleOres, 9));
        ModConfiguredFeatures.register(context, DISTORTION_TREE_KEY, DistortionTreeFeature.DISTORTION_TREE_FEATURE, new NoneFeatureConfiguration());
        ModConfiguredFeatures.register(context, MINI_MOUNTAIN_KEY, MiniMountainFeature.MINI_MOUNTAIN_FEATURE, new NoneFeatureConfiguration());
    }

    private static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

