/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.world;

import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.world.ModConfiguredFeatures;
import github.jorgaomc.world.ModOrePlacement;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class ModPlacedFeatures {
    public static final ResourceKey<PlacedFeature> ANCIENT_RUBBLE_ORE_PLACED_KEY = ModPlacedFeatures.registerKey("ancient_rubble_ore_placed");
    public static final ResourceKey<PlacedFeature> GALAR_PARTICLE_ORE_PLACED_KEY = ModPlacedFeatures.registerKey("galar_particle_ore_placed");
    public static final ResourceKey<PlacedFeature> DEEPSLATE_GALAR_PARTICLE_ORE_PLACED_KEY = ModPlacedFeatures.registerKey("deepslate_galar_particle_ore_placed");
    public static final ResourceKey<PlacedFeature> DISTORTION_TREE_PLACED_KEY = ModPlacedFeatures.registerKey("distortion_tree_placed");
    public static final ResourceKey<PlacedFeature> MINI_MOUNTAIN_PLACED_KEY = ModPlacedFeatures.registerKey("mini_mountain_placed");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatureRegistry = context.lookup(Registries.CONFIGURED_FEATURE);
        ModPlacedFeatures.register(context, ANCIENT_RUBBLE_ORE_PLACED_KEY, configuredFeatureRegistry.getOrThrow(ModConfiguredFeatures.ANCIENT_RUBBLE_ORE_KEY), ModOrePlacement.modifiersWithCount(7, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)-80), (VerticalAnchor)VerticalAnchor.absolute((int)80))));
        ModPlacedFeatures.register(context, GALAR_PARTICLE_ORE_PLACED_KEY, configuredFeatureRegistry.getOrThrow(ModConfiguredFeatures.GALAR_PARTICLE_ORE_KEY), ModOrePlacement.modifiersWithCount(10, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-24), (VerticalAnchor)VerticalAnchor.absolute((int)56))));
        ModPlacedFeatures.register(context, DEEPSLATE_GALAR_PARTICLE_ORE_PLACED_KEY, configuredFeatureRegistry.getOrThrow(ModConfiguredFeatures.DEEPSLATE_GALAR_PARTICLE_ORE_KEY), ModOrePlacement.modifiersWithCount(10, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-24), (VerticalAnchor)VerticalAnchor.absolute((int)56))));
        ModPlacedFeatures.register(context, DISTORTION_TREE_PLACED_KEY, configuredFeatureRegistry.getOrThrow(ModConfiguredFeatures.DISTORTION_TREE_KEY), List.of(CountPlacement.of((int)3), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)60), (VerticalAnchor)VerticalAnchor.absolute((int)90)), BiomeFilter.biome()));
        ModPlacedFeatures.register(context, MINI_MOUNTAIN_PLACED_KEY, configuredFeatureRegistry.getOrThrow(ModConfiguredFeatures.MINI_MOUNTAIN_KEY), List.of(RarityFilter.onAverageOnceEvery((int)8), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)60), (VerticalAnchor)VerticalAnchor.absolute((int)80)), BiomeFilter.biome()));
    }

    public static void registerPlacedFeatures() {
        LegendaryMonuments.LOGGER.info("Registering ModPlacedFeatures for legendarymonuments");
        LegendaryMonuments.LOGGER.info("Registering Ancient Rubble ore placed features");
        LegendaryMonuments.LOGGER.info("Registering Galar Particle ore placed features");
    }

    private static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)name));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }
}

