/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.world;

import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class StakeFeature
extends Feature<NoneFeatureConfiguration> {
    public static final Feature<NoneFeatureConfiguration> INSTANCE = new StakeFeature();

    private StakeFeature() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public static void register() {
        Registry.register((Registry)BuiltInRegistries.FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"stake_feature"), INSTANCE);
        LegendaryMonuments.LOGGER.info("Registered stake feature");
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        BlockPos placePos = null;
        for (int tries = 0; tries < 5 && placePos == null; ++tries) {
            BlockPos tryPos = pos.offset(random.nextIntBetweenInclusive(-3, 3), random.nextIntBetweenInclusive(-1, 3), random.nextIntBetweenInclusive(-3, 3));
            if (!this.isValidStakePosition(world, tryPos = this.getTopSolidBlock(world, tryPos))) continue;
            placePos = tryPos;
        }
        if (placePos == null) {
            return false;
        }
        this.placeRandomStake(world, placePos, random);
        return true;
    }

    private BlockPos getTopSolidBlock(WorldGenLevel world, BlockPos pos) {
        BlockState state;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(pos.getX(), Math.min(pos.getY() + 3, world.getMaxBuildHeight() - 1), pos.getZ());
        while (mutable.getY() > world.getMinBuildHeight() && ((state = world.getBlockState((BlockPos)mutable)).isAir() || !state.isCollisionShapeFullBlock((BlockGetter)world, (BlockPos)mutable))) {
            mutable.move(0, -1, 0);
        }
        return mutable.above();
    }

    private boolean isValidStakePosition(WorldGenLevel world, BlockPos pos) {
        if (!world.getBlockState(pos).isAir()) {
            return false;
        }
        BlockState below = world.getBlockState(pos.below());
        String blockName = BuiltInRegistries.BLOCK.getKey((Object)below.getBlock()).toString();
        return blockName.equals("minecraft:netherrack") || blockName.equals("minecraft:soul_soil") || blockName.equals("minecraft:basalt") || blockName.equals("minecraft:crimson_nylium") || blockName.equals("minecraft:warped_nylium") || blockName.contains("nether");
    }

    private void placeRandomStake(WorldGenLevel world, BlockPos pos, RandomSource random) {
        Block stakeBlock;
        int type = random.nextInt(4);
        switch (type) {
            case 0: {
                stakeBlock = ModBlocks.FIRESCOURGE_STAKE;
                LegendaryMonuments.LOGGER.debug("Spawning Firescourge stake at {}", (Object)pos);
                break;
            }
            case 1: {
                stakeBlock = ModBlocks.GRASSWITHER_STAKE;
                LegendaryMonuments.LOGGER.debug("Spawning Grasswither stake at {}", (Object)pos);
                break;
            }
            case 2: {
                stakeBlock = ModBlocks.ICEREND_STAKE;
                LegendaryMonuments.LOGGER.debug("Spawning Icerend stake at {}", (Object)pos);
                break;
            }
            default: {
                stakeBlock = ModBlocks.GROUNDBLIGHT_STAKE;
                LegendaryMonuments.LOGGER.debug("Spawning Groundblight stake at {}", (Object)pos);
            }
        }
        world.setBlock(pos, stakeBlock.defaultBlockState(), 3);
    }
}

