/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.world.dimension;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import github.jorgaomc.ModBlocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;

public class DistortionDimensionChunkGenerator
extends ChunkGenerator {
    public static final MapCodec<DistortionDimensionChunkGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BiomeSource.CODEC.fieldOf("biome_source").forGetter(generator -> generator.biomeSource), (App)IslandConfig.CODEC.fieldOf("island_config").forGetter(generator -> generator.islandConfig)).apply((Applicative)instance, DistortionDimensionChunkGenerator::new));
    private final IslandConfig islandConfig;
    private static final int REGULAR_ISLAND_GRID_SIZE = 20;
    private static final int MEGA_ISLAND_GRID_SIZE = 80;
    private static final float REGULAR_LARGE_ISLAND_CHANCE = 0.5f;
    private static final float REGULAR_MEDIUM_ISLAND_DENSITY = 0.15f;
    private static final float MEGA_ISLAND_CHANCE = 0.25f;
    private static final int MIN_REGULAR_HEIGHT = 60;
    private static final int MAX_REGULAR_HEIGHT = 180;
    private static final int MIN_MEGA_HEIGHT = 80;
    private static final int MAX_MEGA_HEIGHT = 200;
    private static final int[] HEIGHT_LAYERS = new int[]{-20, 30, 90, 150, 220, 280};
    private static final float LAYER_CHANCE = 0.08f;
    private static final double NOISE_SCALE_LARGE = 0.03;
    private static final double NOISE_SCALE_MEDIUM = 0.05;
    private static final double NOISE_SCALE_SMALL = 0.08;
    private static final double NOISE_SCALE_MEGA = 0.015;
    private static final double EDGE_THRESHOLD = 0.6;
    private static final double MEGA_EDGE_THRESHOLD = 0.5;
    private static final Map<String, Double> noiseCache = new ConcurrentHashMap<String, Double>();
    private static final Map<String, IslandData> generatedIslands = new ConcurrentHashMap<String, IslandData>();

    public DistortionDimensionChunkGenerator(BiomeSource biomeSource, IslandConfig islandConfig) {
        super(biomeSource);
        this.islandConfig = islandConfig;
    }

    public MapCodec<? extends ChunkGenerator> codec() {
        return CODEC;
    }

    public int getSeaLevel() {
        return -100;
    }

    public void applyCarvers(WorldGenRegion chunkRegion, long seed, RandomState noiseConfig, BiomeManager biomeAccess, StructureManager structureAccessor, ChunkAccess chunk, GenerationStep.Carving carverStep) {
    }

    public void buildSurface(WorldGenRegion region, StructureManager structures, RandomState noiseConfig, ChunkAccess chunk) {
    }

    public CompletableFuture<ChunkAccess> fillFromNoise(Blender blender, RandomState noiseConfig, StructureManager structureAccessor, ChunkAccess chunk) {
        this.generateIslandsForChunk(chunk);
        return CompletableFuture.completedFuture(chunk);
    }

    private void generateIslandsForChunk(ChunkAccess chunk) {
        int chunkX = chunk.getPos().x;
        int chunkZ = chunk.getPos().z;
        RandomSource random = RandomSource.create((long)((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L));
        this.renderExistingIslandsInChunk(chunk, chunkX, chunkZ, random);
        this.generateMegaIslands(chunk, chunkX, chunkZ, random);
        if (!this.isInMegaIslandExclusionZone(chunkX, chunkZ)) {
            this.generateRegularIslands(chunk, chunkX, chunkZ, random);
        }
        this.generateLayerIslands(chunk, chunkX, chunkZ, random);
        this.renderExistingIslandsInChunk(chunk, chunkX, chunkZ, random);
    }

    private void renderExistingIslandsInChunk(ChunkAccess chunk, int chunkX, int chunkZ, RandomSource fallbackRandom) {
        ArrayList<IslandData> snapshot = new ArrayList<IslandData>(generatedIslands.values());
        for (IslandData data : snapshot) {
            if (!this.shouldGenerateInChunk(chunkX, chunkZ, data.position, data.radius)) continue;
            long seed = (long)data.position.getX() * 73428767L ^ (long)data.position.getZ() * 912931L ^ (long)data.position.getY() * 1315423911L ^ (long)data.type.ordinal() * 2654435761L;
            RandomSource islandRandom = RandomSource.create((long)seed);
            this.generateIslandInChunk(chunk, chunkX, chunkZ, data.position, data.radius, data.type, islandRandom);
        }
    }

    private void generateMegaIslands(ChunkAccess chunk, int chunkX, int chunkZ, RandomSource random) {
        int baseAnchorX = Math.floorDiv(chunkX, 80) * 80;
        int baseAnchorZ = Math.floorDiv(chunkZ, 80) * 80;
        for (int ax = -1; ax <= 1; ++ax) {
            for (int az = -1; az <= 1; ++az) {
                int secondY;
                int anchorChunkX = baseAnchorX + ax * 80;
                int anchorChunkZ = baseAnchorZ + az * 80;
                RandomSource megaRandom = RandomSource.create((long)((long)anchorChunkX * 891273487123L + (long)anchorChunkZ * 456789123456L));
                if (!(megaRandom.nextFloat() < 0.25f)) continue;
                int radius = megaRandom.nextIntBetweenInclusive(80, 150);
                int baseY = megaRandom.nextIntBetweenInclusive(80, 200);
                this.generateMegaIslandAtHeight(chunk, chunkX, chunkZ, anchorChunkX, anchorChunkZ, radius, baseY, megaRandom);
                if (!((double)megaRandom.nextFloat() < 0.3) || (secondY = baseY + megaRandom.nextIntBetweenInclusive(-60, 60)) <= 20 || secondY >= 300) continue;
                this.generateMegaIslandAtHeight(chunk, chunkX, chunkZ, anchorChunkX, anchorChunkZ, radius - 20, secondY, megaRandom);
            }
        }
    }

    private void generateMegaIslandAtHeight(ChunkAccess chunk, int chunkX, int chunkZ, int testChunkX, int testChunkZ, int radius, int y, RandomSource megaRandom) {
        int gridCenterX = testChunkX / 80 * 80 * 16 + 640;
        int gridCenterZ = testChunkZ / 80 * 80 * 16 + 640;
        BlockPos islandPos = new BlockPos(gridCenterX + megaRandom.nextIntBetweenInclusive(-64, 64), y, gridCenterZ + megaRandom.nextIntBetweenInclusive(-64, 64));
        String islandKey = String.format("mega_%d_%d_%d_%d", islandPos.getX(), islandPos.getY(), islandPos.getZ(), radius);
        if (generatedIslands.putIfAbsent(islandKey, new IslandData(islandPos, radius, IslandType.MEGA)) == null || this.shouldGenerateInChunk(chunkX, chunkZ, islandPos, radius)) {
            this.generateIslandInChunk(chunk, chunkX, chunkZ, islandPos, radius, IslandType.MEGA, megaRandom);
        }
    }

    private void generateRegularIslands(ChunkAccess chunk, int chunkX, int chunkZ, RandomSource random) {
        int baseAnchorX = Math.floorDiv(chunkX, 20) * 20;
        int baseAnchorZ = Math.floorDiv(chunkZ, 20) * 20;
        boolean placedLargeCandidate = false;
        for (int ax = -1; ax <= 1; ++ax) {
            for (int az = -1; az <= 1; ++az) {
                int anchorChunkX = baseAnchorX + ax * 20;
                int anchorChunkZ = baseAnchorZ + az * 20;
                RandomSource largeRandom = RandomSource.create((long)((long)anchorChunkX * 341873128712L + (long)anchorChunkZ * 132897987541L));
                if (!(largeRandom.nextFloat() < 0.5f)) continue;
                int radius = largeRandom.nextIntBetweenInclusive(28, 50);
                int[] possibleHeights = new int[]{largeRandom.nextIntBetweenInclusive(60, 180), largeRandom.nextIntBetweenInclusive(20, 60), largeRandom.nextIntBetweenInclusive(180, 220)};
                for (int heightIndex = 0; heightIndex < possibleHeights.length; ++heightIndex) {
                    int y;
                    if (heightIndex > 0 && (double)largeRandom.nextFloat() > 0.4 || (y = possibleHeights[heightIndex]) < -30 || y > 320) continue;
                    int gridCenterX = anchorChunkX / 20 * 20 * 16 + 160;
                    int gridCenterZ = anchorChunkZ / 20 * 20 * 16 + 160;
                    BlockPos islandPos = new BlockPos(gridCenterX + largeRandom.nextIntBetweenInclusive(-32, 32), y, gridCenterZ + largeRandom.nextIntBetweenInclusive(-32, 32));
                    String islandKey = String.format("large_%d_%d_%d_%d", islandPos.getX(), islandPos.getY(), islandPos.getZ(), radius);
                    if (generatedIslands.putIfAbsent(islandKey, new IslandData(islandPos, radius, IslandType.LARGE)) != null && !this.shouldGenerateInChunk(chunkX, chunkZ, islandPos, radius)) continue;
                    this.generateIslandInChunk(chunk, chunkX, chunkZ, islandPos, radius, IslandType.LARGE, largeRandom);
                    placedLargeCandidate = true;
                }
            }
        }
        if (!placedLargeCandidate) {
            double noiseValue = Math.sin((double)chunkX * 0.1) * Math.cos((double)chunkZ * 0.1) + Math.sin((double)chunkX * 0.05 + 50.0) * Math.cos((double)chunkZ * 0.05 + 50.0) * 0.5;
            if ((double)random.nextFloat() < (double)0.15f * (0.8 + noiseValue * 0.4)) {
                int radius = random.nextIntBetweenInclusive(12, 28);
                for (int attempt = 0; attempt < 2; ++attempt) {
                    int y;
                    if (attempt > 0 && (double)random.nextFloat() > 0.3 || (y = random.nextIntBetweenInclusive(40, 200)) < -30 || y > 320) continue;
                    int chunkCenterX = chunkX * 16 + 8;
                    int chunkCenterZ = chunkZ * 16 + 8;
                    BlockPos islandPos = new BlockPos(chunkCenterX + random.nextIntBetweenInclusive(-8, 8), y, chunkCenterZ + random.nextIntBetweenInclusive(-8, 8));
                    String islandKey = String.format("medium_%d_%d_%d_%d", islandPos.getX(), islandPos.getY(), islandPos.getZ(), radius);
                    if (generatedIslands.putIfAbsent(islandKey, new IslandData(islandPos, radius, IslandType.MEDIUM)) != null) continue;
                    this.generateIslandInChunk(chunk, chunkX, chunkZ, islandPos, radius, IslandType.MEDIUM, random);
                }
            }
        }
    }

    private void generateLayerIslands(ChunkAccess chunk, int chunkX, int chunkZ, RandomSource random) {
        for (int heightLayer : HEIGHT_LAYERS) {
            if (!(random.nextFloat() < 0.08f)) continue;
            int radius = random.nextIntBetweenInclusive(8, 18);
            int chunkCenterX = chunkX * 16 + random.nextIntBetweenInclusive(0, 15);
            int chunkCenterZ = chunkZ * 16 + random.nextIntBetweenInclusive(0, 15);
            BlockPos islandPos = new BlockPos(chunkCenterX, heightLayer, chunkCenterZ);
            String islandKey = String.format("layer_%d_%d_%d_%d", islandPos.getX(), islandPos.getY(), islandPos.getZ(), radius);
            if (generatedIslands.putIfAbsent(islandKey, new IslandData(islandPos, radius, IslandType.LAYER)) != null) continue;
            this.generateIslandInChunk(chunk, chunkX, chunkZ, islandPos, radius, IslandType.LAYER, random);
        }
    }

    private boolean shouldGenerateInChunk(int chunkX, int chunkZ, BlockPos islandCenter, int radius) {
        int chunkMinX = chunkX * 16;
        int chunkMaxX = chunkMinX + 15;
        int chunkMinZ = chunkZ * 16;
        int chunkMaxZ = chunkMinZ + 15;
        int islandMinX = islandCenter.getX() - radius;
        int islandMaxX = islandCenter.getX() + radius;
        int islandMinZ = islandCenter.getZ() - radius;
        int islandMaxZ = islandCenter.getZ() + radius;
        return islandMaxX >= chunkMinX && islandMinX <= chunkMaxX && islandMaxZ >= chunkMinZ && islandMinZ <= chunkMaxZ;
    }

    private void generateIslandInChunk(ChunkAccess chunk, int chunkX, int chunkZ, BlockPos center, int radius, IslandType type, RandomSource random) {
        int maxThickness;
        boolean hasLake;
        int chunkMinX = chunkX * 16;
        int chunkMaxX = chunkMinX + 15;
        int chunkMinZ = chunkZ * 16;
        int chunkMaxZ = chunkMinZ + 15;
        boolean bl = hasLake = type == IslandType.MEGA && radius > 60 && (double)random.nextFloat() < 0.7 || type == IslandType.LARGE && radius > 30 && (double)random.nextFloat() < 0.3 || type == IslandType.MEDIUM && radius > 20 && (double)random.nextFloat() < 0.2;
        int lakeRadius = hasLake ? Math.max(4, radius / (type == IslandType.MEGA ? 8 : 6)) : 0;
        double noiseAmplitude = switch (type.ordinal()) {
            case 3 -> {
                maxThickness = Math.min(25, Math.max(12, radius / 4));
                yield 0.25 + random.nextDouble() * 0.35;
            }
            case 2 -> {
                maxThickness = Math.min(20, Math.max(10, radius / 3));
                yield 0.3 + random.nextDouble() * 0.4;
            }
            case 4 -> {
                maxThickness = Math.min(8, Math.max(4, radius / 2));
                yield 0.4 + random.nextDouble() * 0.3;
            }
            default -> {
                maxThickness = Math.min(18, Math.max(8, radius / 3));
                yield 0.3 + random.nextDouble() * 0.4;
            }
        };
        int searchRadius = (int)((double)radius * (type == IslandType.MEGA ? 1.5 : 1.3));
        for (int x = -searchRadius; x <= searchRadius; ++x) {
            for (int z = -searchRadius; z <= searchRadius; ++z) {
                boolean isLake;
                int worldX = center.getX() + x;
                int worldZ = center.getZ() + z;
                if (worldX < chunkMinX || worldX > chunkMaxX || worldZ < chunkMinZ || worldZ > chunkMaxZ || !this.isPartOfIsland(random, x, z, radius, noiseAmplitude, type)) continue;
                double distance = Math.sqrt(x * x + z * z);
                double normalizedDistance = distance / (double)radius;
                double thicknessFactor = type == IslandType.MEGA ? Math.max(0.3, 1.0 - normalizedDistance * normalizedDistance * 0.8) : Math.max(0.2, 1.0 - normalizedDistance * normalizedDistance);
                int thickness = (int)((double)maxThickness * thicknessFactor);
                thickness = Math.max(type == IslandType.MEGA ? 6 : 4, thickness + random.nextInt(type == IslandType.MEGA ? 4 : 3) - 1);
                boolean bl2 = isLake = hasLake && distance < (double)lakeRadius;
                int topLayer = type == IslandType.MEGA ? 3 : (type == IslandType.LAYER ? 1 : 2);
                for (int y = -thickness; y <= topLayer; ++y) {
                    int worldY = center.getY() + y;
                    if (worldY < chunk.getMinBuildHeight() || worldY > chunk.getMaxBuildHeight() - 1) continue;
                    BlockPos pos = new BlockPos(worldX, worldY, worldZ);
                    int depthFromTop = topLayer - y;
                    int depthFromBottom = y + thickness;
                    int totalThickness = topLayer + thickness;
                    BlockState blockToPlace = this.getBlockForLayer(y, topLayer, isLake, random, this.islandConfig, depthFromTop, depthFromBottom, totalThickness);
                    chunk.setBlockState(pos, blockToPlace, false);
                }
            }
        }
    }

    private boolean isPartOfIsland(RandomSource random, int x, int z, int radius, double noiseAmplitude, IslandType type) {
        double edgeThreshold;
        double maxDistance;
        double distance = Math.sqrt(x * x + z * z);
        double normalizedDistance = distance / (double)radius;
        double d = maxDistance = type == IslandType.MEGA ? 1.4 : 1.2;
        if (normalizedDistance > maxDistance) {
            return false;
        }
        double noise = this.getIslandNoise(random, x, z, radius, type);
        double threshold = (type == IslandType.MEGA ? 0.5 : 0.6) + noise * noiseAmplitude;
        double d2 = edgeThreshold = type == IslandType.MEGA ? 0.6 : 0.8;
        if (normalizedDistance > edgeThreshold) {
            double chance;
            long seed = (long)x * 341873128712L + (long)z * 132897987541L;
            RandomSource posRandom = RandomSource.create((long)seed);
            double d3 = chance = type == IslandType.MEGA ? 0.2 : 0.1;
            if ((double)posRandom.nextFloat() < chance) {
                threshold += type == IslandType.MEGA ? 0.4 : 0.3;
            }
            if (type == IslandType.MEGA && (double)posRandom.nextFloat() < 0.15) {
                threshold -= 0.3;
            }
        }
        if (type == IslandType.MEGA && normalizedDistance < 0.3 && Math.abs(noise) > 0.8) {
            return false;
        }
        return normalizedDistance < threshold;
    }

    private double getIslandNoise(RandomSource random, double x, double z, int radius, IslandType type) {
        String cacheKey = String.format("%s_%.2f,%.2f,%d", type.name(), x, z, radius);
        return noiseCache.computeIfAbsent(cacheKey, k -> {
            if (type == IslandType.MEGA) {
                return this.generateMegaIslandNoise(x, z);
            }
            return this.generateRegularIslandNoise(x, z, radius);
        });
    }

    private double generateMegaIslandNoise(double x, double z) {
        double scale1 = 0.015;
        double scale2 = scale1 * 2.0;
        double scale3 = scale1 * 4.0;
        double scale4 = scale1 * 8.0;
        double noise1 = Math.sin(x * scale1) * Math.cos(z * scale1);
        double noise2 = Math.sin(x * scale2 + 1000.0) * Math.cos(z * scale2 + 1000.0) * 0.6;
        double noise3 = Math.sin(x * scale3 + 2000.0) * Math.cos(z * scale3 + 2000.0) * 0.3;
        double noise4 = Math.sin(x * scale4 + 3000.0) * Math.cos(z * scale4 + 3000.0) * 0.15;
        double angle1 = (x * 0.05 + z * 0.05) % (Math.PI * 2);
        double angle2 = (x * 0.03 + z * 0.07) % (Math.PI * 2);
        double directionalNoise1 = Math.sin(x * Math.cos(angle1) + z * Math.sin(angle1)) * 0.12;
        double directionalNoise2 = Math.sin(x * Math.cos(angle2) + z * Math.sin(angle2)) * 0.08;
        double ridgeNoise = Math.abs(Math.sin(x * scale2 + 500.0) * Math.cos(z * scale2 + 500.0)) * 0.25;
        return noise1 + noise2 + noise3 + noise4 + directionalNoise1 + directionalNoise2 + ridgeNoise;
    }

    private double generateRegularIslandNoise(double x, double z, int radius) {
        double scale1 = radius > 30 ? 0.03 : (radius > 20 ? 0.05 : 0.08);
        double scale2 = scale1 * 2.5;
        double scale3 = scale1 * 5.0;
        double noise1 = Math.sin(x * scale1) * Math.cos(z * scale1);
        double noise2 = Math.sin(x * scale2 + 100.0) * Math.cos(z * scale2 + 100.0) * 0.5;
        double noise3 = Math.sin(x * scale3 + 200.0) * Math.cos(z * scale3 + 200.0) * 0.25;
        double angle = (x * 0.1 + z * 0.1) % (Math.PI * 2);
        double directionalNoise = Math.sin(x * Math.cos(angle) + z * Math.sin(angle)) * 0.15;
        return noise1 + noise2 + noise3 + directionalNoise;
    }

    private BlockState getBlockForLayer(int y, int topLayer, boolean isLake, RandomSource random, IslandConfig config, int depthFromTop, int depthFromBottom, int totalThickness) {
        if (depthFromTop == 0) {
            return isLake ? Blocks.AIR.defaultBlockState() : ModBlocks.DISTORTION_COBBLESTONE.defaultBlockState();
        }
        if (depthFromTop == 1) {
            return isLake ? Blocks.WATER.defaultBlockState() : ModBlocks.DISTORTION_COBBLESTONE.defaultBlockState();
        }
        int cobbleLayers = Math.min(4, Math.max(2, totalThickness / 6 + (random.nextBoolean() ? 1 : 0)));
        int crystalBlockLayers = Math.min(3, Math.max(1, totalThickness / 10));
        if (depthFromBottom == 0) {
            return ModBlocks.DISTORTION_CRYSTAL.defaultBlockState();
        }
        if (depthFromBottom > 0 && depthFromBottom <= crystalBlockLayers) {
            return ModBlocks.DISTORTION_CRYSTAL_BLOCK.defaultBlockState();
        }
        if (depthFromTop == cobbleLayers + 1) {
            return ModBlocks.DISTORTION_STONE.defaultBlockState();
        }
        if (depthFromTop <= cobbleLayers + 0) {
            BlockState base = ModBlocks.DISTORTION_COBBLESTONE.defaultBlockState();
            return this.maybeReplaceWithOre(base, random, true);
        }
        BlockState base = ModBlocks.DISTORTION_DEEPSLATE.defaultBlockState();
        return this.maybeReplaceWithOre(base, random, false);
    }

    private BlockState maybeReplaceWithOre(BlockState base, RandomSource random, boolean isCobbleBand) {
        if (isCobbleBand) {
            if (random.nextFloat() < 0.06f) {
                return ModBlocks.DISTORTION_IRON_ORE.defaultBlockState();
            }
        } else {
            float roll = random.nextFloat();
            if (roll < 0.035f) {
                return ModBlocks.DISTORTION_DEEPSLATE_IRON_ORE.defaultBlockState();
            }
            if (roll > 0.995f || random.nextFloat() < 0.006f) {
                return ModBlocks.DISTORTION_ORIGIN_ORE.defaultBlockState();
            }
        }
        return base;
    }

    private boolean isInMegaIslandExclusionZone(int chunkX, int chunkZ) {
        for (int offsetX = -5; offsetX <= 5; ++offsetX) {
            for (int offsetZ = -5; offsetZ <= 5; ++offsetZ) {
                double distance;
                RandomSource megaRandom;
                int testChunkX = chunkX + offsetX * 80;
                int testChunkZ = chunkZ + offsetZ * 80;
                if (Math.floorMod(testChunkX, 80) != 0 || Math.floorMod(testChunkZ, 80) != 0 || !((megaRandom = RandomSource.create((long)((long)testChunkX * 891273487123L + (long)testChunkZ * 456789123456L))).nextFloat() < 0.25f) || !((distance = Math.sqrt(Math.pow((testChunkX - chunkX) * 16, 2.0) + Math.pow((testChunkZ - chunkZ) * 16, 2.0))) < 300.0)) continue;
                return true;
            }
        }
        return false;
    }

    public int getGenDepth() {
        return 448;
    }

    public void spawnOriginalMobs(WorldGenRegion region) {
    }

    public int getMinY() {
        return -64;
    }

    public int getBaseHeight(int x, int z, Heightmap.Types heightmapType, LevelHeightAccessor world, RandomState noiseConfig) {
        return this.getMinY();
    }

    public NoiseColumn getBaseColumn(int x, int z, LevelHeightAccessor world, RandomState noiseConfig) {
        Object[] states = new BlockState[world.getHeight()];
        Arrays.fill(states, Blocks.AIR.defaultBlockState());
        return new NoiseColumn(this.getMinY(), (BlockState[])states);
    }

    public void addDebugScreenInfo(List<String> text, RandomState noiseConfig, BlockPos pos) {
        text.add("Distortion World - Floating Islands");
    }

    public static void clearCaches() {
        noiseCache.clear();
        long currentTime = System.currentTimeMillis();
        long maxAge = 600000L;
        generatedIslands.entrySet().removeIf(entry -> currentTime - ((IslandData)entry.getValue()).timestamp > maxAge);
    }

    public static void clearWorldData() {
        noiseCache.clear();
        generatedIslands.clear();
    }

    public static class IslandConfig {
        public static final Codec<IslandConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list(OreConfig.CODEC).fieldOf("ores").forGetter(config -> config.ores)).apply((Applicative)instance, IslandConfig::new));
        public final List<OreConfig> ores;

        public IslandConfig(List<OreConfig> ores) {
            this.ores = ores;
        }
    }

    private static class IslandData {
        final BlockPos position;
        final int radius;
        final IslandType type;
        final long timestamp;

        IslandData(BlockPos position, int radius, IslandType type) {
            this.position = position;
            this.radius = radius;
            this.type = type;
            this.timestamp = System.currentTimeMillis();
        }
    }

    private static enum IslandType {
        SMALL,
        MEDIUM,
        LARGE,
        MEGA,
        LAYER;

    }

    public static class OreConfig {
        public static final Codec<OreConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("ore").forGetter(config -> config.ore), (App)Codec.DOUBLE.fieldOf("chance").forGetter(config -> config.chance), (App)Codec.INT.fieldOf("min_y").forGetter(config -> config.minY), (App)Codec.INT.fieldOf("max_y").forGetter(config -> config.maxY)).apply((Applicative)instance, OreConfig::new));
        public final String ore;
        public final double chance;
        public final int minY;
        public final int maxY;

        public OreConfig(String ore, double chance, int minY, int maxY) {
            this.ore = ore;
            this.chance = chance;
            this.minY = minY;
            this.maxY = maxY;
        }
    }
}

