/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.world.dimension;

import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.world.dimension.DistortionWorld;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class DistortionTeleporter {
    public static boolean teleportToDistortionWorld(ServerPlayer player) {
        ServerLevel serverWorld = player.getServer().getLevel(DistortionWorld.DISTORTION_WORLD_KEY);
        if (serverWorld == null) {
            LegendaryMonuments.LOGGER.error("Failed to find Distortion World dimension");
            return false;
        }
        double x = 0.5;
        double y = 300.0;
        double z = 0.5;
        player.teleportTo(serverWorld, x, y, z, player.getYRot(), player.getXRot());
        player.displayClientMessage((Component)Component.translatable((String)"message.legendarymonuments.enter_distortion"), true);
        return true;
    }

    public static boolean teleportFromDistortionWorld(ServerPlayer player) {
        ServerLevel overworld = player.getServer().overworld();
        BlockPos spawnPos = player.getRespawnPosition();
        if (spawnPos == null) {
            spawnPos = overworld.getSharedSpawnPos();
        }
        double x = (double)spawnPos.getX() + 0.5;
        double y = spawnPos.getY();
        double z = (double)spawnPos.getZ() + 0.5;
        player.teleportTo(overworld, x, y, z, player.getYRot(), player.getXRot());
        player.displayClientMessage((Component)Component.translatable((String)"message.legendarymonuments.exit_distortion"), true);
        return true;
    }

    public static void handleVoidFall(ServerPlayer player) {
        if (player.level().dimension() == DistortionWorld.DISTORTION_WORLD_KEY && player.getY() < -20.0) {
            ServerLevel currentWorld = (ServerLevel)player.level();
            player.teleportTo(currentWorld, player.getX(), 300.0, player.getZ(), player.getYRot(), player.getXRot());
            player.setDeltaMovement(0.0, -2.0, 0.0);
            player.hurtMarked = true;
            player.connection.resetPosition();
            player.displayClientMessage((Component)Component.translatable((String)"message.legendarymonuments.distortion_loop"), true);
        }
    }
}

