/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.world.dimension;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4fc;

@Environment(value=EnvType.CLIENT)
public class DistortionWorldSkyRenderer {
    private static final ResourceLocation DISTORTION_SKY_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"textures/environment/distortion_sky.png");

    public static void renderSky(PoseStack matrices, float tickDelta, Camera camera) {
        float fogRed = 0.007843138f;
        float fogGreen = 0.11764706f;
        float fogBlue = 0.29803923f;
        RenderSystem.clearColor((float)fogRed, (float)fogGreen, (float)fogBlue, (float)1.0f);
        RenderSystem.clear((int)16384, (boolean)false);
        RenderSystem.setShaderFogStart((float)0.5f);
        RenderSystem.setShaderFogEnd((float)3.0f);
        RenderSystem.setShaderFogColor((float)fogRed, (float)fogGreen, (float)fogBlue);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableCull();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)DISTORTION_SKY_TEXTURE);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.getModelViewStack().pushMatrix();
        RenderSystem.getModelViewStack().mul((Matrix4fc)matrices.last().pose());
        RenderSystem.applyModelViewMatrix();
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        float radius = 100.0f;
        int segments = 32;
        int rings = 16;
        for (int ring = 0; ring < rings; ++ring) {
            float phi1 = (float)(-1.5707963267948966 + Math.PI * (double)ring / (double)rings);
            float phi2 = (float)(-1.5707963267948966 + Math.PI * (double)(ring + 1) / (double)rings);
            for (int seg = 0; seg < segments; ++seg) {
                float theta1 = (float)(Math.PI * 2 * (double)seg / (double)segments);
                float theta2 = (float)(Math.PI * 2 * (double)(seg + 1) / (double)segments);
                float x1 = (float)((double)radius * Math.cos(phi1) * Math.cos(theta1));
                float y1 = (float)((double)radius * Math.sin(phi1));
                float z1 = (float)((double)radius * Math.cos(phi1) * Math.sin(theta1));
                float x2 = (float)((double)radius * Math.cos(phi1) * Math.cos(theta2));
                float y2 = (float)((double)radius * Math.sin(phi1));
                float z2 = (float)((double)radius * Math.cos(phi1) * Math.sin(theta2));
                float x3 = (float)((double)radius * Math.cos(phi2) * Math.cos(theta2));
                float y3 = (float)((double)radius * Math.sin(phi2));
                float z3 = (float)((double)radius * Math.cos(phi2) * Math.sin(theta2));
                float x4 = (float)((double)radius * Math.cos(phi2) * Math.cos(theta1));
                float y4 = (float)((double)radius * Math.sin(phi2));
                float z4 = (float)((double)radius * Math.cos(phi2) * Math.sin(theta1));
                float u1 = (float)seg / (float)segments;
                float u2 = (float)(seg + 1) / (float)segments;
                float v1 = (float)ring / (float)rings;
                float v2 = (float)(ring + 1) / (float)rings;
                buffer.addVertex(x1, y1, z1).setUv(u1, v1);
                buffer.addVertex(x4, y4, z4).setUv(u1, v2);
                buffer.addVertex(x3, y3, z3).setUv(u2, v2);
                buffer.addVertex(x2, y2, z2).setUv(u2, v1);
            }
        }
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.getModelViewStack().popMatrix();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.enableCull();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
    }
}

