/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.world.dimension;

import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.world.dimension.HallOfOriginWorld;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class HallOfOriginTeleporter {
    private static final BlockPos SPAWN_POS = new BlockPos(13, 6, 74);
    private static final BlockPos STRUCTURE_POS = new BlockPos(1, 5, 1);

    public static boolean teleportToHallOfOrigin(ServerPlayer player) {
        ServerLevel serverWorld = player.getServer().getLevel(HallOfOriginWorld.HALL_OF_ORIGIN_WORLD_KEY);
        if (serverWorld == null) {
            LegendaryMonuments.LOGGER.error("Failed to find Hall of Origin dimension");
            return false;
        }
        player.teleportTo(serverWorld, (double)SPAWN_POS.getX() + 0.5, (double)SPAWN_POS.getY(), (double)SPAWN_POS.getZ() + 0.5, player.getYRot(), player.getXRot());
        HallOfOriginTeleporter.ensureStructurePlaced(serverWorld);
        player.displayClientMessage((Component)Component.translatable((String)"message.legendarymonuments.enter_hall_of_origin"), true);
        return true;
    }

    public static boolean teleportFromHallOfOrigin(ServerPlayer player) {
        ServerLevel overworld = player.getServer().overworld();
        BlockPos spawnPos = player.getRespawnPosition();
        if (spawnPos == null) {
            spawnPos = overworld.getSharedSpawnPos();
        }
        double x = (double)spawnPos.getX() + 0.5;
        double y = Math.max(1, spawnPos.getY());
        double z = (double)spawnPos.getZ() + 0.5;
        player.teleportTo(overworld, x, y, z, player.getYRot(), player.getXRot());
        player.displayClientMessage((Component)Component.translatable((String)"message.legendarymonuments.exit_hall_of_origin"), true);
        return true;
    }

    public static void handleVoidFall(ServerPlayer player) {
        if (player.level().dimension() == HallOfOriginWorld.HALL_OF_ORIGIN_WORLD_KEY && player.getY() < 0.0) {
            ServerLevel currentWorld = (ServerLevel)player.level();
            player.teleportTo(currentWorld, (double)SPAWN_POS.getX() + 0.5, (double)SPAWN_POS.getY(), (double)SPAWN_POS.getZ() + 0.5, player.getYRot(), player.getXRot());
            player.setDeltaMovement(0.0, 0.0, 0.0);
            player.hurtMarked = true;
            player.displayClientMessage((Component)Component.translatable((String)"message.legendarymonuments.hall_origin_void_return"), true);
        }
    }

    private static void ensureStructurePlaced(ServerLevel world) {
        int cx = STRUCTURE_POS.getX() >> 4;
        int cz = STRUCTURE_POS.getZ() >> 4;
        world.getChunk(cx, cz);
        try {
            world.setChunkForced(cx, cz, true);
        }
        catch (Throwable t) {
            LegendaryMonuments.LOGGER.debug("setChunkForced not available or failed: {}", (Object)t.toString());
        }
        if (world.isEmptyBlock(STRUCTURE_POS)) {
            HallOfOriginTeleporter.placeStructureTemplate(world, "hall_of_origin", STRUCTURE_POS);
            LegendaryMonuments.LOGGER.info("Attempted Hall of Origin structure placement at {}", (Object)STRUCTURE_POS);
        }
    }

    private static void placeStructureTemplate(ServerLevel world, String templateName, BlockPos pos) {
        ResourceLocation templateId = ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)templateName);
        StructureTemplateManager structureManager = world.getServer().getStructureManager();
        structureManager.get(templateId).ifPresentOrElse(template -> {
            StructurePlaceSettings placementSettings = new StructurePlaceSettings().setMirror(Mirror.NONE).setRotation(Rotation.NONE).setIgnoreEntities(false);
            template.placeInWorld((ServerLevelAccessor)world, pos, pos, placementSettings, world.getRandom(), 2);
            LegendaryMonuments.LOGGER.info("Successfully placed structure template {} at {}", (Object)templateId, (Object)pos);
        }, () -> LegendaryMonuments.LOGGER.error("Structure template {} not found", (Object)templateId));
    }
}

