/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.world.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import github.jorgaomc.ModBlocks;
import github.jorgaomc.world.feature.DistortionTreeFeature;
import github.jorgaomc.world.feature.MiniMountainFeature;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class DistortionIslandDecorationFeature
extends Feature<Config> {
    private static final int SEARCH_RADIUS = 40;
    private static final int MIN_ISLAND_SIZE = 25;

    public DistortionIslandDecorationFeature(Codec<Config> configCodec) {
        super(configCodec);
    }

    public static void register() {
        Registry.register((Registry)BuiltInRegistries.FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"distortion_island_decoration"), (Object)((Object)new DistortionIslandDecorationFeature(Config.CODEC)));
    }

    public boolean place(FeaturePlaceContext<Config> context) {
        WorldGenLevel world = context.level();
        RandomSource random = context.random();
        BlockPos origin = context.origin();
        Config config = (Config)context.config();
        List<BlockPos> surfacePositions = this.findIslandSurfaces(world, origin);
        if (surfacePositions.size() < 25) {
            return false;
        }
        BlockPos center = this.calculateIslandCenter(surfacePositions);
        int estimatedRadius = this.estimateIslandRadius(surfacePositions, center);
        boolean isMegaIsland = estimatedRadius > 60;
        List<BlockPos> lakePositions = this.findLakeAreas(world, center, estimatedRadius);
        int lakeRadius = lakePositions.isEmpty() ? 0 : this.estimateLakeRadius(lakePositions, center);
        this.placeIslandDecorations(world, random, center, estimatedRadius, surfacePositions, lakeRadius, isMegaIsland, config);
        List<BlockPos> edgePositions = this.findEdgePositions(surfacePositions, center, estimatedRadius);
        this.generateHangingColumns(world, random, edgePositions, center, estimatedRadius, isMegaIsland);
        if (isMegaIsland && estimatedRadius > 80 && (double)random.nextFloat() < config.waterFallChance * 1.5 || !isMegaIsland && estimatedRadius > 25 && (double)random.nextFloat() < config.waterFallChance) {
            this.generateWaterfalls(world, random, center, estimatedRadius, isMegaIsland);
        }
        return true;
    }

    private List<BlockPos> findIslandSurfaces(WorldGenLevel world, BlockPos origin) {
        ArrayList<BlockPos> surfaces = new ArrayList<BlockPos>();
        HashSet<Long> seenXZ = new HashSet<Long>();
        int approxY = this.estimateSurfaceYNearOrigin(world, origin);
        int yMin = approxY - 40;
        int yMax = approxY + 30;
        yMin = Math.max(yMin, -64);
        yMax = Math.min(yMax, 384);
        for (int dx = -40; dx <= 40; ++dx) {
            for (int dz = -40; dz <= 40; ++dz) {
                BlockPos found;
                int z;
                int x = origin.getX() + dx;
                long key = (long)x << 32 ^ (long)(z = origin.getZ() + dz) & 0xFFFFFFFFL;
                if (seenXZ.contains(key) || (found = this.findSurfaceOnColumn(world, x, z, yMin, yMax)) == null) continue;
                surfaces.add(found);
                seenXZ.add(key);
            }
        }
        return surfaces;
    }

    private BlockPos findSurfaceOnColumn(WorldGenLevel world, int x, int z, int yMin, int yMax) {
        for (int y = yMax; y >= yMin; --y) {
            BlockPos pos = new BlockPos(x, y, z);
            if (!this.isIslandSurfaceBlockSafe(world, pos)) continue;
            return pos;
        }
        return null;
    }

    private int estimateSurfaceYNearOrigin(WorldGenLevel world, BlockPos origin) {
        int startY = origin.getY();
        int yTop = Math.min(startY + 40, 384);
        int yBottom = Math.max(startY - 60, -64);
        for (int y = yTop; y >= yBottom; --y) {
            BlockPos pos = new BlockPos(origin.getX(), y, origin.getZ());
            if (!this.isIslandSurfaceBlockSafe(world, pos)) continue;
            return y;
        }
        return startY;
    }

    private boolean isIslandSurfaceBlockSafe(WorldGenLevel world, BlockPos pos) {
        try {
            BlockState currentBlock = world.getBlockState(pos);
            BlockState aboveBlock = world.getBlockState(pos.above());
            boolean isTopBlock = currentBlock.is(ModBlocks.DISTORTION_COBBLESTONE) || currentBlock.is(ModBlocks.DISTORTION_STONE);
            return isTopBlock && (aboveBlock.isAir() || aboveBlock.is(Blocks.WATER));
        }
        catch (Exception e) {
            return false;
        }
    }

    private BlockPos calculateIslandCenter(List<BlockPos> surfacePositions) {
        if (surfacePositions.isEmpty()) {
            return BlockPos.ZERO;
        }
        double avgX = surfacePositions.stream().mapToInt(Vec3i::getX).average().orElse(0.0);
        double avgY = surfacePositions.stream().mapToInt(Vec3i::getY).average().orElse(0.0);
        double avgZ = surfacePositions.stream().mapToInt(Vec3i::getZ).average().orElse(0.0);
        return new BlockPos((int)avgX, (int)avgY, (int)avgZ);
    }

    private int estimateIslandRadius(List<BlockPos> surfacePositions, BlockPos center) {
        return surfacePositions.stream().mapToInt(pos -> (int)Math.sqrt(center.distSqr((Vec3i)pos))).max().orElse(0);
    }

    private List<BlockPos> findLakeAreas(WorldGenLevel world, BlockPos center, int radius) {
        ArrayList<BlockPos> lakePositions = new ArrayList<BlockPos>();
        int safeRadius = Math.min(radius, 45);
        for (int x = -safeRadius; x <= safeRadius; ++x) {
            for (int z = -safeRadius; z <= safeRadius; ++z) {
                for (int y = -5; y <= 5; ++y) {
                    BlockPos pos = center.offset(x, y, z);
                    try {
                        if (!world.getBlockState(pos).is(Blocks.WATER)) continue;
                        lakePositions.add(pos);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        return lakePositions;
    }

    private int estimateLakeRadius(List<BlockPos> lakePositions, BlockPos center) {
        return lakePositions.stream().mapToInt(pos -> (int)Math.sqrt(center.distSqr((Vec3i)pos))).max().orElse(0);
    }

    private List<BlockPos> findEdgePositions(List<BlockPos> surfacePositions, BlockPos center, int radius) {
        return surfacePositions.stream().filter(pos -> {
            double distance = Math.sqrt(center.distSqr((Vec3i)pos));
            double normalizedDistance = distance / (double)Math.max(radius, 1);
            return normalizedDistance > 0.7;
        }).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    private void placeIslandDecorations(WorldGenLevel world, RandomSource random, BlockPos center, int radius, List<BlockPos> surfacePositions, int lakeRadius, boolean isMegaIsland, Config config) {
        if (surfacePositions.isEmpty()) {
            return;
        }
        int segments = Math.max(1, radius / 50);
        int treesPerSegment = 2 + random.nextInt(4);
        int mountainsPerSegment = radius >= 20 ? 1 : 0;
        int treeCount = treesPerSegment * segments;
        int mountainCount = mountainsPerSegment * segments;
        ArrayList<BlockPos> placedFeatures = new ArrayList<BlockPos>();
        this.placeFeatures(world, random, surfacePositions, center, lakeRadius, placedFeatures, treeCount, isMegaIsland ? 196 : 256, this::generateDistortionTree);
        this.placeFeatures(world, random, surfacePositions, center, lakeRadius, placedFeatures, mountainCount, isMegaIsland ? 400 : 484, this::generateMiniMountain);
    }

    private void placeFeatures(WorldGenLevel world, RandomSource random, List<BlockPos> surfacePositions, BlockPos center, int lakeRadius, List<BlockPos> placedFeatures, int count, int minSpacingSquared, FeaturePlacer placer) {
        int placed = 0;
        int maxAttempts = Math.max(8, count * (surfacePositions.size() > 1000 ? 14 : 10));
        ArrayList<BlockPos> shuffledPositions = new ArrayList<BlockPos>(surfacePositions);
        for (int attempt = 0; attempt < maxAttempts && placed < count && !shuffledPositions.isEmpty(); ++attempt) {
            int randomIndex = random.nextInt(shuffledPositions.size());
            BlockPos pos = (BlockPos)shuffledPositions.get(randomIndex);
            shuffledPositions.remove(randomIndex);
            double distFromCenter = Math.sqrt(pos.distSqr((Vec3i)center));
            if (distFromCenter < (double)(lakeRadius + (lakeRadius > 0 ? 6 : 4)) || !this.hasMinimumSpacing(pos, placedFeatures, minSpacingSquared)) continue;
            placer.place(world, random, pos.above());
            placedFeatures.add(pos);
            ++placed;
        }
    }

    private boolean hasMinimumSpacing(BlockPos pos, List<BlockPos> existing, int minSpacingSquared) {
        int x = pos.getX();
        int z = pos.getZ();
        for (BlockPos other : existing) {
            int dz;
            int dx = other.getX() - x;
            int dist2 = dx * dx + (dz = other.getZ() - z) * dz;
            if (dist2 >= minSpacingSquared) continue;
            return false;
        }
        return true;
    }

    private void generateDistortionTree(WorldGenLevel world, RandomSource random, BlockPos pos) {
        try {
            BlockPos groundedPos = this.findGroundLevel(world, pos);
            if (groundedPos == null) {
                return;
            }
            if (!this.hasAdequateGroundSupport(world, groundedPos)) {
                return;
            }
            FeaturePlaceContext context = new FeaturePlaceContext(null, world, null, random, groundedPos, (FeatureConfiguration)NoneFeatureConfiguration.INSTANCE);
            DistortionTreeFeature.DISTORTION_TREE_FEATURE.place(context);
        }
        catch (Exception e) {
            this.generateSimpleDistortionTree(world, random, pos);
        }
    }

    private void generateMiniMountain(WorldGenLevel world, RandomSource random, BlockPos pos) {
        try {
            BlockPos groundedPos = this.findGroundLevel(world, pos);
            if (groundedPos == null) {
                return;
            }
            if (!this.hasAdequateGroundSupport(world, groundedPos)) {
                return;
            }
            FeaturePlaceContext context = new FeaturePlaceContext(null, world, null, random, groundedPos, (FeatureConfiguration)NoneFeatureConfiguration.INSTANCE);
            MiniMountainFeature.MINI_MOUNTAIN_FEATURE.place(context);
        }
        catch (Exception e) {
            this.generateSimpleRockFormation(world, random, pos);
        }
    }

    private void generateHangingColumns(WorldGenLevel world, RandomSource random, List<BlockPos> edgePositions, BlockPos center, int radius, boolean isMegaIsland) {
        if (edgePositions.isEmpty()) {
            return;
        }
        int columnCount = isMegaIsland ? Math.min(20, edgePositions.size() / 20) : Math.min(8, edgePositions.size() / 15);
        block2: for (int i = 0; i < columnCount; ++i) {
            if ((double)random.nextFloat() > (isMegaIsland ? 0.4 : 0.3)) continue;
            BlockPos edgePos = edgePositions.get(random.nextInt(edgePositions.size()));
            int maxThickness = isMegaIsland ? 25 : 18;
            int columnHeight = random.nextIntBetweenInclusive(isMegaIsland ? 15 : 8, maxThickness + (isMegaIsland ? 20 : 10));
            int columnWidth = random.nextIntBetweenInclusive(1, isMegaIsland ? 4 : 3);
            for (int y = -1; y >= -columnHeight; --y) {
                int currentWidth = Math.max(1, columnWidth - -y / (isMegaIsland ? 10 : 8));
                for (int dx = -currentWidth; dx <= currentWidth; ++dx) {
                    for (int dz = -currentWidth; dz <= currentWidth; ++dz) {
                        if (dx * dx + dz * dz > currentWidth * currentWidth) continue;
                        BlockPos columnPos = edgePos.offset(dx, y, dz);
                        BlockState columnBlock = (double)random.nextFloat() < 0.3 ? ModBlocks.DISTORTION_COBBLESTONE.defaultBlockState() : ModBlocks.DISTORTION_STONE.defaultBlockState();
                        try {
                            world.setBlock(columnPos, columnBlock, 3);
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                if ((double)random.nextFloat() < (isMegaIsland ? 0.03 : 0.05)) continue block2;
            }
        }
    }

    private void generateWaterfalls(WorldGenLevel world, RandomSource random, BlockPos center, int radius, boolean isMegaIsland) {
        int waterfallCount = isMegaIsland ? random.nextIntBetweenInclusive(1, 3) : 1;
        int maxThickness = isMegaIsland ? 25 : 18;
        block2: for (int i = 0; i < waterfallCount; ++i) {
            double angle = random.nextDouble() * 2.0 * Math.PI;
            double radiusMultiplier = isMegaIsland ? 0.7 + random.nextDouble() * 0.2 : 0.8;
            int waterX = (int)(Math.cos(angle) * (double)Math.min(radius, 45) * radiusMultiplier);
            int waterZ = (int)(Math.sin(angle) * (double)Math.min(radius, 45) * radiusMultiplier);
            int waterLength = random.nextIntBetweenInclusive(isMegaIsland ? 40 : 25, maxThickness + (isMegaIsland ? 50 : 30));
            BlockPos waterStart = center.offset(waterX, isMegaIsland ? 3 : 2, waterZ);
            for (int y = 0; y > -waterLength; --y) {
                int width = y > (isMegaIsland ? -8 : -5) ? (isMegaIsland ? 2 : 1) : ((double)random.nextFloat() < (isMegaIsland ? 0.8 : 0.7) ? 1 : 0);
                for (int dx = -width; dx <= width; ++dx) {
                    for (int dz = -width; dz <= width; ++dz) {
                        if (dx * dx + dz * dz > width * width) continue;
                        BlockPos waterPos = waterStart.offset(dx, y, dz);
                        try {
                            world.setBlock(waterPos, Blocks.WATER.defaultBlockState(), 3);
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                if (y >= (isMegaIsland ? -20 : -10)) continue;
                if ((double)random.nextFloat() < (isMegaIsland ? 0.08 : 0.1)) continue block2;
            }
        }
    }

    private BlockPos findGroundLevel(WorldGenLevel world, BlockPos startPos) {
        BlockPos checkPos;
        int y;
        for (y = 0; y >= -15; --y) {
            checkPos = startPos.offset(0, y, 0);
            try {
                if (!world.getBlockState(checkPos).isRedstoneConductor((BlockGetter)world, checkPos)) continue;
                return checkPos.above();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        for (y = 1; y <= 8; ++y) {
            checkPos = startPos.offset(0, y, 0);
            BlockPos belowPos = checkPos.below();
            try {
                if (!world.getBlockState(belowPos).isRedstoneConductor((BlockGetter)world, belowPos) || world.getBlockState(checkPos).isRedstoneConductor((BlockGetter)world, checkPos)) continue;
                return checkPos;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean hasAdequateGroundSupport(WorldGenLevel world, BlockPos basePos) {
        int solidBlocks = 0;
        int totalBlocks = 0;
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                BlockPos checkPos = basePos.offset(dx, -1, dz);
                ++totalBlocks;
                try {
                    if (!world.getBlockState(checkPos).isRedstoneConductor((BlockGetter)world, checkPos)) continue;
                    ++solidBlocks;
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return totalBlocks > 0 && (double)solidBlocks / (double)totalBlocks >= 0.6;
    }

    private void generateSimpleDistortionTree(WorldGenLevel world, RandomSource random, BlockPos pos) {
        BlockPos groundedPos = this.findGroundLevel(world, pos);
        if (groundedPos == null) {
            return;
        }
        int height = random.nextIntBetweenInclusive(5, 8);
        int crownSize = random.nextIntBetweenInclusive(2, 3);
        BlockPos currentPos = groundedPos;
        for (int y = 0; y < height; ++y) {
            try {
                world.setBlock(currentPos, ModBlocks.DISTORTION_LOG.defaultBlockState(), 3);
                if (y > 2 && (double)random.nextFloat() < 0.3) {
                    Direction[] horizontalDirs = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
                    Direction randomDir = horizontalDirs[random.nextInt(horizontalDirs.length)];
                    currentPos = currentPos.relative(randomDir, (double)random.nextFloat() < 0.5 ? 1 : 0);
                }
                currentPos = currentPos.above();
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        BlockPos crownCenter = currentPos;
        for (int dx = -crownSize; dx <= crownSize; ++dx) {
            for (int dy = -1; dy <= crownSize - 1; ++dy) {
                for (int dz = -crownSize; dz <= crownSize; ++dz) {
                    double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
                    if (!(distance <= (double)crownSize) || !((double)random.nextFloat() < 0.7)) continue;
                    try {
                        world.setBlock(crownCenter.offset(dx, dy, dz), ModBlocks.DISTORTION_LEAVES.defaultBlockState(), 3);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void generateSimpleRockFormation(WorldGenLevel world, RandomSource random, BlockPos pos) {
        BlockPos groundedPos = this.findGroundLevel(world, pos);
        if (groundedPos == null) {
            return;
        }
        int height = random.nextIntBetweenInclusive(3, 6);
        for (int y = 0; y < height; ++y) {
            int size = Math.max(1, height - y);
            for (int dx = -size; dx <= size; ++dx) {
                for (int dz = -size; dz <= size; ++dz) {
                    if (dx * dx + dz * dz > size * size || !((double)random.nextFloat() < 0.8)) continue;
                    try {
                        world.setBlock(groundedPos.offset(dx, y, dz), ModBlocks.DISTORTION_COBBLESTONE.defaultBlockState(), 3);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static class Config
    implements FeatureConfiguration {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("water_fall_chance").forGetter(config -> config.waterFallChance)).apply((Applicative)instance, Config::new));
        public final double waterFallChance;

        public Config(double waterFallChance) {
            this.waterFallChance = waterFallChance;
        }
    }

    @FunctionalInterface
    private static interface FeaturePlacer {
        public void place(WorldGenLevel var1, RandomSource var2, BlockPos var3);
    }
}

