/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.world.feature;

import github.jorgaomc.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class DistortionTreeFeature
extends Feature<NoneFeatureConfiguration> {
    public static final Feature<NoneFeatureConfiguration> DISTORTION_TREE_FEATURE = new DistortionTreeFeature();
    public static final ResourceKey<ConfiguredFeature<?, ?>> DISTORTION_TREE_CONFIGURED = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"distortion_tree"));

    public DistortionTreeFeature() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public static void register() {
        Registry.register((Registry)BuiltInRegistries.FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"distortion_tree"), DISTORTION_TREE_FEATURE);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.level();
        BlockPos origin = context.origin();
        RandomSource random = context.random();
        BlockPos grounded = this.findGround((LevelAccessor)world, origin, 48);
        if (grounded == null) {
            return false;
        }
        BlockState below = world.getBlockState(grounded.below());
        if (!below.is(ModBlocks.DISTORTION_COBBLESTONE) && !below.is(ModBlocks.DISTORTION_STONE)) {
            return false;
        }
        BlockState at = world.getBlockState(grounded);
        if (!at.isAir() && !at.is(Blocks.WATER)) {
            return false;
        }
        int variant = random.nextInt(10);
        switch (variant) {
            case 0: {
                return this.generateTree1((LevelAccessor)world, grounded);
            }
            case 1: {
                return this.generateTree2((LevelAccessor)world, grounded);
            }
            case 2: {
                return this.generateTree3((LevelAccessor)world, grounded);
            }
            case 3: {
                return this.generateTree4((LevelAccessor)world, grounded);
            }
            case 4: {
                return this.generateTree5((LevelAccessor)world, grounded);
            }
            case 5: {
                return this.generateTree6((LevelAccessor)world, grounded);
            }
            case 6: {
                return this.generateTree7((LevelAccessor)world, grounded);
            }
            case 7: {
                return this.generateTree8((LevelAccessor)world, grounded);
            }
            case 8: {
                return this.generateTree9((LevelAccessor)world, grounded);
            }
            case 9: {
                return this.generateTree10((LevelAccessor)world, grounded);
            }
        }
        return this.generateTree1((LevelAccessor)world, grounded);
    }

    private boolean generateTree1(LevelAccessor world, BlockPos grounded) {
        for (int y = 0; y < 9; ++y) {
            world.setBlock(grounded.above(y), ModBlocks.DISTORTION_LOG.defaultBlockState(), 3);
        }
        BlockPos top = grounded.above(8);
        world.setBlock(top.north(), ModBlocks.DISTORTION_LEAVES.defaultBlockState(), 3);
        world.setBlock(top.south(), ModBlocks.DISTORTION_LEAVES.defaultBlockState(), 3);
        world.setBlock(top.east(), ModBlocks.DISTORTION_LEAVES.defaultBlockState(), 3);
        world.setBlock(top.west(), ModBlocks.DISTORTION_LEAVES.defaultBlockState(), 3);
        BlockPos layer2 = grounded.above(9);
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                world.setBlock(layer2.offset(dx, 0, dz), ModBlocks.DISTORTION_LEAVES.defaultBlockState(), 3);
            }
        }
        BlockPos layer3 = grounded.above(10);
        int[][] pattern = new int[][]{{0, 1, 0, 1, 0}, {1, 1, 0, 1, 1}, {0, 0, 1, 0, 0}, {1, 1, 0, 1, 1}, {0, 1, 0, 1, 0}};
        this.placeLayer(world, layer3, pattern);
        return true;
    }

    private boolean generateTree2(LevelAccessor world, BlockPos grounded) {
        for (int y = 0; y < 8; ++y) {
            world.setBlock(grounded.above(y), ModBlocks.DISTORTION_LOG.defaultBlockState(), 3);
        }
        int[][] layer7 = new int[][]{{0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 1, 2, 0, 0}, {0, 0, 1, 0, 0}, {0, 0, 0, 0, 0}};
        this.placeLayer(world, grounded.above(6), layer7);
        int[][] layer8 = new int[][]{{0, 0, 0, 0, 0}, {0, 1, 1, 1, 0}, {0, 1, 2, 1, 1}, {0, 1, 1, 1, 0}, {0, 0, 0, 0, 0}};
        this.placeLayer(world, grounded.above(7), layer8);
        int[][] layer9 = new int[][]{{0, 0, 1, 0, 0}, {1, 0, 1, 0, 0}, {0, 1, 1, 1, 0}, {1, 0, 1, 0, 0}, {0, 0, 0, 1, 0}};
        this.placeLayer(world, grounded.above(8), layer9);
        int[][] layer10 = new int[][]{{0, 0, 0, 1, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 1, 0, 0}, {0, 0, 0, 0, 0}};
        this.placeLayer(world, grounded.above(9), layer10);
        return true;
    }

    private boolean generateTree3(LevelAccessor world, BlockPos grounded) {
        for (int y = 0; y < 7; ++y) {
            world.setBlock(grounded.above(y), ModBlocks.DISTORTION_LOG.defaultBlockState(), 3);
        }
        int[][] layer7 = new int[][]{{0, 0, 0, 0, 0}, {0, 0, 1, 1, 0}, {0, 1, 2, 1, 0}, {0, 0, 1, 1, 0}, {0, 0, 0, 0, 0}};
        this.placeLayer(world, grounded.above(6), layer7);
        int[][] layer8 = new int[][]{{0, 0, 0, 1, 0}, {0, 1, 0, 0, 0}, {0, 1, 1, 1, 0}, {0, 1, 0, 1, 0}, {0, 0, 1, 0, 0}};
        this.placeLayer(world, grounded.above(7), layer8);
        int[][] layer9 = new int[][]{{0, 0, 0, 0, 0}, {1, 0, 0, 0, 0}, {0, 1, 0, 1, 0}, {0, 0, 0, 0, 1}, {0, 1, 0, 0, 0}};
        this.placeLayer(world, grounded.above(8), layer9);
        return true;
    }

    private boolean generateTree4(LevelAccessor world, BlockPos grounded) {
        for (int y = 0; y < 7; ++y) {
            world.setBlock(grounded.above(y), ModBlocks.DISTORTION_LOG.defaultBlockState(), 3);
        }
        int[][] layer7 = new int[][]{{0, 0, 0, 0, 0}, {0, 0, 1, 0, 0}, {0, 1, 2, 1, 0}, {0, 0, 1, 0, 0}, {0, 0, 0, 0, 0}};
        this.placeLayer(world, grounded.above(6), layer7);
        int[][] layer8 = new int[][]{{0, 0, 0, 0, 0}, {0, 1, 1, 1, 0}, {0, 1, 1, 1, 0}, {0, 1, 1, 1, 0}, {0, 0, 0, 0, 0}};
        this.placeLayer(world, grounded.above(7), layer8);
        int[][] layer9 = new int[][]{{0, 1, 0, 1, 0}, {1, 1, 0, 0, 1}, {0, 0, 1, 0, 0}, {1, 1, 0, 1, 1}, {0, 1, 0, 1, 0}};
        this.placeLayer(world, grounded.above(8), layer9);
        int[][] layer10 = new int[][]{{0, 0, 0, 0, 0}, {1, 0, 0, 0, 1}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 1, 0}};
        this.placeLayer(world, grounded.above(9), layer10);
        return true;
    }

    private boolean generateTree5(LevelAccessor world, BlockPos grounded) {
        for (int y = 0; y < 11; ++y) {
            world.setBlock(grounded.above(y), ModBlocks.DISTORTION_LOG.defaultBlockState(), 3);
        }
        int[][] layer10 = new int[][]{{0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 1, 2, 0, 0}, {0, 0, 1, 0, 0}, {0, 0, 0, 0, 0}};
        this.placeLayer(world, grounded.above(9), layer10);
        int[][] layer11 = new int[][]{{0, 0, 0, 0, 0}, {0, 1, 1, 1, 0}, {0, 1, 1, 1, 1}, {0, 1, 1, 1, 0}, {0, 0, 0, 0, 0}};
        this.placeLayer(world, grounded.above(10), layer11);
        int[][] layer12 = new int[][]{{0, 0, 0, 1, 0}, {1, 0, 1, 0, 0}, {0, 1, 1, 1, 0}, {1, 0, 1, 0, 0}, {0, 0, 0, 1, 0}};
        this.placeLayer(world, grounded.above(11), layer12);
        return true;
    }

    private boolean generateTree6(LevelAccessor world, BlockPos grounded) {
        for (int y = 0; y < 10; ++y) {
            world.setBlock(grounded.above(y), ModBlocks.DISTORTION_LOG.defaultBlockState(), 3);
        }
        int[][] layer10 = new int[][]{{0, 0, 0, 0, 0}, {0, 0, 1, 1, 0}, {0, 1, 2, 1, 0}, {0, 0, 1, 1, 0}, {0, 0, 0, 0, 0}};
        this.placeLayer(world, grounded.above(9), layer10);
        int[][] layer11 = new int[][]{{0, 0, 0, 1, 0}, {0, 1, 0, 0, 0}, {0, 1, 1, 1, 1}, {0, 1, 0, 1, 0}, {0, 0, 1, 0, 0}};
        this.placeLayer(world, grounded.above(10), layer11);
        int[][] layer12 = new int[][]{{0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {1, 0, 0, 0, 0}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 0}};
        this.placeLayer(world, grounded.above(11), layer12);
        return true;
    }

    private boolean generateTree7(LevelAccessor world, BlockPos grounded) {
        for (int y = 0; y < 9; ++y) {
            world.setBlock(grounded.above(y), ModBlocks.DISTORTION_LOG.defaultBlockState(), 3);
        }
        int[][] layer9 = new int[][]{{0, 0, 0, 0, 0}, {0, 0, 1, 0, 0}, {0, 1, 2, 1, 0}, {0, 0, 1, 0, 0}, {0, 0, 0, 0, 0}};
        this.placeLayer(world, grounded.above(8), layer9);
        int[][] layer10 = new int[][]{{0, 0, 0, 0, 0}, {0, 1, 1, 1, 0}, {0, 1, 1, 1, 0}, {0, 1, 1, 1, 0}, {0, 0, 0, 0, 0}};
        this.placeLayer(world, grounded.above(9), layer10);
        int[][] layer11 = new int[][]{{0, 1, 0, 1, 0}, {1, 1, 0, 0, 1}, {0, 0, 1, 1, 0}, {1, 1, 0, 1, 1}, {0, 1, 0, 1, 0}};
        this.placeLayer(world, grounded.above(10), layer11);
        int[][] layer12 = new int[][]{{0, 0, 0, 0, 0}, {1, 0, 0, 0, 0}, {0, 0, 0, 1, 0}, {0, 0, 0, 0, 0}, {0, 1, 0, 0, 0}};
        this.placeLayer(world, grounded.above(11), layer12);
        return true;
    }

    private boolean generateTree8(LevelAccessor world, BlockPos grounded) {
        for (int y = 0; y < 16; ++y) {
            world.setBlock(grounded.above(y), ModBlocks.DISTORTION_LOG.defaultBlockState(), 3);
        }
        int[][] layer15 = new int[][]{{0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 1, 2, 0, 0}, {0, 0, 1, 0, 0}, {0, 0, 0, 0, 0}};
        this.placeLayer(world, grounded.above(14), layer15);
        int[][] layer16 = new int[][]{{0, 0, 0, 0, 0}, {0, 1, 1, 1, 0}, {0, 1, 1, 1, 1}, {0, 1, 1, 1, 0}, {0, 0, 0, 0, 0}};
        this.placeLayer(world, grounded.above(15), layer16);
        int[][] layer17 = new int[][]{{0, 0, 0, 1, 0}, {1, 0, 1, 0, 0}, {0, 1, 1, 1, 0}, {1, 0, 1, 0, 0}, {0, 0, 0, 1, 0}};
        this.placeLayer(world, grounded.above(16), layer17);
        return true;
    }

    private boolean generateTree9(LevelAccessor world, BlockPos grounded) {
        for (int y = 0; y < 14; ++y) {
            world.setBlock(grounded.above(y), ModBlocks.DISTORTION_LOG.defaultBlockState(), 3);
        }
        int[][] layer14 = new int[][]{{0, 0, 0, 0, 0}, {0, 0, 1, 1, 0}, {0, 1, 0, 1, 0}, {0, 0, 1, 1, 0}, {0, 0, 0, 0, 0}};
        this.placeLayer(world, grounded.above(13), layer14);
        int[][] layer15 = new int[][]{{0, 0, 0, 1, 0}, {0, 1, 0, 1, 0}, {1, 1, 1, 1, 0}, {0, 1, 0, 1, 0}, {0, 0, 1, 0, 0}};
        this.placeLayer(world, grounded.above(14), layer15);
        int[][] layer16 = new int[][]{{0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 1, 0, 0}};
        this.placeLayer(world, grounded.above(15), layer16);
        int[][] layer17 = new int[][]{{0, 0, 0, 0, 0}, {0, 0, 0, 1, 0}, {0, 1, 0, 0, 1}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}};
        this.placeLayer(world, grounded.above(16), layer17);
        return true;
    }

    private boolean generateTree10(LevelAccessor world, BlockPos grounded) {
        for (int y = 0; y < 13; ++y) {
            world.setBlock(grounded.above(y), ModBlocks.DISTORTION_LOG.defaultBlockState(), 3);
        }
        int[][] layer13 = new int[][]{{0, 0, 0, 0, 0}, {0, 0, 1, 0, 0}, {0, 1, 2, 1, 0}, {0, 0, 1, 0, 0}, {0, 0, 0, 0, 0}};
        this.placeLayer(world, grounded.above(12), layer13);
        int[][] layer14 = new int[][]{{0, 0, 0, 0, 0}, {0, 1, 1, 1, 0}, {0, 1, 1, 1, 0}, {0, 1, 1, 1, 0}, {0, 0, 0, 0, 0}};
        this.placeLayer(world, grounded.above(13), layer14);
        int[][] layer15 = new int[][]{{0, 1, 0, 1, 0}, {1, 1, 0, 1, 0}, {0, 0, 1, 0, 0}, {1, 1, 0, 1, 1}, {0, 1, 0, 1, 0}};
        this.placeLayer(world, grounded.above(14), layer15);
        int[][] layer16 = new int[][]{{0, 0, 0, 0, 0}, {1, 0, 0, 0, 1}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 1, 0, 1, 0}};
        this.placeLayer(world, grounded.above(15), layer16);
        return true;
    }

    private void placeLayer(LevelAccessor world, BlockPos base, int[][] pattern) {
        for (int dz = 0; dz < 5; ++dz) {
            for (int dx = 0; dx < 5; ++dx) {
                int value = pattern[dz][dx];
                if (value == 1) {
                    world.setBlock(base.offset(dx - 2, 0, dz - 2), ModBlocks.DISTORTION_LEAVES.defaultBlockState(), 3);
                    continue;
                }
                if (value != 2) continue;
                world.setBlock(base.offset(dx - 2, 0, dz - 2), ModBlocks.DISTORTION_LOG.defaultBlockState(), 3);
            }
        }
    }

    private BlockPos findGround(LevelAccessor world, BlockPos origin, int range) {
        BlockState atState;
        BlockState belowState;
        BlockPos below;
        BlockPos pos;
        int dy;
        for (dy = 0; dy <= range; ++dy) {
            pos = origin.below(dy);
            below = pos.below();
            belowState = world.getBlockState(below);
            atState = world.getBlockState(pos);
            if (!belowState.is(ModBlocks.DISTORTION_COBBLESTONE) && !belowState.is(ModBlocks.DISTORTION_STONE) || !atState.isAir() && !atState.is(Blocks.WATER)) continue;
            return pos;
        }
        for (dy = 1; dy <= range; ++dy) {
            pos = origin.above(dy);
            below = pos.below();
            belowState = world.getBlockState(below);
            atState = world.getBlockState(pos);
            if (!belowState.is(ModBlocks.DISTORTION_COBBLESTONE) && !belowState.is(ModBlocks.DISTORTION_STONE) || !atState.isAir() && !atState.is(Blocks.WATER)) continue;
            return pos;
        }
        return null;
    }
}

