/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.world.feature;

import github.jorgaomc.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class MiniMountainFeature
extends Feature<NoneFeatureConfiguration> {
    public static final Feature<NoneFeatureConfiguration> MINI_MOUNTAIN_FEATURE = new MiniMountainFeature();
    public static final ResourceKey<ConfiguredFeature<?, ?>> MINI_MOUNTAIN_CONFIGURED = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"mini_mountain"));

    public MiniMountainFeature() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public static void register() {
        Registry.register((Registry)BuiltInRegistries.FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"mini_mountain"), MINI_MOUNTAIN_FEATURE);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos origin;
        WorldGenLevel world = context.level();
        BlockPos grounded = this.findGround((LevelAccessor)world, origin = context.origin(), 64);
        if (grounded == null) {
            return false;
        }
        BlockState below = world.getBlockState(grounded.below());
        if (!below.is(ModBlocks.DISTORTION_COBBLESTONE) && !below.is(ModBlocks.DISTORTION_STONE)) {
            return false;
        }
        String[][] layers = new String[][]{{"0000000100", "0001111110", "0111111110", "0111111111", "1011111110", "0111111111", "0011011110", "0010111000", "0001000000"}, {"0000000000", "0000111100", "0011101110", "0101111110", "0011111110", "0111111110", "0001011100", "0000010000", "0000000000"}, {"0000000000", "0000001100", "0001101010", "0001111100", "0011111110", "0011111010", "0001011100", "0000010000", "0000000000"}, {"0000000000", "0000000100", "0001101000", "0001111100", "0011111100", "0011111010", "0001011000", "0000000000", "0000000000"}, {"0000000000", "0000000000", "0001101000", "0001111100", "0011111100", "0001111000", "0001011000", "0000000000", "0000000000"}, {"0000000000", "0000000000", "0001101000", "0001111100", "0001110100", "0001111000", "0000011000", "0000000000", "0000000000"}, {"0000000000", "0000000000", "0000101000", "0001111000", "0001010000", "0000111000", "0000010000", "0000000000", "0000000000"}, {"0000000000", "0000000000", "0000101000", "0001111000", "0001010000", "0000110000", "0000000000", "0000000000", "0000000000"}, {"0000000000", "0000000000", "0000100000", "0000111000", "0000010000", "0000000000", "0000000000", "0000000000", "0000000000"}, {"0000000000", "0000000000", "0000000000", "0000111000", "0000010000", "0000000000", "0000000000", "0000000000", "0000000000"}, {"0000000000", "0000000000", "0000000000", "0000110000", "0000010000", "0000000000", "0000000000", "0000000000", "0000000000"}, {"0000000000", "0000000000", "0000000000", "0000100000", "0000010000", "0000000000", "0000000000", "0000000000", "0000000000"}};
        for (int y = 0; y < layers.length; ++y) {
            String[] layer = layers[y];
            for (int z = 0; z < layer.length; ++z) {
                String row = layer[z];
                for (int x = 0; x < row.length(); ++x) {
                    if (row.charAt(x) != '1') continue;
                    world.setBlock(grounded.offset(x, y, z), Blocks.DRIPSTONE_BLOCK.defaultBlockState(), 3);
                }
            }
        }
        return true;
    }

    private BlockPos findGround(LevelAccessor world, BlockPos origin, int range) {
        BlockState atState;
        BlockState belowState;
        BlockPos below;
        BlockPos pos;
        int dy;
        for (dy = 0; dy <= range; ++dy) {
            pos = origin.below(dy);
            below = pos.below();
            belowState = world.getBlockState(below);
            atState = world.getBlockState(pos);
            if (!belowState.is(ModBlocks.DISTORTION_COBBLESTONE) && !belowState.is(ModBlocks.DISTORTION_STONE) || !atState.isAir() && !atState.is(Blocks.WATER)) continue;
            return pos;
        }
        for (dy = 1; dy <= range; ++dy) {
            pos = origin.above(dy);
            below = pos.below();
            belowState = world.getBlockState(below);
            atState = world.getBlockState(pos);
            if (!belowState.is(ModBlocks.DISTORTION_COBBLESTONE) && !belowState.is(ModBlocks.DISTORTION_STONE) || !atState.isAir() && !atState.is(Blocks.WATER)) continue;
            return pos;
        }
        return null;
    }
}

