/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.world.processor;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import github.jorgaomc.LegendaryMonuments;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class NetherOpenAreaProcessor
extends StructureProcessor {
    public static final MapCodec<NetherOpenAreaProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.intRange((int)1, (int)32).fieldOf("horizontal_radius").forGetter(processor -> processor.horizontalRadius), (App)Codec.intRange((int)1, (int)16).fieldOf("vertical_radius").forGetter(processor -> processor.verticalRadius), (App)Codec.doubleRange((double)0.0, (double)1.0).fieldOf("min_open_percentage").forGetter(processor -> processor.minOpenPercentage)).apply((Applicative)instance, NetherOpenAreaProcessor::new));
    public static final StructureProcessorType<NetherOpenAreaProcessor> TYPE = () -> CODEC;
    private final int horizontalRadius;
    private final int verticalRadius;
    private final double minOpenPercentage;
    private boolean hasValidated = false;
    private boolean isValidLocation = true;

    public NetherOpenAreaProcessor(int horizontalRadius, int verticalRadius, double minOpenPercentage) {
        this.horizontalRadius = horizontalRadius;
        this.verticalRadius = verticalRadius;
        this.minOpenPercentage = minOpenPercentage;
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader world, BlockPos pos, BlockPos pivot, StructureTemplate.StructureBlockInfo originalBlockInfo, StructureTemplate.StructureBlockInfo currentBlockInfo, StructurePlaceSettings data) {
        if (!this.hasValidated) {
            this.hasValidated = true;
            this.isValidLocation = this.isValidNetherOpenArea(world, pivot);
            LegendaryMonuments.LOGGER.info("Shrine placement validation at {}: {}", (Object)pivot, (Object)(this.isValidLocation ? "PASSED" : "FAILED"));
        }
        return currentBlockInfo;
    }

    private boolean isValidNetherOpenArea(LevelReader world, BlockPos centerPos) {
        int openBlockCount = 0;
        int totalCheckedBlocks = 0;
        int lavaBlocksNearby = 0;
        int solidBlocksImmediate = 0;
        for (int x = -this.horizontalRadius; x <= this.horizontalRadius; ++x) {
            for (int z = -this.horizontalRadius; z <= this.horizontalRadius; ++z) {
                for (int y = -this.verticalRadius; y <= this.verticalRadius; ++y) {
                    BlockPos checkPos = centerPos.offset(x, y, z);
                    BlockState state = world.getBlockState(checkPos);
                    ++totalCheckedBlocks;
                    if (state.isAir() || state.is(Blocks.CAVE_AIR) || !state.blocksMotion() || state.is(Blocks.FIRE) || state.is(Blocks.SOUL_FIRE)) {
                        ++openBlockCount;
                    }
                    if (state.is(Blocks.LAVA) && Math.abs(x) <= 2 && Math.abs(z) <= 2 && Math.abs(y) <= 1) {
                        ++lavaBlocksNearby;
                    }
                    if (!state.is(Blocks.NETHERRACK) && !state.is(Blocks.BLACKSTONE) && !state.is(Blocks.BASALT) && !state.is(Blocks.SOUL_SAND) && !state.is(Blocks.SOUL_SOIL) || Math.abs(x) > 1 || Math.abs(z) > 1 || Math.abs(y) > 1) continue;
                    ++solidBlocksImmediate;
                }
            }
        }
        double openPercentage = (double)openBlockCount / (double)totalCheckedBlocks;
        boolean hasEnoughOpenSpace = openPercentage >= this.minOpenPercentage * 0.5;
        boolean notTooMuchLava = lavaBlocksNearby < 10;
        boolean notTooSolid = solidBlocksImmediate < 15;
        boolean result = hasEnoughOpenSpace && notTooMuchLava && notTooSolid;
        LegendaryMonuments.LOGGER.info("Shrine validation details at {}: open={}% ({}/{}), lava={}, solid={}, result={}", new Object[]{centerPos, String.format("%.1f", openPercentage * 100.0), openBlockCount, totalCheckedBlocks, lavaBlocksNearby, solidBlocksImmediate, result});
        return result;
    }

    protected StructureProcessorType<?> getType() {
        return TYPE;
    }

    public static void register() {
        Registry.register((Registry)BuiltInRegistries.STRUCTURE_PROCESSOR, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"nether_open_area"), TYPE);
    }
}

