/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.world.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class NetherOpenAreaPlacementModifier
extends PlacementModifier {
    public static final MapCodec<NetherOpenAreaPlacementModifier> MODIFIER_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.intRange((int)1, (int)32).fieldOf("horizontal_radius").forGetter(modifier -> modifier.horizontalRadius), (App)Codec.intRange((int)1, (int)16).fieldOf("vertical_radius").forGetter(modifier -> modifier.verticalRadius), (App)Codec.intRange((int)1, (int)10).fieldOf("min_open_blocks").forGetter(modifier -> modifier.minOpenBlocks)).apply((Applicative)instance, NetherOpenAreaPlacementModifier::new));
    public static final PlacementModifierType<NetherOpenAreaPlacementModifier> TYPE = () -> MODIFIER_CODEC;
    private final int horizontalRadius;
    private final int verticalRadius;
    private final int minOpenBlocks;

    public NetherOpenAreaPlacementModifier(int horizontalRadius, int verticalRadius, int minOpenBlocks) {
        this.horizontalRadius = horizontalRadius;
        this.verticalRadius = verticalRadius;
        this.minOpenBlocks = minOpenBlocks;
    }

    public Stream<BlockPos> getPositions(PlacementContext context, RandomSource random, BlockPos pos) {
        WorldGenLevel world = context.getLevel();
        if (!this.isValidNetherOpenArea((LevelReader)world, pos)) {
            return Stream.empty();
        }
        return Stream.of(pos);
    }

    private boolean isValidNetherOpenArea(LevelReader world, BlockPos pos) {
        int openBlockCount = 0;
        int totalCheckedBlocks = 0;
        for (int x = -this.horizontalRadius; x <= this.horizontalRadius; ++x) {
            for (int z = -this.horizontalRadius; z <= this.horizontalRadius; ++z) {
                for (int y = -this.verticalRadius; y <= this.verticalRadius; ++y) {
                    BlockPos above;
                    BlockPos checkPos = pos.offset(x, y, z);
                    BlockState state = world.getBlockState(checkPos);
                    ++totalCheckedBlocks;
                    if (state.isAir() || state.is(Blocks.CAVE_AIR) || !state.blocksMotion() || state.is(Blocks.FIRE) || state.is(Blocks.SOUL_FIRE)) {
                        ++openBlockCount;
                    }
                    if (state.is(Blocks.LAVA) && pos.distSqr((Vec3i)(above = checkPos.above())) < 4.0) {
                        return false;
                    }
                    if (!state.is(Blocks.NETHERRACK) && !state.is(Blocks.BLACKSTONE) && !state.is(Blocks.BASALT) && !state.is(Blocks.SOUL_SAND) && !state.is(Blocks.SOUL_SOIL) || Math.abs(x) > 2 || Math.abs(z) > 2 || Math.abs(y) > 1) continue;
                    return false;
                }
            }
        }
        double openPercentage = (double)openBlockCount / (double)totalCheckedBlocks;
        return openPercentage >= 0.6 && openBlockCount >= this.minOpenBlocks;
    }

    public PlacementModifierType<?> type() {
        return TYPE;
    }

    public static void register() {
        Registry.register((Registry)BuiltInRegistries.PLACEMENT_MODIFIER_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"nether_open_area"), TYPE);
    }
}

