/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.block;

import com.cobblemon.yajatkaul.mega_showdown.block.custom.DormantCrystal;
import com.cobblemon.yajatkaul.mega_showdown.block.custom.GracideaBlock;
import com.cobblemon.yajatkaul.mega_showdown.block.custom.KeyStoneBlock;
import com.cobblemon.yajatkaul.mega_showdown.block.custom.MaxMushroomBlock;
import com.cobblemon.yajatkaul.mega_showdown.block.custom.PedestalBlock;
import com.cobblemon.yajatkaul.mega_showdown.block.custom.PowerSpotBlock;
import com.cobblemon.yajatkaul.mega_showdown.block.custom.RotomUnit;
import com.cobblemon.yajatkaul.mega_showdown.block.custom.WishingStarCrystal;
import com.cobblemon.yajatkaul.mega_showdown.block.custom.zygarde.ReassemblyUnitBlock;
import com.cobblemon.yajatkaul.mega_showdown.item.ModItems;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"mega_showdown");
    public static final DeferredBlock<Block> KEYSTONE_BLOCK = ModBlocks.registerBlock("keystone_block", () -> new KeyStoneBlock(BlockBehaviour.Properties.of().strength(3.0f).requiresCorrectToolForDrops().sound(SoundType.STONE)));
    public static final DeferredBlock<Block> MEGA_METEOROID_BLOCK = ModBlocks.registerMeteoroidBlock("mega_meteorid_block");
    public static final DeferredBlock<Block> MEGA_EVO_BLOCK = ModBlocks.registerMeteoroidBlock("mega_evo_block");
    public static final DeferredBlock<Block> MEGA_EVO_BRICK = ModBlocks.registerMeteoroidBlock("mega_evo_brick");
    public static final DeferredBlock<Block> CHISELED_MEGA_EVO_BRICK = ModBlocks.registerMeteoroidBlock("chiseled_mega_evo_brick");
    public static final DeferredBlock<Block> CHISELED_MEGA_EVO_BLOCK = ModBlocks.registerMeteoroidBlock("chiseled_mega_evo_block");
    public static final DeferredBlock<Block> POLISHED_MEGA_EVO_BLOCK = ModBlocks.registerMeteoroidBlock("polished_mega_evo_block");
    public static final DeferredBlock<Block> DEOXYS_METEORITE = BLOCKS.register("deoxys_meteorite", () -> new Block(BlockBehaviour.Properties.of().strength(3.0f).mapColor(MapColor.COLOR_PINK).requiresCorrectToolForDrops().sound(SoundType.STONE)));
    public static final DeferredBlock<Block> POWER_SPOT = ModBlocks.registerBlockWithToolTip("power_spot", () -> new PowerSpotBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<Block> MAX_MUSHROOM = BLOCKS.register("max_mushroom", () -> new MaxMushroomBlock(BlockBehaviour.Properties.of().noCollission().sound(SoundType.FLOWERING_AZALEA)));
    public static final DeferredBlock<Block> GRACIDEA_FLOWER = BLOCKS.register("gracidea_flower", GracideaBlock::new);
    public static final DeferredBlock<Block> POTTED_GRACIDEA = BLOCKS.register("potted_gracidea", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, GRACIDEA_FLOWER, BlockBehaviour.Properties.of().noOcclusion().instabreak()));
    public static final DeferredBlock<Block> PEDESTAL = ModBlocks.registerBlock("pedestal", () -> new PedestalBlock(BlockBehaviour.Properties.of().noOcclusion().requiresCorrectToolForDrops().strength(2.0f)));
    public static final DeferredBlock<Block> REASSEMBLY_UNIT = ModBlocks.registerBlock("reassembly_unit", () -> new ReassemblyUnitBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<AmethystClusterBlock> WISHING_STAR_CRYSTAL = ModBlocks.registerBlock("wishing_star_crystal", () -> new WishingStarCrystal(4.0f, 3.0f, BlockBehaviour.Properties.of(), true));
    public static final DeferredBlock<AmethystClusterBlock> DORMANT_CRYSTAL = ModBlocks.registerBlock("dormant_crystal", () -> new DormantCrystal(4.0f, 3.0f, BlockBehaviour.Properties.of(), false));
    public static final DeferredBlock<Block> ROTOM_WASHING_MACHINE = ModBlocks.registerRotomBlock("rotom_washing_machine", "wash");
    public static final DeferredBlock<Block> ROTOM_FAN = ModBlocks.registerRotomBlock("rotom_fan", "fan");
    public static final DeferredBlock<Block> ROTOM_MOW = ModBlocks.registerRotomBlock("rotom_mow", "mow");
    public static final DeferredBlock<Block> ROTOM_FRIDGE = ModBlocks.registerRotomBlock("rotom_fridge", "frost");
    public static final DeferredBlock<Block> ROTOM_OVEN = ModBlocks.registerRotomBlock("rotom_oven", "heat");

    private static DeferredBlock<Block> registerMeteoroidBlock(String name) {
        return ModBlocks.registerBlock(name, () -> new Block(BlockBehaviour.Properties.of().strength(3.0f).mapColor(MapColor.COLOR_PURPLE).requiresCorrectToolForDrops().sound(SoundType.STONE)));
    }

    private static DeferredBlock<Block> registerRotomBlock(String name, String form) {
        return ModBlocks.registerBlockWithoutItem(name, () -> new RotomUnit(BlockBehaviour.Properties.of().requiresCorrectToolForDrops().strength(2.0f).mapColor(DyeColor.ORANGE).sound(SoundType.METAL), form));
    }

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> DeferredBlock<T> registerBlockWithToolTip(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItemWithToolTip(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    private static <T extends Block> void registerBlockItemWithToolTip(final String name, DeferredBlock<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()){

            public void appendHoverText(ItemStack arg, Item.TooltipContext arg2, List<Component> list, TooltipFlag arg3) {
                list.add((Component)Component.translatable((String)("tooltip.mega_showdown." + name + ".tooltip")));
                super.appendHoverText(arg, arg2, list, arg3);
            }
        });
    }

    private static <T extends Block> DeferredBlock<T> registerBlockWithoutItem(String name, Supplier<T> block) {
        return BLOCKS.register(name, block);
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

