/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.block.custom.zygarde;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.item.PokeBallItem;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.yajatkaul.mega_showdown.block.custom.zygarde.properties.ReassembleStage;
import com.cobblemon.yajatkaul.mega_showdown.dataAttachments.DataManage;
import com.cobblemon.yajatkaul.mega_showdown.dataAttachments.PokeHandler;
import com.cobblemon.yajatkaul.mega_showdown.item.FormeChangeItems;
import com.cobblemon.yajatkaul.mega_showdown.item.custom.zygarde.ZygardeCube;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class ReassemblyUnitBlock
extends Block {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<ReassembleStage> REASSEMBLE_STAGE = EnumProperty.create((String)"reassemble_stage", ReassembleStage.class);
    private static final VoxelShape UPPER_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape LOWER_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public ReassemblyUnitBlock(BlockBehaviour.Properties properties) {
        super(properties.strength(3.0f).mapColor(MapColor.TERRACOTTA_WHITE).requiresCorrectToolForDrops().noOcclusion().sound(SoundType.METAL));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(REASSEMBLE_STAGE, (Comparable)((Object)ReassembleStage.IDLE)));
    }

    protected static void preventDropFromBottomPart(Level arg, BlockPos arg2, BlockState arg3, Player arg4) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)arg3.getValue(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER && (blockstate = arg.getBlockState(blockpos = arg2.below())).is(arg3.getBlock()) && blockstate.getValue(HALF) == DoubleBlockHalf.LOWER) {
            BlockState blockstate1 = blockstate.getFluidState().is((Fluid)Fluids.WATER) ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
            arg.setBlock(blockpos, blockstate1, 35);
            arg.levelEvent(arg4, 2001, blockpos, Block.getId((BlockState)blockstate));
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter arg2, BlockPos arg3, CollisionContext arg4) {
        return state.getValue(HALF) == DoubleBlockHalf.UPPER ? UPPER_SHAPE : LOWER_SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, HALF, REASSEMBLE_STAGE});
    }

    protected BlockState updateShape(BlockState arg, Direction arg2, BlockState arg3, LevelAccessor arg4, BlockPos arg5, BlockPos arg6) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)arg.getValue(HALF);
        if (arg2.getAxis() != Direction.Axis.Y || doubleblockhalf == DoubleBlockHalf.LOWER != (arg2 == Direction.UP) || arg3.is((Block)this) && arg3.getValue(HALF) != doubleblockhalf) {
            return doubleblockhalf == DoubleBlockHalf.LOWER && arg2 == Direction.DOWN && !arg.canSurvive((LevelReader)arg4, arg5) ? Blocks.AIR.defaultBlockState() : super.updateShape(arg, arg2, arg3, arg4, arg5, arg6);
        }
        return Blocks.AIR.defaultBlockState();
    }

    public BlockState playerWillDestroy(Level arg, BlockPos arg2, BlockState arg3, Player arg4) {
        if (!arg.isClientSide && arg4.isCreative()) {
            ReassemblyUnitBlock.preventDropFromBottomPart(arg, arg2, arg3, arg4);
        }
        return super.playerWillDestroy(arg, arg2, arg3, arg4);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        level.setBlock(pos.above(), (BlockState)state.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    @javax.annotation.Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        Direction playerFacing = context.getHorizontalDirection();
        if (pos.getY() < level.getMaxBuildHeight() - 1 && level.getBlockState(pos.above()).canBeReplaced(context)) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)FACING, (Comparable)playerFacing.getOpposite());
        }
        return null;
    }

    public boolean canDropFromExplosion(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return state.getValue(HALF) == DoubleBlockHalf.LOWER;
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.PUSH_ONLY;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult arg7) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            pos = pos.below();
            state = level.getBlockState(pos);
        }
        BlockState upper = level.getBlockState(pos.above());
        stack = player.getItemInHand(hand);
        PokeHandler refValue = (PokeHandler)stack.get(DataManage.POKEMON_STORAGE);
        Pokemon pokemon = refValue == null ? null : refValue.getPokemon();
        if (player.getItemInHand(hand).getItem() instanceof ZygardeCube && pokemon != null) {
            if (state.getValue(REASSEMBLE_STAGE) == ReassembleStage.IDLE) {
                ItemStack cells = new ItemStack((ItemLike)FormeChangeItems.ZYGARDE_CELL.get());
                ItemStack cores = new ItemStack((ItemLike)FormeChangeItems.ZYGARDE_CORE.get());
                if (pokemon.getAspects().contains("10-percent")) {
                    cells.setCount(9);
                    cores.setCount(1);
                } else if (pokemon.getAspects().contains("50-percent")) {
                    cells.setCount(49);
                    cores.setCount(1);
                }
                ItemEntity cellDrop = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, cells.copy());
                level.addFreshEntity((Entity)cellDrop);
                ItemEntity coreDrop = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, cores.copy());
                level.addFreshEntity((Entity)coreDrop);
                stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"item.mega_showdown.zygarde_cube"));
                stack.set(DataManage.POKEMON_STORAGE, null);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.machine_being_used").withColor(0xFF0000), true);
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (state.getValue(REASSEMBLE_STAGE) == ReassembleStage.IDLE && stack.is(FormeChangeItems.ZYGARDE_CUBE)) {
            Item cores = stack.getItem();
            if (cores instanceof ZygardeCube) {
                ZygardeCube cube = (ZygardeCube)cores;
                ItemStackHandler inv = cube.getInventory(stack, level, player);
                ItemStack slot0 = inv.getStackInSlot(0);
                ItemStack slot1 = inv.getStackInSlot(1);
                if (slot0.getCount() == 95 && slot1.getCount() == 5) {
                    inv.setStackInSlot(0, ItemStack.EMPTY);
                    inv.setStackInSlot(1, ItemStack.EMPTY);
                    level.setBlock(pos, (BlockState)state.setValue(REASSEMBLE_STAGE, (Comparable)((Object)ReassembleStage.COOKING_100)), 3);
                    level.setBlock(pos.above(), (BlockState)upper.setValue(REASSEMBLE_STAGE, (Comparable)((Object)ReassembleStage.COOKING_100)), 3);
                    level.scheduleTick(pos, (Block)this, 12000);
                    level.scheduleTick(pos.above(), (Block)this, 12000);
                } else if (slot0.getCount() >= 49 && slot1.getCount() >= 1) {
                    ItemStack newSlot0 = slot0.copy();
                    ItemStack newSlot1 = slot1.copy();
                    newSlot0.setCount(slot0.getCount() - 49);
                    newSlot1.setCount(slot1.getCount() - 1);
                    inv.setStackInSlot(0, newSlot0);
                    inv.setStackInSlot(1, newSlot1);
                    level.setBlock(pos, (BlockState)state.setValue(REASSEMBLE_STAGE, (Comparable)((Object)ReassembleStage.COOKING_50)), 3);
                    level.setBlock(pos.above(), (BlockState)upper.setValue(REASSEMBLE_STAGE, (Comparable)((Object)ReassembleStage.COOKING_50)), 3);
                    level.scheduleTick(pos, (Block)this, 6000);
                    level.scheduleTick(pos.above(), (Block)this, 6000);
                } else if (slot0.getCount() >= 9 && slot1.getCount() >= 1) {
                    ItemStack newSlot0 = slot0.copy();
                    ItemStack newSlot1 = slot1.copy();
                    newSlot0.setCount(slot0.getCount() - 9);
                    newSlot1.setCount(slot1.getCount() - 1);
                    inv.setStackInSlot(0, newSlot0);
                    inv.setStackInSlot(1, newSlot1);
                    level.setBlock(pos, (BlockState)state.setValue(REASSEMBLE_STAGE, (Comparable)((Object)ReassembleStage.COOKING_10)), 3);
                    level.setBlock(pos.above(), (BlockState)upper.setValue(REASSEMBLE_STAGE, (Comparable)((Object)ReassembleStage.COOKING_10)), 3);
                    level.scheduleTick(pos, (Block)this, 2400);
                    level.scheduleTick(pos.above(), (Block)this, 2400);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.not_enough_cells_core").withColor(0xFF0000), true);
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        Item inv = stack.getItem();
        if (inv instanceof PokeBallItem) {
            PokeBallItem ball = (PokeBallItem)inv;
            int shinyRoll = ThreadLocalRandom.current().nextInt(1, (int)(Cobblemon.config.getShinyRate() + 1.0f));
            if (state.getValue(REASSEMBLE_STAGE) == ReassembleStage.FINISHED_10) {
                Pokemon zygarde = PokemonProperties.Companion.parse("zygarde percent_cells=10").create();
                zygarde.setCaughtBall(ball.getPokeBall());
                if (shinyRoll == 1) {
                    zygarde.setShiny(true);
                }
                Cobblemon.INSTANCE.getStorage().getParty((ServerPlayer)player).add(zygarde);
                stack.shrink(1);
                level.setBlock(pos, (BlockState)state.setValue(REASSEMBLE_STAGE, (Comparable)((Object)ReassembleStage.IDLE)), 3);
                level.setBlock(pos.above(), (BlockState)upper.setValue(REASSEMBLE_STAGE, (Comparable)((Object)ReassembleStage.IDLE)), 3);
                return ItemInteractionResult.SUCCESS;
            }
            if (state.getValue(REASSEMBLE_STAGE) == ReassembleStage.FINISHED_50) {
                Pokemon zygarde = PokemonProperties.Companion.parse("zygarde percent_cells=50").create();
                zygarde.setCaughtBall(ball.getPokeBall());
                if (shinyRoll == 1) {
                    zygarde.setShiny(true);
                }
                Cobblemon.INSTANCE.getStorage().getParty((ServerPlayer)player).add(zygarde);
                stack.shrink(1);
                level.setBlock(pos, (BlockState)state.setValue(REASSEMBLE_STAGE, (Comparable)((Object)ReassembleStage.IDLE)), 3);
                level.setBlock(pos.above(), (BlockState)upper.setValue(REASSEMBLE_STAGE, (Comparable)((Object)ReassembleStage.IDLE)), 3);
                return ItemInteractionResult.SUCCESS;
            }
            if (state.getValue(REASSEMBLE_STAGE) == ReassembleStage.FINISHED_100) {
                Pokemon zygarde = PokemonProperties.Companion.parse("zygarde percent_cells=50 power-construct").create();
                zygarde.setCaughtBall(ball.getPokeBall());
                if (shinyRoll == 1) {
                    zygarde.setShiny(true);
                }
                Cobblemon.INSTANCE.getStorage().getParty((ServerPlayer)player).add(zygarde);
                stack.shrink(1);
                level.setBlock(pos, (BlockState)state.setValue(REASSEMBLE_STAGE, (Comparable)((Object)ReassembleStage.IDLE)), 3);
                level.setBlock(pos.above(), (BlockState)upper.setValue(REASSEMBLE_STAGE, (Comparable)((Object)ReassembleStage.IDLE)), 3);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        switch ((ReassembleStage)((Object)state.getValue(REASSEMBLE_STAGE))) {
            case COOKING_10: {
                level.setBlock(pos, (BlockState)state.setValue(REASSEMBLE_STAGE, (Comparable)((Object)ReassembleStage.FINISHED_10)), 3);
                break;
            }
            case COOKING_50: {
                level.setBlock(pos, (BlockState)state.setValue(REASSEMBLE_STAGE, (Comparable)((Object)ReassembleStage.FINISHED_50)), 3);
                break;
            }
            case COOKING_100: {
                level.setBlock(pos, (BlockState)state.setValue(REASSEMBLE_STAGE, (Comparable)((Object)ReassembleStage.FINISHED_100)), 3);
            }
        }
    }

    public boolean isRandomlyTicking(BlockState state) {
        return switch ((ReassembleStage)((Object)state.getValue(REASSEMBLE_STAGE))) {
            case ReassembleStage.COOKING_10, ReassembleStage.COOKING_50, ReassembleStage.COOKING_100 -> true;
            default -> false;
        };
    }
}

