/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.commands;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.yajatkaul.mega_showdown.datapack.data.FusionData;
import com.cobblemon.yajatkaul.mega_showdown.datapack.data.HeldItemData;
import com.cobblemon.yajatkaul.mega_showdown.datapack.data.KeyItemData;
import com.cobblemon.yajatkaul.mega_showdown.datapack.data.MegaData;
import com.cobblemon.yajatkaul.mega_showdown.datapack.data.ShowdownItemData;
import com.cobblemon.yajatkaul.mega_showdown.temp.TestCommand;
import com.cobblemon.yajatkaul.mega_showdown.utility.Utils;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

public class MegaCommands {
    public static final List<String> VALID_ITEMS = new ArrayList<String>();

    public static void register(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"msdresetlock").requires(source -> source.hasPermission(0))).executes(context -> MegaCommands.executeResetCommon((Player)((CommandSourceStack)context.getSource()).getPlayer())));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"msdresetmega").requires(source -> source.hasPermission(0))).executes(context -> MegaCommands.executeResetMega((Player)((CommandSourceStack)context.getSource()).getPlayer())));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"msd").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"give").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"itemtype", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> SharedSuggestionProvider.suggest(List.of("mega_stone", "held_item", "showdown_item", "fusion_item", "key_item"), (SuggestionsBuilder)builder)).then(((RequiredArgumentBuilder)Commands.argument((String)"item", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            String type;
            switch (type = StringArgumentType.getString((CommandContext)context, (String)"itemtype")) {
                case "mega_stone": {
                    Utils.megaRegistry.forEach(m -> builder.suggest(m.msd_id()));
                    break;
                }
                case "held_item": {
                    Utils.heldItemsRegistry.forEach(i -> builder.suggest(i.msd_id()));
                    break;
                }
                case "showdown_item": {
                    Utils.showdownItemRegistry.forEach(i -> builder.suggest(i.msd_id()));
                    break;
                }
                case "fusion_item": {
                    Utils.fusionRegistry.forEach(f -> builder.suggest(f.msd_id()));
                    break;
                }
                case "key_item": {
                    Utils.keyItemsRegistry.forEach(k -> builder.suggest(k.msd_id()));
                }
            }
            return builder.buildFuture();
        }).executes(context -> {
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)context, (String)"player");
            String itemtype = StringArgumentType.getString((CommandContext)context, (String)"itemtype");
            String item = StringArgumentType.getString((CommandContext)context, (String)"item");
            return MegaCommands.executeGive(player, itemtype, item, 1);
        })).then(Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)context, (String)"player");
            String itemtype = StringArgumentType.getString((CommandContext)context, (String)"itemtype");
            String item = StringArgumentType.getString((CommandContext)context, (String)"item");
            int count = IntegerArgumentType.getInteger((CommandContext)context, (String)"count");
            return MegaCommands.executeGive(player, itemtype, item, count);
        })))))));
        TestCommand.INSTANCE.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private static int executeGive(ServerPlayer player, String itemtype, String item, int count) {
        switch (itemtype) {
            case "mega_stone": {
                for (MegaData pokemon : Utils.megaRegistry) {
                    if (!pokemon.msd_id().equals(item)) continue;
                    return MegaCommands.giveItem(player, pokemon.item_id(), pokemon.item_name(), pokemon.item_description(), pokemon.custom_model_data(), count);
                }
                break;
            }
            case "held_item": {
                for (HeldItemData held : Utils.heldItemsRegistry) {
                    if (!held.msd_id().equals(item)) continue;
                    return MegaCommands.giveItem(player, held.item_id(), held.item_name(), held.item_description(), held.custom_model_data(), count);
                }
                break;
            }
            case "showdown_item": {
                for (ShowdownItemData sd : Utils.showdownItemRegistry) {
                    if (!sd.msd_id().equals(item)) continue;
                    return MegaCommands.giveItem(player, sd.item_id(), sd.item_name(), sd.item_description(), sd.custom_model_data(), count);
                }
                break;
            }
            case "fusion_item": {
                for (FusionData fusion : Utils.fusionRegistry) {
                    if (!fusion.msd_id().equals(item)) continue;
                    return MegaCommands.giveItem(player, fusion.item_id(), fusion.item_name(), fusion.item_description(), fusion.custom_model_data(), count);
                }
                break;
            }
            case "key_item": {
                for (KeyItemData key : Utils.keyItemsRegistry) {
                    if (!key.msd_id().equals(item)) continue;
                    return MegaCommands.giveItem(player, key.item_id(), key.item_name(), key.item_description(), key.custom_model_data(), count);
                }
                break;
            }
            default: {
                player.sendSystemMessage((Component)Component.literal((String)("Unknown item type: " + itemtype)).withStyle(ChatFormatting.RED));
                return 0;
            }
        }
        player.sendSystemMessage((Component)Component.literal((String)("Item not found: " + item)).withStyle(ChatFormatting.RED));
        return 0;
    }

    private static int giveItem(ServerPlayer player, String itemIdStr, String itemName, List<String> description, int modelData, int count) {
        ResourceLocation id = ResourceLocation.tryParse((String)itemIdStr);
        Item item = (Item)BuiltInRegistries.ITEM.get(id);
        ItemStack stack = new ItemStack((ItemLike)item, count);
        stack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(modelData));
        stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)itemName));
        ArrayList<MutableComponent> lore = new ArrayList<MutableComponent>();
        for (String line : description) {
            lore.add(Component.translatable((String)line));
        }
        stack.set(DataComponents.LORE, (Object)new ItemLore(lore));
        player.addItem(stack);
        player.sendSystemMessage((Component)Component.literal((String)("You received: " + itemIdStr)).withStyle(ChatFormatting.GREEN));
        return 1;
    }

    private static int executeResetCommon(Player player) {
        PCStore storge = Cobblemon.INSTANCE.getStorage().getPC((ServerPlayer)player);
        PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty((ServerPlayer)player);
        for (Pokemon pokemon : storge) {
            if (pokemon.getAspects().contains("mega") || pokemon.getAspects().contains("mega_y") || pokemon.getAspects().contains("mega_x")) {
                new StringSpeciesFeature("mega_evolution", "none").apply(pokemon);
            }
            if (!pokemon.getAspects().contains("primal")) continue;
            new StringSpeciesFeature("reversion_state", "standard").apply(pokemon);
        }
        for (Pokemon pokemon : party) {
            if (pokemon.getAspects().contains("mega") || pokemon.getAspects().contains("mega_y") || pokemon.getAspects().contains("mega_x")) {
                new StringSpeciesFeature("mega_evolution", "none").apply(pokemon);
            }
            if (!pokemon.getAspects().contains("primal")) continue;
            new StringSpeciesFeature("reversion_state", "standard").apply(pokemon);
        }
        player.sendSystemMessage((Component)Component.translatable((String)"message.mega_showdown.reset_completed"));
        return 1;
    }

    private static int executeResetMega(Player player) {
        PCStore storge = Cobblemon.INSTANCE.getStorage().getPC((ServerPlayer)player);
        PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty((ServerPlayer)player);
        for (Pokemon pokemon : storge) {
            if (!pokemon.getAspects().contains("mega") && !pokemon.getAspects().contains("mega_y") && !pokemon.getAspects().contains("mega_x")) continue;
            new StringSpeciesFeature("mega_evolution", "none").apply(pokemon);
        }
        for (Pokemon pokemon : party) {
            if (!pokemon.getAspects().contains("mega") && !pokemon.getAspects().contains("mega_y") && !pokemon.getAspects().contains("mega_x")) continue;
            new StringSpeciesFeature("mega_evolution", "none").apply(pokemon);
        }
        return 1;
    }
}

