/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.event.cobblemon.handlers;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.drop.ItemDropEntry;
import com.cobblemon.mod.common.api.events.battles.instruction.FormeChangeEvent;
import com.cobblemon.mod.common.api.events.battles.instruction.MegaEvolutionEvent;
import com.cobblemon.mod.common.api.events.battles.instruction.TerastallizationEvent;
import com.cobblemon.mod.common.api.events.battles.instruction.ZMoveUsedEvent;
import com.cobblemon.mod.common.api.events.drops.LootDroppedEvent;
import com.cobblemon.mod.common.api.events.pokeball.ThrownPokeballHitEvent;
import com.cobblemon.mod.common.api.events.pokemon.HeldItemEvent;
import com.cobblemon.mod.common.api.events.pokemon.PokemonCapturedEvent;
import com.cobblemon.mod.common.api.events.pokemon.PokemonSentPostEvent;
import com.cobblemon.mod.common.api.events.pokemon.healing.PokemonHealedEvent;
import com.cobblemon.mod.common.api.events.storage.ReleasePokemonEvent;
import com.cobblemon.mod.common.api.item.HealingSource;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.types.tera.TeraTypes;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.yajatkaul.mega_showdown.advancement.AdvancementHelper;
import com.cobblemon.yajatkaul.mega_showdown.config.MegaShowdownConfig;
import com.cobblemon.yajatkaul.mega_showdown.datapack.handler.EventHandler;
import com.cobblemon.yajatkaul.mega_showdown.event.cobblemon.handlers.HeldItemChangeFormes;
import com.cobblemon.yajatkaul.mega_showdown.event.cobblemon.utils.EventUtils;
import com.cobblemon.yajatkaul.mega_showdown.formChangeLogic.MegaLogic;
import com.cobblemon.yajatkaul.mega_showdown.item.FormeChangeItems;
import com.cobblemon.yajatkaul.mega_showdown.item.TeraMoves;
import com.cobblemon.yajatkaul.mega_showdown.item.custom.tera.TeraOrb;
import com.cobblemon.yajatkaul.mega_showdown.sound.ModSounds;
import com.cobblemon.yajatkaul.mega_showdown.utility.GlowHandler;
import com.cobblemon.yajatkaul.mega_showdown.utility.SnowStormHandler;
import com.cobblemon.yajatkaul.mega_showdown.utility.TeraTypeHelper;
import java.util.List;
import java.util.Random;
import java.util.Set;
import kotlin.Unit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class CobbleEventsHandler {
    public static Unit onHeldItemChange(HeldItemEvent.Pre event) {
        if (event.getReceiving() == event.getReturning() || event.getPokemon().getOwnerPlayer() == null) {
            return Unit.INSTANCE;
        }
        PokemonEntity pokemonEntity = event.getPokemon().getEntity();
        if (pokemonEntity == null || ((Boolean)pokemonEntity.getEntityData().get(PokemonEntity.getEVOLUTION_STARTED())).booleanValue()) {
            event.cancel();
            return Unit.INSTANCE;
        }
        HeldItemChangeFormes.primalEvent(event);
        HeldItemChangeFormes.genesectChange(event);
        HeldItemChangeFormes.silvallyChange(event);
        HeldItemChangeFormes.arcuesChange(event);
        HeldItemChangeFormes.ultraEvent(event);
        HeldItemChangeFormes.crownedEvent(event);
        HeldItemChangeFormes.ogerponChange(event);
        HeldItemChangeFormes.eternamaxChange(event);
        HeldItemChangeFormes.originChange(event);
        EventHandler.customEvents(event);
        if (MegaShowdownConfig.battleModeOnly) {
            return Unit.INSTANCE;
        }
        HeldItemChangeFormes.megaEvent(event);
        return Unit.INSTANCE;
    }

    public static Unit onReleasePokemon(ReleasePokemonEvent.Post post) {
        Pokemon released = post.getPokemon();
        ServerPlayer player = post.getPlayer();
        if (released.getSpecies().getName().equals("Meltan")) {
            EventUtils.giveItems(player, new ItemStack((ItemLike)FormeChangeItems.MELTAN.get()));
        }
        return Unit.INSTANCE;
    }

    public static Unit megaEvolution(MegaEvolutionEvent megaEvolutionEvent) {
        PokemonBattle battle = megaEvolutionEvent.getBattle();
        Pokemon pokemon = megaEvolutionEvent.getPokemon().getEffectedPokemon();
        battle.dispatchWaitingToFront(5.9f, () -> Unit.INSTANCE);
        if (pokemon.getOwnerPlayer() == null) {
            MegaLogic.NPCEvolve(pokemon.getEntity(), megaEvolutionEvent.getPokemon(), battle);
        } else {
            MegaLogic.Evolve(pokemon.getEntity(), (Player)pokemon.getOwnerPlayer(), megaEvolutionEvent.getPokemon(), battle);
        }
        return Unit.INSTANCE;
    }

    public static Unit zMovesUsed(ZMoveUsedEvent zMoveUsedEvent) {
        PokemonEntity pokemon = zMoveUsedEvent.getPokemon().getEffectedPokemon().getEntity();
        Pokemon pk = zMoveUsedEvent.getPokemon().getEffectedPokemon();
        AdvancementHelper.grantAdvancement(pk.getOwnerPlayer(), "z/z_moves");
        if (pk.getSpecies().getName().equals("Pikachu") && pk.getAspects().contains("partner-cap")) {
            AdvancementHelper.grantAdvancement(pk.getOwnerPlayer(), "bond/ash_pikachu");
        }
        if (pokemon != null) {
            GlowHandler.applyZGlow(pokemon);
        }
        SnowStormHandler.Companion.snowStormPartileSpawner(pk.getEntity(), ResourceLocation.tryParse((String)"cobblemon:z_moves"), List.of("target"));
        BlockPos entityPos = pokemon.getOnPos();
        pokemon.level().playSound(null, (double)entityPos.getX(), (double)entityPos.getY(), (double)entityPos.getZ(), ModSounds.ZMOVE.get(), SoundSource.PLAYERS, 0.2f, 0.7f);
        zMoveUsedEvent.getBattle().dispatchWaitingToFront(4.0f, () -> Unit.INSTANCE);
        pk.getEntity().after(2.5f, () -> {
            SnowStormHandler.Companion.playAnimation((Entity)pk.getEntity(), Set.of("cry"), List.of());
            return Unit.INSTANCE;
        });
        return Unit.INSTANCE;
    }

    public static Unit terrastallizationUsed(TerastallizationEvent terastallizationEvent) {
        PokemonEntity pokemon = terastallizationEvent.getPokemon().getEffectedPokemon().getEntity();
        Pokemon pk = terastallizationEvent.getPokemon().getEffectedPokemon();
        Vec3 entityPos = pokemon.position();
        AdvancementHelper.grantAdvancement(pk.getOwnerPlayer(), "tera/terastallized");
        pokemon.level().playSound(null, entityPos.x, entityPos.y, entityPos.z, ModSounds.TERASTALLIZATION.get(), SoundSource.PLAYERS, 0.4f, 1.0f);
        if (pk.getSpecies().getName().equals("Terapagos")) {
            new StringSpeciesFeature("tera_form", "stellar").apply(pk);
            EventUtils.updatePackets(terastallizationEvent.getBattle(), terastallizationEvent.getPokemon());
            EventUtils.playEvolveAnimation((LivingEntity)pokemon);
        } else if (pk.getSpecies().getName().equals("Ogerpon")) {
            new FlagSpeciesFeature("embody-aspect", true).apply(pk);
            EventUtils.updatePackets(terastallizationEvent.getBattle(), terastallizationEvent.getPokemon());
        }
        pk.getPersistentData().putBoolean("is_tera", true);
        GlowHandler.applyTeraGlow(pokemon);
        ServerPlayer player = terastallizationEvent.getPokemon().getEffectedPokemon().getOwnerPlayer();
        boolean hasTerapagos = false;
        if (player != null) {
            PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
            for (Pokemon pokemonParty : playerPartyStore) {
                if (!pokemonParty.getSpecies().getName().equals("Terapagos")) continue;
                hasTerapagos = true;
                break;
            }
        }
        if (!hasTerapagos) {
            CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(curiosInventory -> curiosInventory.findFirstCurio(stack -> stack.getItem() instanceof TeraOrb)).map(SlotResult::stack).ifPresent(teraOrb -> teraOrb.setDamageValue(teraOrb.getDamageValue() + 10));
        }
        terastallizationEvent.getBattle().dispatchWaitingToFront(3.0f, () -> {
            SnowStormHandler.Companion.playAnimation((Entity)pk.getEntity(), Set.of("cry"), List.of());
            return Unit.INSTANCE;
        });
        return Unit.INSTANCE;
    }

    public static Unit healedPokemons(PokemonHealedEvent pokemonHealedEvent) {
        ServerPlayer player = pokemonHealedEvent.getPokemon().getOwnerPlayer();
        if (player == null || pokemonHealedEvent.getSource() != HealingSource.Force.INSTANCE) {
            return Unit.INSTANCE;
        }
        CuriosApi.getCuriosInventory((LivingEntity)pokemonHealedEvent.getPokemon().getOwnerPlayer()).flatMap(curiosInventory -> curiosInventory.findFirstCurio(stack -> stack.getItem() instanceof TeraOrb)).map(SlotResult::stack).ifPresent(teraOrb -> teraOrb.setDamageValue(0));
        return Unit.INSTANCE;
    }

    public static Unit dropShardPokemon(LootDroppedEvent lootDroppedEvent) {
        boolean stellarSuccess;
        if (!MegaShowdownConfig.teralization || !(lootDroppedEvent.getEntity() instanceof PokemonEntity)) {
            return Unit.INSTANCE;
        }
        Pokemon pokemon = ((PokemonEntity)lootDroppedEvent.getEntity()).getPokemon();
        Item correspondingTeraShard = TeraTypeHelper.getTeraShardForType(pokemon.getTypes());
        ItemDropEntry teraShardDropEntry = new ItemDropEntry();
        teraShardDropEntry.setItem(BuiltInRegistries.ITEM.getKey((Object)correspondingTeraShard));
        Random random = new Random();
        boolean otherSuccess = random.nextDouble() < MegaShowdownConfig.teraShardDropRate / 100.0;
        boolean bl = stellarSuccess = random.nextDouble() < MegaShowdownConfig.stellarShardDropRate / 100.0;
        if (otherSuccess) {
            lootDroppedEvent.getDrops().add(teraShardDropEntry);
        } else if (stellarSuccess) {
            teraShardDropEntry.setItem(BuiltInRegistries.ITEM.getKey((Object)((Item)TeraMoves.STELLAR_TERA_SHARD.get())));
            lootDroppedEvent.getDrops().add(teraShardDropEntry);
        }
        return Unit.INSTANCE;
    }

    public static Unit formeChanges(FormeChangeEvent formeChangeEvent) {
        if (formeChangeEvent.getFormeName().equals("x") || formeChangeEvent.getFormeName().equals("y") || formeChangeEvent.getFormeName().equals("mega") || formeChangeEvent.getFormeName().equals("tera")) {
            return Unit.INSTANCE;
        }
        Pokemon pokemon = formeChangeEvent.getPokemon().getEffectedPokemon();
        PokemonBattle battle = formeChangeEvent.getBattle();
        PokemonEntity pokemonEntity = pokemon.getEntity();
        BlockPos entityPos = pokemonEntity.getOnPos();
        switch (pokemon.getSpecies().getName()) {
            case "Aegislash": {
                if (formeChangeEvent.getFormeName().equals("blade")) {
                    new StringSpeciesFeature("stance_forme", "blade").apply(pokemon);
                    break;
                }
                if (!formeChangeEvent.getFormeName().equals("aegislash")) break;
                new StringSpeciesFeature("stance_forme", "shield").apply(pokemon);
                break;
            }
            case "Minior": {
                if (formeChangeEvent.getFormeName().equals("meteor")) {
                    EventUtils.playFormeChangeAnimation((LivingEntity)pokemon.getEntity());
                    new StringSpeciesFeature("meteor_shield", "meteor").apply(pokemon);
                    break;
                }
                EventUtils.playFormeChangeAnimation((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("meteor_shield", "core").apply(pokemon);
                break;
            }
            case "Castform": {
                switch (formeChangeEvent.getFormeName()) {
                    case "sunny": {
                        EventUtils.playFormeChangeAnimation((LivingEntity)pokemon.getEntity());
                        new StringSpeciesFeature("forecast_form", "sunny").apply(pokemon);
                        break;
                    }
                    case "rainy": {
                        EventUtils.playFormeChangeAnimation((LivingEntity)pokemon.getEntity());
                        new StringSpeciesFeature("forecast_form", "rainy").apply(pokemon);
                        break;
                    }
                    case "snowy": {
                        EventUtils.playFormeChangeAnimation((LivingEntity)pokemon.getEntity());
                        new StringSpeciesFeature("forecast_form", "snowy").apply(pokemon);
                    }
                }
                break;
            }
            case "Wishiwashi": {
                if (formeChangeEvent.getFormeName().equals("school")) {
                    battle.dispatchWaitingToFront(4.5f, () -> {
                        SnowStormHandler.Companion.snowStormPartileSpawner(pokemonEntity, ResourceLocation.tryParse((String)"cobblemon:wishiwashi_effect"), List.of("target"));
                        pokemonEntity.level().playSound(null, (double)entityPos.getX(), (double)entityPos.getY(), (double)entityPos.getZ(), ModSounds.FORM_CHANGE_BASIC.get(), SoundSource.PLAYERS, 0.2f, 1.3f);
                        return Unit.INSTANCE;
                    });
                    pokemonEntity.after(5.0f, () -> {
                        new StringSpeciesFeature("schooling_form", "school").apply(pokemon);
                        SnowStormHandler.Companion.playAnimation((Entity)pokemonEntity, Set.of("cry"), List.of());
                        EventUtils.updatePackets(battle, formeChangeEvent.getPokemon());
                        return Unit.INSTANCE;
                    });
                    return Unit.INSTANCE;
                }
                if (!formeChangeEvent.getFormeName().equals("wishiwashi")) break;
                new StringSpeciesFeature("schooling_form", "solo").apply(pokemon);
                EventUtils.playFormeChangeAnimation((LivingEntity)pokemon.getEntity());
                break;
            }
            case "Mimikyu": {
                if (!formeChangeEvent.getFormeName().equals("busted")) break;
                new StringSpeciesFeature("disguise_form", "busted").apply(pokemon);
                break;
            }
            case "Greninja": {
                if (formeChangeEvent.getFormeName().equals("ash")) {
                    pokemonEntity.level().playSound(null, (double)entityPos.getX(), (double)entityPos.getY(), (double)entityPos.getZ(), ModSounds.FORM_CHANGE_BASIC.get(), SoundSource.PLAYERS, 0.2f, 1.3f);
                    battle.dispatchWaitingToFront(4.5f, () -> {
                        SnowStormHandler.Companion.snowStormPartileSpawner(pokemonEntity, ResourceLocation.tryParse((String)"cobblemon:battlebond_effect"), List.of("root"));
                        return Unit.INSTANCE;
                    });
                    pokemonEntity.after(4.0f, () -> {
                        new StringSpeciesFeature("battle_bond", "ash").apply(pokemon);
                        SnowStormHandler.Companion.playAnimation((Entity)pokemonEntity, Set.of("cry"), List.of());
                        EventUtils.updatePackets(battle, formeChangeEvent.getPokemon());
                        return Unit.INSTANCE;
                    });
                    AdvancementHelper.grantAdvancement(pokemon.getOwnerPlayer(), "bond/ash_greninja");
                    return Unit.INSTANCE;
                }
                AdvancementHelper.grantAdvancement(pokemon.getOwnerPlayer(), "bond/ash_battle_bond");
                break;
            }
            case "Cherrim": {
                if (formeChangeEvent.getFormeName().equals("sunshine")) {
                    EventUtils.playFormeChangeAnimation((LivingEntity)pokemon.getEntity());
                    new StringSpeciesFeature("blossom_form", "sunshine").apply(pokemon);
                    break;
                }
                EventUtils.playFormeChangeAnimation((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("blossom_form", "overcast").apply(pokemon);
                break;
            }
            case "Palafin": {
                if (!formeChangeEvent.getFormeName().equals("hero")) break;
                EventUtils.playFormeChangeAnimation((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("dolphin_form", "hero").apply(pokemon);
                break;
            }
            case "Morpeko": {
                if (formeChangeEvent.getFormeName().equals("hangry")) {
                    EventUtils.playFormeChangeAngryAnimation((LivingEntity)pokemon.getEntity());
                    new StringSpeciesFeature("hunger_mode", "hangry").apply(pokemon);
                    break;
                }
                new StringSpeciesFeature("hunger_mode", "full_belly").apply(pokemon);
                break;
            }
            case "Eiscue": {
                if (formeChangeEvent.getFormeName().equals("noice")) {
                    EventUtils.playFormeChangeAnimation((LivingEntity)pokemon.getEntity());
                    new StringSpeciesFeature("penguin_head", "noice_face").apply(pokemon);
                    break;
                }
                EventUtils.playFormeChangeAnimation((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("penguin_head", "ice_face").apply(pokemon);
                break;
            }
            case "Cramorant": {
                switch (formeChangeEvent.getFormeName()) {
                    case "gulping": {
                        EventUtils.playFormeChangeAnimation((LivingEntity)pokemon.getEntity());
                        new StringSpeciesFeature("missile_form", "gulping").apply(pokemon);
                        break;
                    }
                    case "cramorant": {
                        EventUtils.playFormeChangeAnimation((LivingEntity)pokemon.getEntity());
                        new StringSpeciesFeature("missile_form", "none").apply(pokemon);
                        break;
                    }
                    case "gorging": {
                        EventUtils.playFormeChangeAnimation((LivingEntity)pokemon.getEntity());
                        new StringSpeciesFeature("missile_form", "gorging").apply(pokemon);
                    }
                }
                break;
            }
            case "Darmanitan": {
                if (formeChangeEvent.getFormeName().equals("zen")) {
                    EventUtils.playFormeChangeAnimation((LivingEntity)pokemon.getEntity());
                    new StringSpeciesFeature("blazing_mode", "zen").apply(pokemon);
                    break;
                }
                EventUtils.playFormeChangeAnimation((LivingEntity)pokemon.getEntity());
                new StringSpeciesFeature("blazing_mode", "standard").apply(pokemon);
                break;
            }
            case "Arceus": {
                battle.dispatchWaitingToFront(3.0f, () -> {
                    pokemonEntity.level().playSound(null, (double)entityPos.getX(), (double)entityPos.getY(), (double)entityPos.getZ(), ModSounds.ARCEUS_MULTITYPE.get(), SoundSource.PLAYERS, 0.2f, 0.8f);
                    SnowStormHandler.Companion.snowStormPartileSpawner(pokemon.getEntity(), ResourceLocation.tryParse((String)("cobblemon:arceus_" + formeChangeEvent.getFormeName())), List.of("target"));
                    pokemon.getEntity().getEntityData().set(PokemonEntity.getEVOLUTION_STARTED(), (Object)true);
                    return Unit.INSTANCE;
                });
                pokemon.getEntity().after(4.0f, () -> {
                    new StringSpeciesFeature("multitype", formeChangeEvent.getFormeName()).apply(pokemon);
                    SnowStormHandler.Companion.playAnimation((Entity)pokemon.getEntity(), Set.of("cry"), List.of());
                    pokemon.getEntity().getEntityData().set(PokemonEntity.getEVOLUTION_STARTED(), (Object)false);
                    return Unit.INSTANCE;
                });
                break;
            }
            case "Xerneas": {
                if (!formeChangeEvent.getFormeName().equals("active")) break;
                new StringSpeciesFeature("life_mode", "active").apply(pokemon);
                break;
            }
            case "Terapagos": {
                if (!formeChangeEvent.getFormeName().equals("terastal")) break;
                battle.dispatchWaitingToFront(4.5f, () -> {
                    SnowStormHandler.Companion.snowStormPartileSpawner(pokemonEntity, ResourceLocation.tryParse((String)"cobblemon:terapagos_effect"), List.of("target"));
                    pokemonEntity.level().playSound(null, (double)entityPos.getX(), (double)entityPos.getY(), (double)entityPos.getZ(), ModSounds.FORM_CHANGE_BASIC.get(), SoundSource.PLAYERS, 0.2f, 2.1f);
                    return Unit.INSTANCE;
                });
                pokemonEntity.after(3.9f, () -> {
                    new StringSpeciesFeature("tera_form", "terastal").apply(pokemon);
                    SnowStormHandler.Companion.playAnimation((Entity)pokemonEntity, Set.of("cry"), List.of());
                    EventUtils.updatePackets(battle, formeChangeEvent.getPokemon());
                    return Unit.INSTANCE;
                });
                return Unit.INSTANCE;
            }
            case "Meloetta": {
                if (formeChangeEvent.getFormeName().equals("pirouette")) {
                    new StringSpeciesFeature("song_forme", "pirouette").apply(pokemon);
                    EventUtils.playEvolveAnimation((LivingEntity)pokemon.getEntity());
                    break;
                }
                new StringSpeciesFeature("song_forme", "aria").apply(pokemon);
                break;
            }
            case "Zygarde": {
                if (!formeChangeEvent.getFormeName().equals("complete")) break;
                pokemonEntity.level().playSound(null, (double)entityPos.getX(), (double)entityPos.getY(), (double)entityPos.getZ(), ModSounds.POWER_CONSTRUCT.get(), SoundSource.PLAYERS, 0.2f, 0.8f);
                battle.dispatchWaitingToFront(4.5f, () -> {
                    SnowStormHandler.Companion.snowStormPartileSpawner(pokemonEntity, ResourceLocation.tryParse((String)"cobblemon:power_construct_event"), List.of("target"));
                    return Unit.INSTANCE;
                });
                pokemonEntity.after(4.0f, () -> {
                    if (pokemon.getAspects().contains("10-percent")) {
                        pokemon.getPersistentData().putString("zygarde_form", "10");
                    } else {
                        pokemon.getPersistentData().putString("zygarde_form", "50");
                    }
                    new StringSpeciesFeature("percent_cells", "complete").apply(pokemon);
                    SnowStormHandler.Companion.playAnimation((Entity)pokemonEntity, Set.of("cry"), List.of());
                    EventUtils.updatePackets(battle, formeChangeEvent.getPokemon());
                    return Unit.INSTANCE;
                });
                return Unit.INSTANCE;
            }
            case "Shaymin": {
                if (!formeChangeEvent.getFormeName().equals("shaymin")) break;
                new StringSpeciesFeature("gracidea_forme", "land").apply(pokemon);
                EventUtils.playEvolveAnimation((LivingEntity)pokemon.getEntity());
            }
        }
        EventHandler.battleModeFormChange(formeChangeEvent);
        EventUtils.updatePackets(battle, formeChangeEvent.getPokemon());
        return Unit.INSTANCE;
    }

    public static Unit fixTera(PokemonCapturedEvent pokemonCapturedEvent) {
        Pokemon pokemon = pokemonCapturedEvent.getPokemon();
        if (pokemon.getSpecies().getName().equals("Ogerpon")) {
            pokemon.setTeraType(TeraTypes.getGRASS());
        } else if (pokemon.getSpecies().getName().equals("Terapagos")) {
            pokemon.setTeraType(TeraTypes.getSTELLAR());
        }
        return Unit.INSTANCE;
    }

    public static Unit pokemonSent(PokemonSentPostEvent pokemonSentPostEvent) {
        PokemonEntity pokemon = pokemonSentPostEvent.getPokemonEntity();
        Pokemon pk = pokemonSentPostEvent.getPokemon();
        if (pk.getPersistentData().getBoolean("is_tera")) {
            GlowHandler.applyTeraGlow(pokemon);
        }
        return Unit.INSTANCE;
    }

    public static Unit pokeballHit(ThrownPokeballHitEvent thrownPokeballHitEvent) {
        if (thrownPokeballHitEvent.getPokemon().getAspects().contains("core-percent")) {
            thrownPokeballHitEvent.cancel();
        }
        return Unit.INSTANCE;
    }
}

