/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.event.cobblemon.handlers;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.events.battles.BattleFaintedEvent;
import com.cobblemon.mod.common.api.events.battles.BattleStartedPostEvent;
import com.cobblemon.mod.common.api.events.battles.BattleStartedPreEvent;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.storage.player.GeneralPlayerData;
import com.cobblemon.mod.common.battles.ShowdownMoveset;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.yajatkaul.mega_showdown.block.ModBlocks;
import com.cobblemon.yajatkaul.mega_showdown.config.MegaShowdownConfig;
import com.cobblemon.yajatkaul.mega_showdown.event.cobblemon.utils.EventUtils;
import com.cobblemon.yajatkaul.mega_showdown.formChangeLogic.FormChangeHelper;
import com.cobblemon.yajatkaul.mega_showdown.formChangeLogic.MegaLogic;
import com.cobblemon.yajatkaul.mega_showdown.utility.ModTags;
import kotlin.Unit;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class RevertEventsHandler {
    public static Unit devolveFainted(BattleFaintedEvent battleFaintedEvent) {
        Pokemon pokemon = battleFaintedEvent.getKilled().getOriginalPokemon();
        ServerPlayer serverPlayer = battleFaintedEvent.getKilled().getOriginalPokemon().getOwnerPlayer();
        if (serverPlayer == null) {
            return Unit.INSTANCE;
        }
        pokemon.getPersistentData().putBoolean("is_tera", false);
        boolean isMega = pokemon.getAspects().stream().anyMatch(aspect -> aspect.startsWith("mega"));
        if (isMega) {
            MegaLogic.Devolve(pokemon, true);
        }
        return Unit.INSTANCE;
    }

    public static Unit battleStarted(@NotNull BattleStartedPreEvent battleEvent) {
        for (BattleActor pokemon : battleEvent.getBattle().getActors()) {
            for (BattlePokemon pk : pokemon.getPokemonList()) {
                if (!pk.getEffectedPokemon().getAspects().contains("core-percent")) continue;
                battleEvent.cancel();
                return Unit.INSTANCE;
            }
        }
        for (ServerPlayer player : battleEvent.getBattle().getPlayers()) {
            GeneralPlayerData data = Cobblemon.INSTANCE.getPlayerDataManager().getGenericData(player);
            if (RevertEventsHandler.isBlockNearby(player, (Block)ModBlocks.POWER_SPOT.get(), MegaShowdownConfig.powerSpotRange) || MegaShowdownConfig.dynamaxAnywhere) {
                if (RevertEventsHandler.hasGimmick(ShowdownMoveset.Gimmick.DYNAMAX, player)) {
                    data.getKeyItems().add(ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"dynamax_band"));
                } else {
                    data.getKeyItems().remove(ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"dynamax_band"));
                }
            } else {
                data.getKeyItems().remove(ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"dynamax_band"));
            }
            if (RevertEventsHandler.hasGimmick(ShowdownMoveset.Gimmick.TERASTALLIZATION, player)) {
                data.getKeyItems().add(ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"tera_orb"));
            } else {
                data.getKeyItems().remove(ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"tera_orb"));
            }
            if (RevertEventsHandler.hasGimmick(ShowdownMoveset.Gimmick.MEGA_EVOLUTION, player)) {
                data.getKeyItems().add(ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"key_stone"));
            } else {
                data.getKeyItems().remove(ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"key_stone"));
            }
            if (RevertEventsHandler.hasGimmick(ShowdownMoveset.Gimmick.Z_POWER, player)) {
                data.getKeyItems().add(ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"z_ring"));
                continue;
            }
            data.getKeyItems().remove(ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"z_ring"));
        }
        return Unit.INSTANCE;
    }

    public static boolean hasGimmick(ShowdownMoveset.Gimmick gimmick, ServerPlayer player) {
        if (gimmick == ShowdownMoveset.Gimmick.DYNAMAX) {
            if (!MegaShowdownConfig.dynamax) {
                return false;
            }
            boolean hasDMaxItemTrinkets = CuriosApi.getCuriosInventory((LivingEntity)player).map(inventory -> inventory.isEquipped(stack -> stack.is(ModTags.Items.DYNAMAX_BAND))).orElse(false);
            return player.getOffhandItem().is(ModTags.Items.DYNAMAX_BAND) || player.getMainHandItem().is(ModTags.Items.DYNAMAX_BAND) || hasDMaxItemTrinkets;
        }
        if (gimmick == ShowdownMoveset.Gimmick.TERASTALLIZATION) {
            if (!MegaShowdownConfig.teralization) {
                return false;
            }
            PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
            boolean hasTerapagos = false;
            for (Pokemon pokemon : playerPartyStore) {
                if (pokemon.getSpecies().getName().equals("Terapagos")) {
                    hasTerapagos = true;
                }
                EventUtils.revertFormesEnd(pokemon);
            }
            ItemStack teraOrb = CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(curiosInventory -> curiosInventory.findFirstCurio(stack -> stack.is(ModTags.Items.TERA_ORBS))).map(SlotResult::stack).orElse(null);
            if (teraOrb == null) {
                return false;
            }
            if (hasTerapagos) {
                teraOrb.setDamageValue(0);
            }
            return teraOrb.getDamageValue() < 100;
        }
        if (gimmick == ShowdownMoveset.Gimmick.Z_POWER) {
            if (!MegaShowdownConfig.zMoves) {
                return false;
            }
            boolean hasZPowerItemTrinkets = CuriosApi.getCuriosInventory((LivingEntity)player).map(inventory -> inventory.isEquipped(stack -> stack.is(ModTags.Items.Z_RINGS))).orElse(false);
            return player.getOffhandItem().is(ModTags.Items.Z_RINGS) || player.getMainHandItem().is(ModTags.Items.Z_RINGS) || hasZPowerItemTrinkets;
        }
        if (gimmick == ShowdownMoveset.Gimmick.MEGA_EVOLUTION) {
            if (!MegaShowdownConfig.mega) {
                return false;
            }
            boolean hasKeystoneItemTrinkets = CuriosApi.getCuriosInventory((LivingEntity)player).map(inventory -> inventory.isEquipped(stack -> stack.is(ModTags.Items.MEGA_BRACELETS))).orElse(false);
            return (player.getOffhandItem().is(ModTags.Items.MEGA_BRACELETS) || player.getMainHandItem().is(ModTags.Items.MEGA_BRACELETS) || hasKeystoneItemTrinkets) && !FormChangeHelper.hasMega(player);
        }
        return false;
    }

    public static boolean isBlockNearby(ServerPlayer player, Block targetBlock, int radius) {
        BlockPos playerPos = player.blockPosition();
        ServerLevel level = player.serverLevel();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos checkPos = playerPos.offset(dx, dy, dz);
                    if (!level.getBlockState(checkPos).is(targetBlock)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static Unit hookBattleEnded(BattleStartedPostEvent event) {
        event.getBattle().getOnEndHandlers().add(battle -> {
            battle.getPlayers().forEach(serverPlayer -> {
                PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(serverPlayer);
                for (Pokemon pokemon : playerPartyStore) {
                    EventUtils.revertFormesEnd(pokemon);
                    if (pokemon.getEntity() == null) continue;
                    pokemon.getEntity().removeEffect(MobEffects.GLOWING);
                }
            });
            return Unit.INSTANCE;
        });
        return Unit.INSTANCE;
    }
}

