/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.item.custom.dynamax;

import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.advancement.CobblemonCriteria;
import com.cobblemon.mod.common.advancement.criterion.PokemonInteractContext;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.callback.PartySelectCallbacks;
import com.cobblemon.mod.common.api.events.Cancelable;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.pokemon.healing.PokemonHealedEvent;
import com.cobblemon.mod.common.api.item.HealingSource;
import com.cobblemon.mod.common.api.reactive.CancelableObservable;
import com.cobblemon.mod.common.api.reactive.EventObservable;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.battles.BagItemActionResponse;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.ShowdownActionResponse;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.item.CobblemonItem;
import com.cobblemon.mod.common.item.battle.BagItem;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.ItemStackExtensionsKt;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.cobblemon.yajatkaul.mega_showdown.item.custom.dynamax.MaxHoney;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J5\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J-\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00172\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001b\u001a\u00020\u001a8\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lcom/cobblemon/yajatkaul/mega_showdown/item/custom/dynamax/MaxHoney;", "Lcom/cobblemon/mod/common/item/CobblemonItem;", "Lcom/cobblemon/mod/common/api/item/HealingSource;", "<init>", "()V", "Lnet/minecraft/world/item/ItemStack;", "arg", "Lnet/minecraft/world/item/Item$TooltipContext;", "arg2", "", "Lnet/minecraft/network/chat/Component;", "tooltipComponents", "Lnet/minecraft/world/item/TooltipFlag;", "arg3", "", "appendHoverText", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/Item$TooltipContext;Ljava/util/List;Lnet/minecraft/world/item/TooltipFlag;)V", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/world/entity/player/Player;", "user", "Lnet/minecraft/world/InteractionHand;", "hand", "Lnet/minecraft/world/InteractionResultHolder;", "use", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;", "Lcom/cobblemon/mod/common/item/battle/BagItem;", "bagItem", "Lcom/cobblemon/mod/common/item/battle/BagItem;", "getBagItem", "()Lcom/cobblemon/mod/common/item/battle/BagItem;", "Cobblemon_MegaShowdown"})
public final class MaxHoney
extends CobblemonItem
implements HealingSource {
    @NotNull
    private final BagItem bagItem = new BagItem(){
        @NotNull
        private final String itemName;
        private final Item returnItem;
        {
            this.itemName = "item.mega_showdown.max_honey";
            this.returnItem = Items.AIR;
        }

        @NotNull
        public String getItemName() {
            return this.itemName;
        }

        public Item getReturnItem() {
            return this.returnItem;
        }

        public boolean canUse(@NotNull PokemonBattle battle, @NotNull BattlePokemon target) {
            Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            return target.getHealth() <= 0;
        }

        @NotNull
        public String getShowdownInput(@NotNull BattleActor actor, @NotNull BattlePokemon battlePokemon, @Nullable String data) {
            Intrinsics.checkNotNullParameter((Object)actor, (String)"actor");
            Intrinsics.checkNotNullParameter((Object)battlePokemon, (String)"battlePokemon");
            return "max_honey";
        }

        public boolean canStillUse(@NotNull ServerPlayer player, @NotNull PokemonBattle battle, @NotNull BattleActor actor, @NotNull BattlePokemon target, @NotNull ItemStack stack) {
            return BagItem.DefaultImpls.canStillUse((BagItem)this, (ServerPlayer)player, (PokemonBattle)battle, (BattleActor)actor, (BattlePokemon)target, (ItemStack)stack);
        }
    };

    public MaxHoney() {
        super(new Item.Properties());
    }

    @NotNull
    public final BagItem getBagItem() {
        return this.bagItem;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player user, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (!(world instanceof ServerLevel)) {
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)user.getItemInHand(hand));
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
            return interactionResultHolder;
        }
        ServerPlayer player = (ServerPlayer)user;
        ItemStack stack = user.getItemInHand(hand);
        PokemonBattle battle = BattleRegistry.INSTANCE.getBattleByParticipatingPlayer(player);
        if (battle != null) {
            BattleActor battleActor = battle.getActor(player);
            Intrinsics.checkNotNull((Object)battleActor);
            BattleActor actor = battleActor;
            List battlePokemon = actor.getPokemonList();
            if (!actor.canFitForcedAction()) {
                MutableComponent mutableComponent = LocalizationUtilsKt.battleLang((String)"bagitem.cannot", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"battleLang(...)");
                player.sendSystemMessage((Component)TextKt.red((MutableComponent)mutableComponent), true);
                InteractionResultHolder interactionResultHolder = InteractionResultHolder.consume((Object)stack);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(...)");
                return interactionResultHolder;
            }
            int turn = battle.getTurn();
            PartySelectCallbacks.createBattleSelect$default((PartySelectCallbacks)PartySelectCallbacks.INSTANCE, (ServerPlayer)player, null, (List)battlePokemon, (Function1)((Function1)new Function1<BattlePokemon, Boolean>(this, battle){
                final /* synthetic */ MaxHoney this$0;
                final /* synthetic */ PokemonBattle $battle;
                {
                    this.this$0 = $receiver;
                    this.$battle = $battle;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull BattlePokemon it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.this$0.getBagItem().canUse(this.$battle, it);
                }
            }), null, (Function1)((Function1)new Function1<BattlePokemon, Unit>(actor, battle, turn, stack, player, this){
                final /* synthetic */ BattleActor $actor;
                final /* synthetic */ PokemonBattle $battle;
                final /* synthetic */ int $turn;
                final /* synthetic */ ItemStack $stack;
                final /* synthetic */ ServerPlayer $player;
                final /* synthetic */ MaxHoney this$0;
                {
                    this.$actor = $actor;
                    this.$battle = $battle;
                    this.$turn = $turn;
                    this.$stack = $stack;
                    this.$player = $player;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull BattlePokemon bp) {
                    Intrinsics.checkNotNullParameter((Object)bp, (String)"bp");
                    if (this.$actor.canFitForcedAction() && bp.getHealth() <= 0 && this.$battle.getTurn() == this.$turn) {
                        ItemStack itemStack = this.$stack;
                        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"$stack");
                        if (ItemStackExtensionsKt.isHeld((ItemStack)itemStack, (ServerPlayer)this.$player)) {
                            this.$player.playSound(CobblemonSounds.ITEM_USE, 1.0f, 1.0f);
                            this.$actor.forceChoose((ShowdownActionResponse)new BagItemActionResponse(this.this$0.getBagItem(), bp, bp.getUuid().toString()));
                            ResourceLocation resourceLocation = BuiltInRegistries.ITEM.getKey((Object)this.$stack.getItem());
                            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getKey(...)");
                            ResourceLocation stackName = resourceLocation;
                            this.$stack.consume(1, (LivingEntity)this.$player);
                            CobblemonCriteria.INSTANCE.getPOKEMON_INTERACT().trigger(this.$player, (Object)new PokemonInteractContext(bp.getEffectedPokemon().getSpecies().getResourceIdentifier(), stackName));
                        }
                    }
                }
            }), (int)18, null);
        } else {
            List pokemon = CollectionsKt.toList((Iterable)((Iterable)PlayerExtensionsKt.party((ServerPlayer)player)));
            PartySelectCallbacks.createFromPokemon$default((PartySelectCallbacks)PartySelectCallbacks.INSTANCE, (ServerPlayer)player, null, (List)pokemon, (Function1)use.3.INSTANCE, null, (Function1)((Function1)new Function1<Pokemon, Unit>(player, stack, this){
                final /* synthetic */ ServerPlayer $player;
                final /* synthetic */ ItemStack $stack;
                final /* synthetic */ MaxHoney this$0;
                {
                    this.$player = $player;
                    this.$stack = $stack;
                    this.this$0 = $receiver;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull Pokemon pk) {
                    Intrinsics.checkNotNullParameter((Object)pk, (String)"pk");
                    if (pk.isFainted() && !PlayerExtensionsKt.isInBattle((ServerPlayer)this.$player)) {
                        ItemStack itemStack = this.$stack;
                        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"$stack");
                        if (ItemStackExtensionsKt.isHeld((ItemStack)itemStack, (ServerPlayer)this.$player)) {
                            void this_$iv$iv;
                            void event$iv;
                            void this_$iv;
                            int amount = 0;
                            amount = pk.getMaxHealth();
                            CancelableObservable cancelableObservable = CobblemonEvents.POKEMON_HEALED;
                            Cancelable cancelable = (Cancelable)new PokemonHealedEvent(pk, amount, (HealingSource)this.this$0);
                            boolean $i$f$postThen = false;
                            EventObservable eventObservable = (EventObservable)this_$iv;
                            Cancelable[] cancelableArray = new Cancelable[]{event$iv};
                            Cancelable[] events$iv$iv = cancelableArray;
                            boolean $i$f$post = false;
                            this_$iv$iv.emit((Object[])Arrays.copyOf(events$iv$iv, events$iv$iv.length));
                            Cancelable[] $this$forEach$iv$iv$iv = events$iv$iv;
                            boolean $i$f$forEach = false;
                            int n = $this$forEach$iv$iv$iv.length;
                            for (int i = 0; i < n; ++i) {
                                Cancelable element$iv$iv$iv;
                                Cancelable it$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                                boolean bl = false;
                                if (it$iv.isCanceled()) {
                                    PokemonHealedEvent it = (PokemonHealedEvent)it$iv;
                                    boolean bl2 = false;
                                    return;
                                }
                                PokemonHealedEvent event = (PokemonHealedEvent)it$iv;
                                boolean bl3 = false;
                                amount = event.getAmount();
                            }
                            pk.setCurrentHealth(amount);
                            ResourceLocation resourceLocation = BuiltInRegistries.ITEM.getKey((Object)this.$stack.getItem());
                            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getKey(...)");
                            ResourceLocation stackName = resourceLocation;
                            if (!this.$player.isCreative()) {
                                this.$stack.shrink(1);
                            }
                            CobblemonCriteria.INSTANCE.getPOKEMON_INTERACT().trigger(this.$player, (Object)new PokemonInteractContext(pk.getSpecies().getResourceIdentifier(), stackName));
                        }
                    }
                }
            }), (int)18, null);
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)stack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
        return interactionResultHolder;
    }

    public void appendHoverText(@NotNull ItemStack arg, @NotNull Item.TooltipContext arg2, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag arg3) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        Intrinsics.checkNotNullParameter((Object)arg2, (String)"arg2");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)arg3, (String)"arg3");
        MutableComponent mutableComponent = Component.translatable((String)"tooltip.mega_showdown.max_honey.tooltip");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        tooltipComponents.add((Component)mutableComponent);
        super.appendHoverText(arg, arg2, tooltipComponents, arg3);
    }
}

