/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.item.custom.formchange;

import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.yajatkaul.mega_showdown.advancement.AdvancementHelper;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class Cap
extends Item {
    private final List<String> black_list = List.of("cosplay", "belle", "libre", "phd", "pop_star", "rock_star");

    public Cap(Item.Properties arg) {
        super(arg);
    }

    public static void playFormeChangeAnimation(LivingEntity context) {
        Level level = context.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 entityPos = context.position();
            double entityWidth = context.getBbWidth();
            double entityHeight = context.getBbHeight();
            serverLevel.playSound(null, entityPos.x, entityPos.y, entityPos.z, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.PLAYERS, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(10.0 * entityWidth * entityHeight);
            double radius = entityWidth * 0.8;
            for (int i = 0; i < particleCount; ++i) {
                double angle = Math.random() * 2.0 * Math.PI;
                double xOffset = Math.cos(angle) * radius;
                double zOffset = Math.sin(angle) * radius;
                double yOffset = Math.random() * entityHeight;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.HEART, entityPos.x + xOffset, entityPos.y + yOffset, entityPos.z + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public InteractionResult interactLivingEntity(ItemStack arg, Player player, LivingEntity context, InteractionHand arg4) {
        if (!(context instanceof PokemonEntity)) return super.interactLivingEntity(arg, player, context, arg4);
        PokemonEntity pk = (PokemonEntity)context;
        if (pk.getPokemon().getOwnerPlayer() != player) return super.interactLivingEntity(arg, player, context, arg4);
        if (pk.isBattling()) return super.interactLivingEntity(arg, player, context, arg4);
        if (player.isCrouching()) return super.interactLivingEntity(arg, player, context, arg4);
        if (pk.getPokemon().getSpecies().getName().equals("Pikachu") && !pk.getPokemon().getAspects().contains("partner-cap")) {
            if (pk.getAspects().stream().noneMatch(this.black_list::contains)) {
                if (pk.getFriendship() < 200) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.friendship_requirement").withColor(0xFF0000), true);
                    return InteractionResult.PASS;
                }
                Cap.playFormeChangeAnimation(context);
                new StringSpeciesFeature("league_cap", "partner").apply(pk);
                AdvancementHelper.grantAdvancement((ServerPlayer)player, "bond/ash_cap_bond");
                arg.consume(1, (LivingEntity)player);
                return super.interactLivingEntity(arg, player, context, arg4);
            }
        }
        if (!pk.getPokemon().getSpecies().getName().equals("Greninja")) return super.interactLivingEntity(arg, player, context, arg4);
        if (pk.getPokemon().getAspects().contains("bond")) return super.interactLivingEntity(arg, player, context, arg4);
        if (pk.getFriendship() < 200) {
            player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.friendship_requirement").withColor(0xFF0000), true);
            return InteractionResult.PASS;
        }
        Cap.playFormeChangeAnimation(context);
        new StringSpeciesFeature("battle_bond", "bond").apply(pk);
        AdvancementHelper.grantAdvancement((ServerPlayer)player, "bond/ash_cap_bond");
        arg.consume(1, (LivingEntity)player);
        return super.interactLivingEntity(arg, player, context, arg4);
    }
}

