/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.item.custom.formchange;

import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.yajatkaul.mega_showdown.advancement.AdvancementHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

public class RotomUnit
extends BlockItem {
    private static final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private static final long COOLDOWN_TIME = 2000L;
    private static final List<String> rotomAspects = List.of("heat-appliance", "wash-appliance", "mow-appliance", "frost-appliance", "fan-appliance");
    private final String form;

    public RotomUnit(Block arg, Item.Properties arg2, String form) {
        super(arg, arg2);
        this.form = form;
    }

    public static boolean possible(ServerPlayer player) {
        UUID playerId = player.getUUID();
        long currentTime = System.currentTimeMillis();
        if (cooldowns.containsKey(playerId) && currentTime < cooldowns.get(playerId)) {
            player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.not_so_fast").withColor(0xFF0000), true);
            return false;
        }
        cooldowns.put(playerId, currentTime + 2000L);
        return true;
    }

    public static void playFormeChangeAnimation(LivingEntity context) {
        Level level = context.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 entityPos = context.position();
            double entityWidth = context.getBbWidth();
            double entityHeight = context.getBbHeight();
            serverLevel.playSound(null, entityPos.x, entityPos.y, entityPos.z, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.PLAYERS, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(100.0 * entityWidth * entityHeight);
            double radius = entityWidth * 0.8;
            for (int i = 0; i < particleCount; ++i) {
                double angle = Math.random() * 2.0 * Math.PI;
                double xOffset = Math.cos(angle) * radius;
                double zOffset = Math.sin(angle) * radius;
                double yOffset = Math.random() * entityHeight;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.END_ROD, entityPos.x + xOffset, entityPos.y + yOffset, entityPos.z + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }

    public InteractionResult interactLivingEntity(ItemStack arg, Player player, LivingEntity context, InteractionHand arg4) {
        PokemonEntity pk;
        if (!player.level().isClientSide && context instanceof PokemonEntity && (pk = (PokemonEntity)context).getPokemon().getOwnerPlayer() == player && !pk.isBattling() && !player.isCrouching() && pk.getPokemon().getSpecies().getName().equals("Rotom")) {
            if (!RotomUnit.possible((ServerPlayer)player)) {
                return InteractionResult.PASS;
            }
            if (pk.getAspects().stream().anyMatch(rotomAspects::contains)) {
                return InteractionResult.PASS;
            }
            RotomUnit.playFormeChangeAnimation((LivingEntity)pk);
            new StringSpeciesFeature("appliance", this.form).apply(pk);
            arg.consume(1, (LivingEntity)player);
            AdvancementHelper.grantAdvancement((ServerPlayer)player, "rotom/rotom_form_change");
            return InteractionResult.SUCCESS;
        }
        return super.interactLivingEntity(arg, player, context, arg4);
    }
}

