/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.item.custom.zygarde;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.yajatkaul.mega_showdown.dataAttachments.DataManage;
import com.cobblemon.yajatkaul.mega_showdown.dataAttachments.PokeHandler;
import com.cobblemon.yajatkaul.mega_showdown.item.FormeChangeItems;
import com.cobblemon.yajatkaul.mega_showdown.item.inventory.ItemInventoryUtil;
import com.cobblemon.yajatkaul.mega_showdown.screen.custom.ZygardeCubeMenu;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.ItemStackHandler;

public class ZygardeCube
extends Item {
    private static final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private static final long COOLDOWN_TIME = 2000L;

    public ZygardeCube(Item.Properties arg) {
        super(arg);
    }

    public static boolean possible(ServerPlayer player) {
        UUID playerId = player.getUUID();
        long currentTime = System.currentTimeMillis();
        if (cooldowns.containsKey(playerId) && currentTime < cooldowns.get(playerId)) {
            player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.not_so_fast").withColor(0xFF0000), true);
            return false;
        }
        cooldowns.put(playerId, currentTime + 2000L);
        return true;
    }

    public static EntityHitResult getEntityLookingAt(Player player, float distance) {
        Vec3 eyePos = player.getEyePosition();
        Vec3 lookVec = player.getViewVector(1.0f);
        Vec3 targetPos = eyePos.add(lookVec.scale((double)distance));
        AABB rayTraceBox = new AABB(eyePos, targetPos);
        return ProjectileUtil.getEntityHitResult((Level)player.level(), (Entity)player, (Vec3)eyePos, (Vec3)targetPos, (AABB)rayTraceBox, entity -> !entity.isSpectator() && entity instanceof LivingEntity && entity.isPickable(), (float)0.3f);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack;
        if (level.isClientSide || hand == InteractionHand.OFF_HAND) {
            return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
        }
        EntityHitResult entityHit = ZygardeCube.getEntityLookingAt(player, 4.5f);
        if (entityHit != null) {
            Entity entity = entityHit.getEntity();
            if (entity instanceof PokemonEntity) {
                PokemonEntity pk = (PokemonEntity)entity;
                if (pk.getPokemon().getSpecies().getName().equals("Zygarde")) {
                    ItemStack stack2 = player.getItemInHand(hand);
                    Pokemon pokemon = pk.getPokemon();
                    if (pokemon.getEntity() == null || pokemon.getEntity().level().isClientSide || pokemon.getEntity().isBattling()) {
                        return InteractionResultHolder.pass((Object)stack2);
                    }
                    if (pk.getAspects().contains("core-percent") && pokemon.getEntity().getTethering() == null) {
                        ItemStackHandler inventory = this.getInventory(stack2, level, player);
                        if (inventory.getStackInSlot(1).getCount() >= 5) {
                            player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.cube_core_full").withColor(0xFF0000), true);
                            return InteractionResultHolder.pass((Object)stack2);
                        }
                        int count = inventory.getStackInSlot(1).getCount() + 1;
                        ItemStack newStack = new ItemStack((ItemLike)FormeChangeItems.ZYGARDE_CORE.get(), count);
                        inventory.setStackInSlot(1, newStack);
                        CompoundTag updatedTag = inventory.serializeNBT((HolderLookup.Provider)player.level().registryAccess());
                        stack2.set(DataManage.ZYGARDE_INV, (Object)updatedTag);
                        player.setItemInHand(hand, stack2);
                        if (pokemon.getOwnerPlayer() == player) {
                            Cobblemon.INSTANCE.getStorage().getParty((ServerPlayer)player).remove(pokemon);
                        } else {
                            entity.discard();
                        }
                        return InteractionResultHolder.success((Object)stack2);
                    }
                    if (pokemon.getOwnerPlayer() != player) {
                        return InteractionResultHolder.pass((Object)stack2);
                    }
                    if (!pk.getAspects().contains("power-construct") && pokemon.getEntity().getTethering() == null) {
                        if (stack2.get(DataManage.POKEMON_STORAGE) != null) {
                            player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.cube_full").withColor(0xFF0000), true);
                            return InteractionResultHolder.fail((Object)stack2);
                        }
                        stack2.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"item.mega_showdown.zygarde_cube.full"));
                        stack2.set(DataManage.POKEMON_STORAGE, (Object)new PokeHandler(pokemon));
                        Cobblemon.INSTANCE.getStorage().getParty((ServerPlayer)player).remove(pokemon);
                        player.setItemInHand(hand, stack2);
                        return InteractionResultHolder.success((Object)stack2);
                    }
                    if (pk.getAspects().contains("power-construct")) {
                        if (!ZygardeCube.possible((ServerPlayer)player)) {
                            return InteractionResultHolder.pass((Object)stack2);
                        }
                        if (pk.getAspects().contains("10-percent")) {
                            this.particleEffect((LivingEntity)pokemon.getEntity());
                            new StringSpeciesFeature("percent_cells", "50").apply(pk);
                        } else {
                            this.particleEffect((LivingEntity)pokemon.getEntity());
                            new StringSpeciesFeature("percent_cells", "10").apply(pk);
                        }
                    } else {
                        player.displayClientMessage((Component)Component.translatable((String)"message.mega_showdown.resassembly_zygarde_req").withColor(0xFF0000), true);
                    }
                    return InteractionResultHolder.success((Object)stack2);
                }
                stack = player.getItemInHand(hand);
                refValue = (PokeHandler)stack.get(DataManage.POKEMON_STORAGE);
                currentValue = refValue == null ? null : refValue.getPokemon();
                if (currentValue != null) {
                    PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty((ServerPlayer)player);
                    playerPartyStore.add(currentValue);
                    stack.set(DataManage.POKEMON_STORAGE, null);
                    return InteractionResultHolder.success((Object)stack);
                }
            } else {
                stack = player.getItemInHand(hand);
                refValue = (PokeHandler)stack.get(DataManage.POKEMON_STORAGE);
                currentValue = refValue == null ? null : refValue.getPokemon();
                if (currentValue != null) {
                    PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty((ServerPlayer)player);
                    playerPartyStore.add(currentValue);
                    stack.set(DataManage.POKEMON_STORAGE, null);
                    return InteractionResultHolder.success((Object)stack);
                }
            }
        } else {
            stack = player.getItemInHand(hand);
            PokeHandler refValue = (PokeHandler)stack.get(DataManage.POKEMON_STORAGE);
            Pokemon currentValue = refValue == null ? null : refValue.getPokemon();
            if (currentValue != null) {
                PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty((ServerPlayer)player);
                playerPartyStore.add(currentValue);
                stack.set(DataManage.POKEMON_STORAGE, null);
                return InteractionResultHolder.success((Object)stack);
            }
        }
        stack = player.getItemInHand(hand);
        ItemInventoryUtil inventory = new ItemInventoryUtil(stack, player);
        CompoundTag capTag = (CompoundTag)stack.get(DataManage.ZYGARDE_INV);
        RegistryAccess provider = level.registryAccess();
        ItemStackHandler handler = inventory.getHandler();
        if (capTag != null) {
            handler.deserializeNBT((HolderLookup.Provider)provider, capTag);
        }
        CompoundTag serializedTag = handler.serializeNBT((HolderLookup.Provider)provider);
        player.openMenu((MenuProvider)new SimpleMenuProvider((id, playerInventory, playerEntity) -> new ZygardeCubeMenu(id, playerInventory, handler), (Component)Component.translatable((String)"menu.zygade_cube")), buf -> buf.writeNbt((Tag)serializedTag));
        return InteractionResultHolder.success((Object)stack);
    }

    public ItemStackHandler getInventory(ItemStack stack, Level level, Player player) {
        CompoundTag capTag = (CompoundTag)stack.get(DataManage.ZYGARDE_INV);
        RegistryAccess provider = level.registryAccess();
        ItemInventoryUtil inventory = new ItemInventoryUtil(stack, player);
        ItemStackHandler handler = inventory.getHandler();
        if (capTag != null) {
            handler.deserializeNBT((HolderLookup.Provider)provider, capTag);
        }
        return handler;
    }

    private void particleEffect(LivingEntity context) {
        Level level = context.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 entityPos = context.position();
            double entityWidth = context.getBbWidth();
            double entityHeight = context.getBbHeight();
            double entityDepth = entityWidth;
            double scaleFactor = 0.8;
            double adjustedWidth = entityWidth * scaleFactor;
            double adjustedHeight = entityHeight * scaleFactor;
            double adjustedDepth = entityDepth * scaleFactor;
            serverLevel.playSound(null, entityPos.x, entityPos.y, entityPos.z, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.PLAYERS, 1.5f, 0.5f + (float)Math.random() * 0.5f);
            int particleCount = (int)(175.0 * adjustedWidth * adjustedHeight);
            for (int i = 0; i < particleCount; ++i) {
                double xOffset = (Math.random() - 0.5) * adjustedWidth;
                double yOffset = Math.random() * adjustedHeight;
                double zOffset = (Math.random() - 0.5) * adjustedDepth;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.GLOW, entityPos.x + xOffset, entityPos.y + yOffset, entityPos.z + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }
}

