/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.utility;

import java.nio.file.Path;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforgespi.locating.IModFile;

public class PackRegister {
    public static void register(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            ModContainer modContainer = (ModContainer)ModList.get().getModContainerById("mega_showdown").orElseThrow(() -> new IllegalStateException("Mod container not found for ID: mega_showdown"));
            IModFile modFile = modContainer.getModInfo().getOwningFile().getFile();
            Path gyradosJumpMegaPath = modFile.findResource(new String[]{"resourcepacks", "gyaradosjumpingmega"});
            PackLocationInfo gyradosJumpMegaInfo = new PackLocationInfo("gyaradosjumpingmega", (Component)Component.translatable((String)"message.mega_showdown.gyrados_jump_mega"), PackSource.BUILT_IN, Optional.empty());
            Path regionBiasGmaxPath = modFile.findResource(new String[]{"resourcepacks", "regionbiasmsd"});
            PackLocationInfo regionBiasGmaxInfo = new PackLocationInfo("regionbiasmsd", (Component)Component.translatable((String)"message.mega_showdown.region_bias_msd"), PackSource.BUILT_IN, Optional.empty());
            event.addRepositorySource(profileAdder -> profileAdder.accept(PackRegister.createPack(gyradosJumpMegaInfo, gyradosJumpMegaPath)));
            event.addRepositorySource(profileAdder -> profileAdder.accept(PackRegister.createPack(regionBiasGmaxInfo, regionBiasGmaxPath)));
        }
    }

    private static Pack createPack(final PackLocationInfo packInfo, final Path packPath) {
        Pack.ResourcesSupplier resourcesSupplier = new Pack.ResourcesSupplier(){

            public PackResources openPrimary(PackLocationInfo info) {
                return new PathPackResources(packInfo, packPath);
            }

            public PackResources openFull(PackLocationInfo info, Pack.Metadata metadata) {
                return new PathPackResources(packInfo, packPath);
            }
        };
        PackSelectionConfig selectionConfig = new PackSelectionConfig(false, Pack.Position.TOP, true);
        return Pack.readMetaAndCreate((PackLocationInfo)packInfo, (Pack.ResourcesSupplier)resourcesSupplier, (PackType)PackType.CLIENT_RESOURCES, (PackSelectionConfig)selectionConfig);
    }
}

