/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.utility.showdown;

import com.cobblemon.yajatkaul.mega_showdown.MegaShowdown;
import com.cobblemon.yajatkaul.mega_showdown.config.MegaShowdownConfig;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class LoadMethods {
    public void load() {
        if (MegaShowdownConfig.showdownFilesLoading) {
            Path showdown_sim = Path.of("./showdown/sim", new String[0]);
            Path showdown_data = Path.of("./showdown/data", new String[0]);
            Path showdown = Path.of("./showdown", new String[0]);
            Path showdown_mod_data = Path.of("./showdown/data/mods/cobblemon", new String[0]);
            try {
                Files.createDirectories(showdown_sim, new FileAttribute[0]);
                Files.createDirectories(showdown_data, new FileAttribute[0]);
                this.yoink("/assets/mega_showdown/showdown/moves.js", showdown_data.resolve("moves.js"));
                this.yoink("/assets/mega_showdown/showdown/battle-actions.js", showdown_sim.resolve("battle-actions.js"));
                this.yoink("/assets/mega_showdown/showdown/pokemon.js", showdown_sim.resolve("pokemon.js"));
                this.yoink("/assets/mega_showdown/showdown/abilities.js", showdown_data.resolve("abilities.js"));
                this.yoink("/assets/mega_showdown/showdown/side.js", showdown_sim.resolve("side.js"));
                this.yoink("/assets/mega_showdown/showdown/conditions.js", showdown_data.resolve("conditions.js"));
                this.yoink("/assets/mega_showdown/showdown/index.js", showdown.resolve("index.js"));
                if (!Files.exists(showdown_mod_data.resolve("items.js"), new LinkOption[0])) {
                    this.yoink("/assets/mega_showdown/showdown/mods/items.js", showdown_mod_data.resolve("items.js"));
                }
                if (!Files.exists(showdown_mod_data.resolve("abilities.js"), new LinkOption[0])) {
                    this.yoink("/assets/mega_showdown/showdown/mods/abilities.js", showdown_mod_data.resolve("abilities.js"));
                }
                if (!Files.exists(showdown_mod_data.resolve("moves.js"), new LinkOption[0])) {
                    this.yoink("/assets/mega_showdown/showdown/mods/moves.js", showdown_mod_data.resolve("moves.js"));
                }
                if (!Files.exists(showdown_mod_data.resolve("conditions.js"), new LinkOption[0])) {
                    this.yoink("/assets/mega_showdown/showdown/mods/conditions.js", showdown_mod_data.resolve("conditions.js"));
                }
                if (!Files.exists(showdown_mod_data.resolve("typechart.js"), new LinkOption[0])) {
                    this.yoink("/assets/mega_showdown/showdown/mods/typechart.js", showdown_mod_data.resolve("typechart.js"));
                }
                MegaShowdown.LOGGER.info("All files are ready!");
            }
            catch (IOException e) {
                MegaShowdown.LOGGER.error("Failed to prepare required files: {}", (Object)e.getMessage());
            }
        }
    }

    private void yoink(String resourcePath, Path targetPath) {
        try (InputStream inputStream = this.getClass().getResourceAsStream(resourcePath);){
            if (inputStream == null) {
                MegaShowdown.LOGGER.error("Fallback file not found: {}", (Object)resourcePath);
                return;
            }
            Files.copy(inputStream, targetPath, StandardCopyOption.REPLACE_EXISTING);
            MegaShowdown.LOGGER.info("Loaded fallback file: {}", (Object)targetPath);
        }
        catch (IOException e) {
            MegaShowdown.LOGGER.error("Failed to copy fallback file {}: {}", (Object)resourcePath, (Object)e.getMessage());
        }
    }
}

