/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.mixin;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import me.pepperbell.continuity.client.mixinterface.SpriteExtension;
import me.pepperbell.continuity.client.resource.AtlasLoaderInitContext;
import me.pepperbell.continuity.client.resource.AtlasLoaderLoadContext;
import me.pepperbell.continuity.client.resource.SpriteLoaderLoadContext;
import me.pepperbell.continuity.client.resource.SpriteLoaderStitchContext;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.atlas.SpriteResourceLoader;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SpriteLoader.class})
abstract class SpriteLoaderMixin {
    @Shadow
    @Final
    private ResourceLocation location;

    SpriteLoaderMixin() {
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @ModifyArg(method={"load(Lnet/minecraft/resource/ResourceManager;Lnet/minecraft/util/Identifier;ILjava/util/concurrent/Executor;Ljava/util/Collection;)Ljava/util/concurrent/CompletableFuture;"}, at=@At(value="INVOKE", target="Ljava/util/concurrent/CompletableFuture;supplyAsync(Ljava/util/function/Supplier;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;", ordinal=0), index=0)
    private Supplier<List<Function<SpriteResourceLoader, SpriteContents>>> continuity$modifySupplier(Supplier<List<Function<SpriteResourceLoader, SpriteContents>>> supplier) {
        SpriteLoaderLoadContext context = SpriteLoaderLoadContext.THREAD_LOCAL.get();
        if (context != null) {
            CompletableFuture<@Nullable Set<ResourceLocation>> extraIdsFuture = context.getExtraIdsFuture(this.location);
            SpriteLoaderLoadContext.EmissiveControl emissiveControl = context.getEmissiveControl(this.location);
            if (emissiveControl != null) {
                return () -> {
                    AtlasLoaderInitContext.THREAD_LOCAL.set(extraIdsFuture::join);
                    AtlasLoaderLoadContext.THREAD_LOCAL.set(emissiveControl::setEmissiveIdMap);
                    @Nullable List list = (List)supplier.get();
                    AtlasLoaderInitContext.THREAD_LOCAL.set(null);
                    AtlasLoaderLoadContext.THREAD_LOCAL.set(null);
                    return list;
                };
            }
            return () -> {
                AtlasLoaderInitContext.THREAD_LOCAL.set(extraIdsFuture::join);
                List list = (List)supplier.get();
                AtlasLoaderInitContext.THREAD_LOCAL.set(null);
                return list;
            };
        }
        return supplier;
    }

    @ModifyArg(method={"load(Lnet/minecraft/resource/ResourceManager;Lnet/minecraft/util/Identifier;ILjava/util/concurrent/Executor;Ljava/util/Collection;)Ljava/util/concurrent/CompletableFuture;"}, at=@At(value="INVOKE", target="Ljava/util/concurrent/CompletableFuture;thenApply(Ljava/util/function/Function;)Ljava/util/concurrent/CompletableFuture;", ordinal=0), index=0)
    private Function<List<SpriteContents>, SpriteLoader.Preparations> continuity$modifyFunction(Function<List<SpriteContents>, SpriteLoader.Preparations> function) {
        SpriteLoaderLoadContext.EmissiveControl emissiveControl;
        SpriteLoaderLoadContext context = SpriteLoaderLoadContext.THREAD_LOCAL.get();
        if (context != null && (emissiveControl = context.getEmissiveControl(this.location)) != null) {
            return spriteContentsList -> {
                final Map<ResourceLocation, ResourceLocation> emissiveIdMap = emissiveControl.getEmissiveIdMap();
                if (emissiveIdMap != null) {
                    SpriteLoaderStitchContext.THREAD_LOCAL.set(new SpriteLoaderStitchContext(){

                        @Override
                        public Map<ResourceLocation, ResourceLocation> getEmissiveIdMap() {
                            return emissiveIdMap;
                        }

                        @Override
                        public void markHasEmissives() {
                            emissiveControl.markHasEmissives();
                        }
                    });
                    SpriteLoader.Preparations result = (SpriteLoader.Preparations)function.apply((List<SpriteContents>)spriteContentsList);
                    SpriteLoaderStitchContext.THREAD_LOCAL.set(null);
                    return result;
                }
                return (SpriteLoader.Preparations)function.apply((List<SpriteContents>)spriteContentsList);
            };
        }
        return function;
    }

    @Inject(method={"stitch(Ljava/util/List;ILjava/util/concurrent/Executor;)Lnet/minecraft/client/texture/SpriteLoader$StitchResult;"}, at={@At(value="RETURN")})
    private void continuity$onReturnStitch(List<SpriteContents> spriteContentsList, int mipmapLevels, Executor executor, CallbackInfoReturnable<SpriteLoader.Preparations> cir) {
        SpriteLoaderStitchContext context = SpriteLoaderStitchContext.THREAD_LOCAL.get();
        if (context != null) {
            Map<ResourceLocation, ResourceLocation> emissiveIdMap = context.getEmissiveIdMap();
            Map sprites = ((SpriteLoader.Preparations)cir.getReturnValue()).regions();
            emissiveIdMap.forEach((id, emissiveId) -> {
                TextureAtlasSprite emissiveSprite;
                TextureAtlasSprite sprite = (TextureAtlasSprite)sprites.get(id);
                if (sprite != null && (emissiveSprite = (TextureAtlasSprite)sprites.get(emissiveId)) != null) {
                    ((SpriteExtension)sprite).continuity$setEmissiveSprite(emissiveSprite);
                    context.markHasEmissives();
                }
            });
        }
    }
}

