/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.processor;

import me.pepperbell.continuity.client.processor.OrientationMode;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.ArrayUtils;

public final class DirectionMaps {
    public static final Direction[][][] DIRECTION_MAPS = new Direction[6][8][];

    public static Direction[][] getMap(Direction direction) {
        return DIRECTION_MAPS[direction.ordinal()];
    }

    public static Direction[] getDirections(OrientationMode orientationMode, QuadView quad, BlockState state) {
        return DirectionMaps.getMap(quad.lightFace())[orientationMode.getOrientation(quad, state)];
    }

    static {
        for (Direction face : Direction.values()) {
            Direction textureUp = face == Direction.UP ? Direction.NORTH : (face == Direction.DOWN ? Direction.SOUTH : Direction.UP);
            Direction textureLeft = face.getAxisDirection() == Direction.AxisDirection.NEGATIVE ? textureUp.getClockWise(face.getAxis()) : textureUp.getCounterClockWise(face.getAxis());
            Direction[][] map = DIRECTION_MAPS[face.ordinal()];
            map[0] = new Direction[]{textureLeft, textureUp.getOpposite(), textureLeft.getOpposite(), textureUp};
            map[1] = (Direction[])map[0].clone();
            ArrayUtils.shift((Object[])map[1], (int)-1);
            map[2] = (Direction[])map[1].clone();
            ArrayUtils.shift((Object[])map[2], (int)-1);
            map[3] = (Direction[])map[2].clone();
            ArrayUtils.shift((Object[])map[3], (int)-1);
            map[4] = (Direction[])map[0].clone();
            ArrayUtils.reverse((Object[])map[4]);
            map[5] = (Direction[])map[4].clone();
            ArrayUtils.shift((Object[])map[5], (int)1);
            map[6] = (Direction[])map[5].clone();
            ArrayUtils.shift((Object[])map[6], (int)1);
            map[7] = (Direction[])map[6].clone();
            ArrayUtils.shift((Object[])map[7], (int)1);
        }
    }
}

