/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.processor;

import java.util.function.Supplier;
import me.pepperbell.continuity.api.client.QuadProcessor;
import me.pepperbell.continuity.client.processor.AbstractQuadProcessor;
import me.pepperbell.continuity.client.processor.AbstractQuadProcessorFactory;
import me.pepperbell.continuity.client.processor.BaseProcessingPredicate;
import me.pepperbell.continuity.client.processor.ConnectionPredicate;
import me.pepperbell.continuity.client.processor.ProcessingDataKeys;
import me.pepperbell.continuity.client.processor.ProcessingPredicate;
import me.pepperbell.continuity.client.processor.simple.SimpleQuadProcessor;
import me.pepperbell.continuity.client.properties.ConnectingCtmProperties;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class TopQuadProcessor
extends AbstractQuadProcessor {
    protected ConnectionPredicate connectionPredicate;
    protected boolean innerSeams;

    public TopQuadProcessor(TextureAtlasSprite[] sprites, ProcessingPredicate processingPredicate, ConnectionPredicate connectionPredicate, boolean innerSeams) {
        super(sprites, processingPredicate);
        this.connectionPredicate = connectionPredicate;
        this.innerSeams = innerSeams;
    }

    @Override
    public QuadProcessor.ProcessingResult processQuadInner(MutableQuadView quad, TextureAtlasSprite sprite, BlockAndTintGetter blockView, BlockState appearanceState, BlockState state, BlockPos pos, Supplier<RandomSource> randomSupplier, int pass, QuadProcessor.ProcessingContext context) {
        Direction lightFace = quad.lightFace();
        Direction.Axis axis = appearanceState.hasProperty((Property)BlockStateProperties.AXIS) ? (Direction.Axis)appearanceState.getValue((Property)BlockStateProperties.AXIS) : Direction.Axis.Y;
        if (lightFace.getAxis() != axis) {
            Direction up = Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
            BlockPos.MutableBlockPos mutablePos = context.getData(ProcessingDataKeys.MUTABLE_POS).setWithOffset((Vec3i)pos, up);
            if (this.connectionPredicate.shouldConnect(blockView, appearanceState, state, pos, mutablePos, lightFace, sprite, this.innerSeams)) {
                return SimpleQuadProcessor.process(quad, sprite, this.sprites[0]);
            }
        }
        return QuadProcessor.ProcessingResult.NEXT_PROCESSOR;
    }

    public static class Factory
    extends AbstractQuadProcessorFactory<ConnectingCtmProperties> {
        @Override
        public QuadProcessor createProcessor(ConnectingCtmProperties properties, TextureAtlasSprite[] sprites) {
            return new TopQuadProcessor(sprites, BaseProcessingPredicate.fromProperties(properties), properties.getConnectionPredicate(), properties.getInnerSeams());
        }

        @Override
        public int getTextureAmount(ConnectingCtmProperties properties) {
            return 1;
        }
    }
}

